/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.fs.impl;

import com.vmware.vim.zeppelin.cr.auth.CRAuthManager;
import com.vmware.vim.zeppelin.cr.fs.CRFileSystem;
import com.vmware.vim.zeppelin.cr.fs.CRFileSystemFactory;
import com.vmware.vim.zeppelin.cr.fs.impl.FSConfig;
import com.vmware.vim.zeppelin.cr.fs.impl.FSFileSystemImpl;
import com.vmware.vim.zeppelin.cr.fs.impl.exception.CRInvalidConfigurationException;
import com.vmware.vim.zeppelin.cr.fs.util.StringUtils;
import java.io.File;
import java.util.Map;

public class FSFileSystemFactory
implements CRFileSystemFactory {
    public static String FS_DIR = "FS_DIR";
    public static String FS_BACKUP_DIR = "FS_BACKUP_DIR";
    public static String FS_MAX_FILE_SIZE = "FS_MAX_FILE_SIZE";
    public static String FS_USE_JAVA_LOCKING = "FS_JAVA_LOCKING";
    private volatile FSConfig _config;
    private volatile CRAuthManager _authManager;

    public void init(Map<String, Object> configParams, CRAuthManager authManager) {
        if (configParams == null) {
            throw new CRInvalidConfigurationException("The configuration cannot be null.");
        }
        File rootDir = this.getRootDirFromConfigParams(configParams);
        File backupDir = this.getBackupDirFromConfigParams(configParams);
        Long maxFileSize = this.getMaxFileSizeFromConfigParams(configParams);
        boolean useJavaLocking = this.getUseJavaLockingFromConfigParams(configParams);
        this._config = new FSConfig(rootDir, backupDir, maxFileSize, useJavaLocking);
        this._authManager = authManager;
    }

    private File getRootDirFromConfigParams(Map<String, Object> configParams) {
        Object oRootDir = configParams.get(FS_DIR);
        if (oRootDir == null) {
            throw new CRInvalidConfigurationException("The configuration doesn't contain the mandatory '" + FS_DIR + "' configuration parameter.");
        }
        if (!(oRootDir instanceof String)) {
            throw new CRInvalidConfigurationException("The '" + FS_DIR + "' configuration parameter must be a String containing " + "the name of the root directory. The type specified in " + "the configuration is: " + oRootDir.getClass().getName());
        }
        String sRootDir = (String)oRootDir;
        if (StringUtils.isBlank(sRootDir)) {
            throw new CRInvalidConfigurationException("The configuration contains a blank '" + FS_DIR + "' configuration parameter.");
        }
        File rootDir = new File(sRootDir);
        if (rootDir.exists()) {
            if (!rootDir.isDirectory()) {
                throw new CRInvalidConfigurationException("The specified '" + FS_DIR + "' configuration parameter points to a file, not a directory: " + sRootDir);
            }
        } else {
            rootDir.mkdir();
        }
        return rootDir;
    }

    private File getBackupDirFromConfigParams(Map<String, Object> configParams) {
        Object oBackupDir = configParams.get(FS_BACKUP_DIR);
        if (oBackupDir == null) {
            return null;
        }
        if (!(oBackupDir instanceof String)) {
            throw new CRInvalidConfigurationException("The '" + FS_BACKUP_DIR + "' configuration parameter must be a String containing " + "the name of the backup directory. The type specified in " + "the configuration is: " + oBackupDir.getClass().getName());
        }
        String sBackupDir = (String)oBackupDir;
        if (StringUtils.isBlank(sBackupDir)) {
            return null;
        }
        File backupDir = new File(sBackupDir);
        if (backupDir.exists()) {
            if (!backupDir.isDirectory()) {
                throw new CRInvalidConfigurationException("The specified '" + FS_BACKUP_DIR + "' configuration parameter points to a file, not a directory: " + sBackupDir);
            }
        } else {
            backupDir.mkdir();
        }
        return backupDir;
    }

    private Long getMaxFileSizeFromConfigParams(Map<String, Object> configParams) {
        Long maxFileSize = null;
        Object oMaxFileSize = configParams.get(FS_MAX_FILE_SIZE);
        if (oMaxFileSize != null) {
            if (oMaxFileSize instanceof Number) {
                maxFileSize = ((Number)oMaxFileSize).longValue();
            } else if (oMaxFileSize instanceof String) {
                try {
                    maxFileSize = Long.valueOf((String)oMaxFileSize);
                }
                catch (Exception e) {
                    throw new CRInvalidConfigurationException("The '" + FS_MAX_FILE_SIZE + "' configuration parameter is not a valid number:  " + oMaxFileSize);
                }
            } else {
                throw new CRInvalidConfigurationException("The '" + FS_MAX_FILE_SIZE + "' configuration parameter must be a number containing the " + "maximum file size. The type specified in the configuration is: " + oMaxFileSize.getClass().getName());
            }
        }
        return maxFileSize;
    }

    private boolean getUseJavaLockingFromConfigParams(Map<String, Object> configParams) {
        boolean javaLocking = false;
        Object oJavaLocking = configParams.get(FS_USE_JAVA_LOCKING);
        if (oJavaLocking != null) {
            if (oJavaLocking instanceof Boolean) {
                javaLocking = (Boolean)oJavaLocking;
            } else if (oJavaLocking instanceof String) {
                try {
                    javaLocking = this.parseStringToBoolean((String)oJavaLocking);
                }
                catch (Exception e) {
                    throw new CRInvalidConfigurationException("The '" + FS_USE_JAVA_LOCKING + "' configuration parameter is not a valid boolean value: " + oJavaLocking + ".\nExpected 'true' or 'false' (case-insensitive').");
                }
            } else {
                throw new CRInvalidConfigurationException("The '" + FS_USE_JAVA_LOCKING + "' configuration parameter must be parseable to a boolean value." + " The type specified in the configuration is: " + oJavaLocking.getClass().getName());
            }
        }
        return javaLocking;
    }

    private boolean parseStringToBoolean(String str) {
        assert (str != null);
        if ("true".equalsIgnoreCase(str)) {
            return true;
        }
        if ("false".equalsIgnoreCase(str)) {
            return false;
        }
        throw new IllegalArgumentException("Cannot parse to boolean: " + str);
    }

    public CRFileSystem newFileSystemHandle() {
        return new FSFileSystemImpl(this._config, this._authManager);
    }

    public void close() {
    }

    FSConfig getConfig() {
        return this._config;
    }

    CRAuthManager getAuthManager() {
        return this._authManager;
    }
}

