/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.fs.impl;

import com.vmware.vim.zeppelin.cr.auth.CRAccessControl;
import com.vmware.vim.zeppelin.cr.auth.CRAuthManager;
import com.vmware.vim.zeppelin.cr.auth.CRUser;
import com.vmware.vim.zeppelin.cr.exception.CRAccessDeniedException;
import com.vmware.vim.zeppelin.cr.exception.CRException;
import com.vmware.vim.zeppelin.cr.exception.CRFileExistsException;
import com.vmware.vim.zeppelin.cr.exception.CRFileNotExistsException;
import com.vmware.vim.zeppelin.cr.exception.CRFolderNotEmptyException;
import com.vmware.vim.zeppelin.cr.exception.CRInvalidNodePathException;
import com.vmware.vim.zeppelin.cr.exception.CRRuntimeException;
import com.vmware.vim.zeppelin.cr.fs.CRFileData;
import com.vmware.vim.zeppelin.cr.fs.CRFileSystem;
import com.vmware.vim.zeppelin.cr.fs.impl.AuthUtils;
import com.vmware.vim.zeppelin.cr.fs.impl.FSConfig;
import com.vmware.vim.zeppelin.cr.fs.impl.FSFileRevisionWithExtendedMetaData;
import com.vmware.vim.zeppelin.cr.fs.impl.FSFileSystemImplForOlderVersion;
import com.vmware.vim.zeppelin.cr.fs.impl.Permission;
import com.vmware.vim.zeppelin.cr.fs.impl.exception.CRIOException;
import com.vmware.vim.zeppelin.cr.fs.io.ChannelInputStream;
import com.vmware.vim.zeppelin.cr.fs.io.ChannelOutputStream;
import com.vmware.vim.zeppelin.cr.fs.util.FileUtils;
import com.vmware.vim.zeppelin.cr.fs.util.Utils;
import com.vmware.vim.zeppelin.cr.node.CRFileNode;
import com.vmware.vim.zeppelin.cr.node.CRFolderNode;
import com.vmware.vim.zeppelin.cr.node.CRNode;
import com.vmware.vim.zeppelin.cr.node.CRRootNode;
import com.vmware.vim.zeppelin.cr.search.CRSearchQuery;
import com.vmware.vim.zeppelin.cr.versionctrl.CRChangeset;
import com.vmware.vim.zeppelin.cr.versionctrl.CRChangesetCommand;
import com.vmware.vim.zeppelin.cr.versionctrl.CRFileRevision;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class FSFileSystemImpl
implements CRFileSystem {
    private static final int REPOSITORY_FILE_MARKER = -557122866;
    private static final short FS_IMPLEMENTATION_VERSION = 1;
    static final int DUMMY_REVISION_NUMBER = 1;
    private static final String FILE_NAME_FOLDER_PERMISSIONS = ".permissions";
    public static final long DEFAULT_MAX_FILE_SIZE = 0x500000L;
    private static final int FILE_IO_BUFFER_SIZE = 4096;
    private final File _rootDir;
    private final File _backupDir;
    private final CRRootNode _rootNode;
    private final long _maxFileSize;
    private final CRAuthManager _authManager;
    private CRUser _user;
    private final LockManager _lockManager;

    FSFileSystemImpl(FSConfig config, CRAuthManager authManager) {
        this._rootDir = config.getRootDir();
        this._backupDir = config.getBackupDir();
        this._rootNode = new CRRootNode(null, CRNode.NODE_ROOT, CRNode.NODE_ROOT, FSFileSystemImpl.getFileOrFolderCreationDate(this._rootDir), this.getFolderACLs(this._rootDir, CRNode.NODE_ROOT));
        Long maxFileSize = config.getMaxFileSize();
        this._maxFileSize = maxFileSize == null ? 0x500000L : (maxFileSize > 0L ? maxFileSize : Long.MAX_VALUE);
        this._authManager = authManager;
        this._user = authManager.getCurrentUser();
        boolean useJavaLocking = config.mustUseJavaLocking();
        this._lockManager = new LockManager(useJavaLocking);
    }

    public void setUser(CRUser user) {
        this._user = user;
    }

    CRUser getUser() {
        return this._user;
    }

    public void close() {
    }

    private boolean isAllowed(Set<CRAccessControl> acls, Permission permission) {
        if (this._authManager != null && acls != null) {
            return this._authManager.isAllowed(this._user, acls, permission.getIntValue());
        }
        return true;
    }

    private void assertIsAllowed(String nodePath, Set<CRAccessControl> acls, Permission permission) throws CRAccessDeniedException {
        if (acls != null && !this.isAllowed(acls, permission)) {
            throw new CRAccessDeniedException("User " + this._user.getName() + " doesn't have " + permission.getDescription() + " privileges on node " + nodePath);
        }
    }

    static Date getFileOrFolderCreationDate(File f) {
        return new Date(f.lastModified());
    }

    private Set<CRAccessControl> getFolderACLs(File dir, String dirNodePath) {
        return null;
    }

    private boolean isSpecialFileName(String fileName) {
        return FILE_NAME_FOLDER_PERMISSIONS.equals(fileName);
    }

    private void assertNotSpecialFileName(String fileName) throws CRIOException {
        if (this.isSpecialFileName(fileName)) {
            throw new CRIOException("The file name '" + fileName + "' is reserved for special purposes.");
        }
    }

    public boolean exists(String nodePath) {
        Utils.assertPathIsValid(nodePath);
        String escapedNodePath = Utils.escapeNodePath(nodePath);
        File f = new File(this._rootDir, escapedNodePath);
        return f.exists();
    }

    private boolean hasChildren(File f, String nodePath) {
        try {
            FileUtils.assertExistsAndIsDirectory(f, nodePath);
        }
        catch (CRFileNotExistsException e) {
            return false;
        }
        String[] children = f.list();
        return children.length > 0;
    }

    public boolean hasChildren(String nodePath) {
        Utils.assertPathIsValid(nodePath);
        String escapedNodePath = Utils.escapeNodePath(nodePath);
        File f = new File(this._rootDir, escapedNodePath);
        return this.hasChildren(f, nodePath);
    }

    public boolean isFolder(String nodePath) {
        Utils.assertPathIsValid(nodePath);
        String escapedNodePath = Utils.escapeNodePath(nodePath);
        File f = new File(this._rootDir, escapedNodePath);
        return f.isDirectory();
    }

    public boolean isFile(String nodePath) {
        Utils.assertPathIsValid(nodePath);
        String escapedNodePath = Utils.escapeNodePath(nodePath);
        File f = new File(this._rootDir, escapedNodePath);
        return f.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CRNode getFolderNode(String nodePath, boolean checkACLs, String escapedNodePath) throws CRAccessDeniedException {
        if (CRNode.NODE_ROOT.equals(nodePath)) {
            return this._rootNode;
        }
        if (escapedNodePath == null) {
            escapedNodePath = Utils.escapeNodePath(nodePath);
        }
        File f = new File(this._rootDir, escapedNodePath);
        this._lockManager.acquireReadLock(f);
        try {
            if (f.exists() && f.isDirectory()) {
                Set<CRAccessControl> acls = null;
                if (checkACLs) {
                    acls = this.getFolderACLs(f, nodePath);
                    this.assertIsAllowed(nodePath, acls, Permission.READ);
                }
                CRFolderNode cRFolderNode = new CRFolderNode(null, Utils.getNodeName(nodePath), nodePath, FSFileSystemImpl.getFileOrFolderCreationDate(f), (CRFolderNode)this.getFolderNode(Utils.getParentNodePath(nodePath)), acls);
                return cRFolderNode;
            }
        }
        finally {
            this._lockManager.releaseReadLock(f);
        }
        return null;
    }

    public CRNode getFolderNode(String nodePath) throws CRAccessDeniedException {
        Utils.assertPathIsValid(nodePath);
        return this.getFolderNode(nodePath, true, null);
    }

    private void getChildFolders(File folder, boolean includeSubtree, String nodePath, List<CRFolderNode> childFolders, CRFolderNode folderNode) {
        String[] childrenNames;
        for (String childName : childrenNames = folder.list()) {
            String unescapedChildName;
            String childNodePath;
            Set<CRAccessControl> acls;
            File childFile = new File(folder, childName);
            if (!childFile.isDirectory() || !this.isAllowed(acls = this.getFolderACLs(childFile, childNodePath = Utils.appendNameToNodePath(nodePath, unescapedChildName = Utils.unescapeFileName(childName))), Permission.READ)) continue;
            CRFolderNode childNode = new CRFolderNode(null, unescapedChildName, childNodePath, FSFileSystemImpl.getFileOrFolderCreationDate(childFile), folderNode, acls);
            childFolders.add(childNode);
            if (!includeSubtree) continue;
            this.getChildFolders(childFile, includeSubtree, childNodePath, childFolders, childNode);
        }
    }

    public List<CRFolderNode> listFolders(String nodePath, boolean includeSubtree) {
        Utils.assertPathIsValid(nodePath);
        String escapedNodePath = Utils.escapeNodePath(nodePath);
        File folder = new File(this._rootDir, escapedNodePath);
        if (folder.isDirectory()) {
            ArrayList<CRFolderNode> childFolders = new ArrayList<CRFolderNode>();
            CRFolderNode folderNode = null;
            try {
                folderNode = (CRFolderNode)this.getFolderNode(nodePath, false, escapedNodePath);
                this.getChildFolders(folder, includeSubtree, nodePath, childFolders, folderNode);
            }
            catch (CRAccessDeniedException e) {
                // empty catch block
            }
            if (childFolders.isEmpty()) {
                return null;
            }
            return childFolders;
        }
        throw new CRInvalidNodePathException("Path is a file, not a directory: " + nodePath);
    }

    private CRFileNode getFileNode(String nodePath, CRFolderNode parentNode, boolean computeParentNode, boolean checkACLs) throws CRAccessDeniedException {
        RevisionData rd = this.getLatestFileRevision(nodePath, false, checkACLs, null, true);
        if (rd == null) {
            return null;
        }
        Set<CRAccessControl> acls = rd.getACLs();
        LinkedList<CRFileRevision> revisions = new LinkedList<CRFileRevision>();
        revisions.add(rd.getRevision());
        if (computeParentNode) {
            String parentNodePath = Utils.getParentNodePath(nodePath);
            parentNode = (CRFolderNode)this.getFolderNode(parentNodePath, true, null);
        }
        return new CRFileNode(null, rd.getNodeName(), rd.getNodePath(), rd.getCreationDate(), parentNode, revisions, acls);
    }

    public CRFileNode getFileNode(String nodePath) throws CRAccessDeniedException {
        Utils.assertPathIsValid(nodePath);
        return this.getFileNode(nodePath, null, true, true);
    }

    private void getChildFiles(File folder, boolean includeSubtree, String nodePath, List<CRFileNode> childFiles, CRFolderNode folderNode, CRSearchQuery query) {
        String[] childrenNames;
        for (String childName : childrenNames = folder.list()) {
            String unescapedChildName;
            File childFile = new File(folder, childName);
            if (childFile.isDirectory()) {
                if (!includeSubtree) continue;
                unescapedChildName = Utils.unescapeFileName(childName);
                String childDirNodePath = Utils.appendNameToNodePath(nodePath, unescapedChildName);
                CRFolderNode childDirNode = new CRFolderNode(null, unescapedChildName, childDirNodePath, FSFileSystemImpl.getFileOrFolderCreationDate(childFile), folderNode, this.getFolderACLs(childFile, childDirNodePath));
                this.getChildFiles(childFile, includeSubtree, childDirNodePath, childFiles, childDirNode, query);
                continue;
            }
            if (this.isSpecialFileName(childName)) continue;
            unescapedChildName = Utils.unescapeFileName(childName);
            String childNodePath = Utils.appendNameToNodePath(nodePath, unescapedChildName);
            try {
                CRFileNode childNode = this.getFileNode(childNodePath, folderNode, false, true);
                if (childNode == null || query != null && !query.match(childNode.getRevision(0))) continue;
                childFiles.add(childNode);
            }
            catch (CRAccessDeniedException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public List<CRFileNode> listFiles(String nodePath, boolean includeSubtree, CRSearchQuery query) {
        Utils.assertPathIsValid(nodePath);
        String escapedNodePath = Utils.escapeNodePath(nodePath);
        File folder = new File(this._rootDir, escapedNodePath);
        if (folder.isDirectory()) {
            CRFolderNode folderNode = null;
            try {
                folderNode = (CRFolderNode)this.getFolderNode(nodePath, false, escapedNodePath);
            }
            catch (CRAccessDeniedException e) {
                return Collections.emptyList();
            }
            ArrayList<CRFileNode> childFiles = new ArrayList<CRFileNode>();
            this.getChildFiles(folder, includeSubtree, nodePath, childFiles, folderNode, query);
            if (childFiles.isEmpty()) {
                return null;
            }
            return childFiles;
        }
        throw new CRInvalidNodePathException("Path is a file, not a directory: " + nodePath);
    }

    public List<CRFileNode> listFiles(String nodePath, boolean includeSubtree) {
        return this.listFiles(nodePath, includeSubtree, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RevisionData readRevision(FileChannel channel, String nodePath, Date revisionTimestamp, boolean onlyMetadata, boolean checkACLs, String escapedNodePath) throws CRAccessDeniedException {
        in = null;
        bis = null;
        dis = null;
        try {
            in = new ChannelInputStream(channel, false);
            bis = new BufferedInputStream(in, 4096);
            dis = new DataInputStream(bis);
            marker = dis.readInt();
            if (marker == -557122866) ** GOTO lbl44
            hi = (short)(marker >>> 16);
            lo = (short)(marker & 65535);
            if (hi == -21267 || lo == 5) {
                channel.position(0L);
                var13_18 = FSFileSystemImplForOlderVersion.getLatestFileRevision(this._rootDir, this._authManager, this._user, channel, revisionTimestamp, nodePath, onlyMetadata, true, checkACLs, escapedNodePath);
            }
            ** GOTO lbl-1000
        }
        catch (CRAccessDeniedException e) {
            try {
                throw e;
                catch (Exception e) {
                    exists = true;
                    try {
                        exists = this.exists(nodePath);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    v0 = new StringBuilder().append("Failed to read file");
                    if (exists) {
                        v1 = "";
                        throw new CRIOException(v0.append(v1).append(": ").append(nodePath).toString(), e);
                    }
                    v1 = " (doesn't exist)";
                    throw new CRIOException(v0.append(v1).append(": ").append(nodePath).toString(), e);
                }
            }
            catch (Throwable var20_29) {
                Utils.close(dis);
                Utils.close(bis);
                Utils.close(in);
                throw var20_29;
            }
        }
        Utils.close(dis);
        Utils.close(bis);
        Utils.close(in);
        return var13_18;
lbl-1000:
        // 1 sources

        {
            throw new CRIOException("The file is not a repository file (missing marker): " + nodePath);
lbl44:
            // 1 sources

            version = dis.readShort();
            if (version != 1) {
                throw new CRIOException("Wrong version: " + version + ". Expected: " + 1);
            }
            stringACLs = dis.readUTF();
            acls = AuthUtils.stringToACLs(stringACLs);
            if (checkACLs) {
                this.assertIsAllowed(nodePath, acls, Permission.READ);
            }
            nodeName = dis.readUTF();
            dis.readUTF();
            numMetaDataEntries = dis.readInt();
            metaData = new HashMap<String, String>(numMetaDataEntries);
            for (i = 0; i < numMetaDataEntries; ++i) {
                key = dis.readUTF();
                value = dis.readUTF();
                metaData.put(key, value);
            }
            fileData = null;
            if (!onlyMetadata) {
                numDataBytes = dis.readInt();
                if ((long)numDataBytes > this._maxFileSize) {
                    throw new CRIOException("File contents too large: " + numDataBytes + " bytes. Maximum allowed: " + this._maxFileSize + " bytes.");
                }
                data = new byte[numDataBytes];
                if (numDataBytes < 0) {
                    throw new CRIOException("Currupt content - negative content length");
                }
                if (numDataBytes > 0) {
                    dis.readFully(data);
                }
                fileData = new CRFileData(data);
            }
            rev = new FSFileRevisionWithExtendedMetaData(null, 1, fileData, revisionTimestamp, metaData, nodeName, nodePath);
            var19_28 = new RevisionData(acls, rev, nodeName, nodePath, revisionTimestamp);
        }
        Utils.close(dis);
        Utils.close(bis);
        Utils.close(in);
        return var19_28;
    }

    /*
     * Exception decompiling
     */
    private RevisionData getLatestFileRevision(String nodePath, boolean onlyMetadata, boolean checkACLs, String escapedNodePath, boolean javaLock) throws CRAccessDeniedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CRFileRevision getLatestFileRevision(String nodePath) throws CRAccessDeniedException {
        RevisionData rd = this.getLatestFileRevision(nodePath, false, true, null, true);
        if (rd == null) {
            return null;
        }
        return rd.getRevision();
    }

    Map<String, String> getFileMetadata(String nodePath, String escapedNodePath) throws CRAccessDeniedException {
        RevisionData rd = this.getLatestFileRevision(nodePath, true, true, escapedNodePath, true);
        if (rd == null) {
            return null;
        }
        return rd.getRevision().getFileMetaData();
    }

    public CRFileRevision getFileRevision(String nodePath, int revisionNum) throws CRAccessDeniedException {
        CRFileRevision rev = this.getLatestFileRevision(nodePath);
        return rev;
    }

    public void commitChangeset(CRChangeset changeset) throws CRException {
        if (changeset == null) {
            return;
        }
        try {
            List actions = changeset.listActions();
            for (CRChangesetCommand action : actions) {
                action.execute((CRFileSystem)this);
            }
        }
        catch (CRException e) {
            throw e;
        }
        catch (CRRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CRRuntimeException((Throwable)e);
        }
    }

    private void createDir(File f, List<CRAccessControl> acls, String nodePath) throws CRIOException {
        boolean success = this.mkdirs(f);
        if (!success) {
            throw new CRIOException("Failed to create folder: " + nodePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFolder(String[] subDirs, List<CRAccessControl> newACLs) throws CRIOException, CRAccessDeniedException {
        File currDir = this._rootDir;
        StringBuilder sbPath = new StringBuilder();
        sbPath.append(CRNode.NODE_ROOT);
        int total = subDirs.length;
        for (int i = 0; i < total; ++i) {
            String escapedDirName = Utils.escapeFileName(subDirs[i]);
            File newDir = new File(currDir, escapedDirName);
            this._lockManager.acquireWriteLock(newDir);
            try {
                if (i > 0) {
                    sbPath.append(CRNode.NODE_PATH_SEPARATOR);
                }
                sbPath.append(subDirs[i]);
                String path = sbPath.toString();
                if (!newDir.exists()) {
                    this.createDir(newDir, newACLs, path);
                } else {
                    FileUtils.assertIsDirectory(newDir, path);
                    Set<CRAccessControl> folderACLs = this.getFolderACLs(newDir, path);
                    this.assertIsAllowed(path, folderACLs, Permission.READ_WRITE);
                }
                currDir = newDir;
                continue;
            }
            finally {
                this._lockManager.releaseWriteLock(newDir);
            }
        }
    }

    public void addFolder(String nodePath, List<CRAccessControl> acls) throws CRIOException, CRAccessDeniedException {
        Utils.assertPathIsValid(nodePath);
        if (CRNode.NODE_ROOT.equals(nodePath)) {
            return;
        }
        String[] subDirs = nodePath.substring(1).split(CRNode.NODE_PATH_SEPARATOR);
        this.addFolder(subDirs, acls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFolder(String nodePath) throws CRAccessDeniedException, CRFolderNotEmptyException {
        Utils.assertPathIsValid(nodePath);
        String escapedNodePath = Utils.escapeNodePath(nodePath);
        File folder = new File(this._rootDir, escapedNodePath);
        this._lockManager.acquireWriteLock(folder);
        try {
            FileUtils.assertIsDirectory(folder, nodePath);
            this.assertIsAllowed(nodePath, this.getFolderACLs(folder, nodePath), Permission.READ_WRITE);
            if (this.hasChildren(folder, nodePath)) {
                throw new CRFolderNotEmptyException("Cannot delete folder because it is not empty: " + nodePath);
            }
            boolean success = folder.delete();
            if (!success) {
                throw new CRIOException("Failed to delete folder: " + nodePath);
            }
        }
        finally {
            this._lockManager.releaseWriteLock(folder);
        }
    }

    private CRFileRevision writeRevision(FileChannel channel, String nodePath, Collection<CRAccessControl> acls, CRFileData data, Map<String, String> metaData) throws CRIOException {
        String nodeName = Utils.getNodeName(nodePath);
        ChannelOutputStream out = null;
        BufferedOutputStream bos = null;
        DataOutputStream dos = null;
        try {
            out = new ChannelOutputStream(channel, false);
            bos = new BufferedOutputStream(out, 4096);
            dos = new DataOutputStream(bos);
            dos.writeInt(-557122866);
            dos.writeShort(1);
            int numACLs = acls != null ? acls.size() + 1 : 1;
            HashSet<CRAccessControl> fileACLs = new HashSet<CRAccessControl>(numACLs);
            if (acls != null) {
                fileACLs.addAll(acls);
            }
            fileACLs.add(new CRAccessControl(this._user, Permission.READ_WRITE.getIntValue()));
            String strACLs = AuthUtils.aclsToString(fileACLs);
            dos.writeUTF(strACLs);
            dos.writeUTF(nodeName != null ? nodeName : "");
            dos.writeUTF(nodePath != null ? nodePath : "");
            if (metaData != null) {
                dos.writeInt(metaData.size());
                for (String key : metaData.keySet()) {
                    dos.writeUTF(key);
                    String value = metaData.get(key);
                    dos.writeUTF(value != null ? value : "");
                }
            } else {
                dos.writeInt(0);
            }
            byte[] objData = data.getObjData();
            if (objData != null && objData.length > 0) {
                dos.writeInt(objData.length);
                dos.write(data.getObjData());
            } else {
                dos.writeInt(0);
            }
            dos.flush();
        }
        catch (Exception e) {
            try {
                throw new CRIOException("Failed to create file: " + nodePath, e);
            }
            catch (Throwable throwable) {
                Utils.close(dos);
                Utils.close(bos);
                Utils.close(out);
                throw throwable;
            }
        }
        Utils.close(dos);
        Utils.close(bos);
        Utils.close(out);
        return new FSFileRevisionWithExtendedMetaData(null, 1, data, new Date(), metaData, nodeName, nodePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CRFileRevision createFile(File file, String nodePath, List<CRAccessControl> acls, CRFileData data, Map<String, String> metaData) throws CRIOException {
        RandomAccessFile raf = null;
        boolean gotFileLock = false;
        this._lockManager.acquireWriteLock(file);
        try {
            CRFileRevision cRFileRevision;
            try {
                CRFileRevision rev;
                raf = new RandomAccessFile(file, "rw");
                FileChannel channel = raf.getChannel();
                FileUtils.getFileLock(channel, 15000L, true);
                gotFileLock = true;
                channel.truncate(0L);
                channel.position(0L);
                cRFileRevision = rev = this.writeRevision(channel, nodePath, acls, data, metaData);
            }
            catch (Throwable throwable) {
                try {
                    Utils.close(raf);
                    throw throwable;
                }
                catch (Exception e) {
                    if (gotFileLock) {
                        file.delete();
                    }
                    throw new CRIOException("Failed to create file: " + nodePath + "\nActual path in the file system: " + file.getAbsolutePath(), e);
                }
            }
            Utils.close(raf);
            return cRFileRevision;
        }
        finally {
            this._lockManager.releaseWriteLock(file);
        }
    }

    private CRFileRevision addFile(String nodePath, List<CRAccessControl> acls, CRFileData data, Map<String, String> metaData, String escapedNodePath) throws CRAccessDeniedException, CRFileExistsException, CRIOException {
        File newFile;
        Utils.assertPathIsValid(nodePath);
        if (escapedNodePath == null) {
            escapedNodePath = Utils.escapeNodePath(nodePath);
        }
        if ((newFile = new File(this._rootDir, escapedNodePath)).exists()) {
            if (newFile.isDirectory()) {
                throw new CRInvalidNodePathException("Cannot add file. The specified file already exists and is a folder: " + nodePath);
            }
            throw new CRFileExistsException("File already exists: " + nodePath);
        }
        this.addFolder(Utils.getParentNodePath(nodePath), acls);
        return this.createFile(newFile, nodePath, acls, data, metaData);
    }

    public CRFileRevision addFile(String nodePath, List<CRAccessControl> acls, CRFileData data, Map<String, String> metaData) throws CRAccessDeniedException, CRFileExistsException, CRIOException {
        return this.addFile(nodePath, acls, data, metaData, null);
    }

    public CRFileRevision addFile(String nodePath, List<CRAccessControl> acls, CRFileData data) throws CRAccessDeniedException, CRFileExistsException {
        return this.addFile(nodePath, acls, data, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFile(String nodePath, String escapedNodePath) throws CRAccessDeniedException {
        block7: {
            Utils.assertPathIsValid(nodePath);
            if (escapedNodePath == null) {
                escapedNodePath = Utils.escapeNodePath(nodePath);
            }
            File file = new File(this._rootDir, escapedNodePath);
            this._lockManager.acquireWriteLock(file);
            try {
                this.assertNotSpecialFileName(file.getName());
                if (file.exists()) {
                    if (file.isDirectory()) {
                        throw new CRInvalidNodePathException("The specified path '" + nodePath + "' is a directory, not a file.");
                    }
                    Set<CRAccessControl> acls = this.getFileACLs(nodePath, false);
                    this.assertIsAllowed(nodePath, acls, Permission.READ_WRITE);
                    boolean success = file.delete();
                    if (!success) {
                        boolean exists = file.exists();
                        throw new CRIOException("Failed to delete file" + (exists ? "" : " (doesn't exist)") + ": " + nodePath);
                    }
                    break block7;
                }
                throw new CRInvalidNodePathException("File not found: " + nodePath);
            }
            finally {
                this._lockManager.releaseWriteLock(file);
            }
        }
    }

    public void deleteFile(String nodePath) throws CRAccessDeniedException {
        this.deleteFile(nodePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CRFileRevision modifyFile(FileModificationOperation op, String nodePath, CRFileData data, Map<String, String> metaData, Collection<CRAccessControl> acls) throws CRAccessDeniedException, CRFileNotExistsException {
        CRFileRevision cRFileRevision;
        Utils.assertPathIsValid(nodePath);
        String escapedNodePath = Utils.escapeNodePath(nodePath);
        File file = new File(this._rootDir, escapedNodePath);
        File backupFile = null;
        this.assertNotSpecialFileName(file.getName());
        this._lockManager.acquireWriteLock(file);
        try {
            CRFileRevision rev;
            block51: {
                boolean mustDeleteFile;
                RandomAccessFile backupRaf;
                RandomAccessFile raf;
                block49: {
                    RevisionData rd;
                    boolean wroteIntoTheFile;
                    FileChannel backupChannel;
                    FileChannel channel;
                    block48: {
                        FileUtils.assertExistsAndIsFile(file, nodePath);
                        raf = null;
                        channel = null;
                        backupRaf = null;
                        backupChannel = null;
                        rev = null;
                        wroteIntoTheFile = false;
                        mustDeleteFile = false;
                        raf = new RandomAccessFile(file, "rw");
                        channel = raf.getChannel();
                        FileUtils.getFileLock(channel, 15000L, true);
                        Date creationDate = FSFileSystemImpl.getFileOrFolderCreationDate(file);
                        channel.position(0L);
                        rd = this.readRevision(channel, nodePath, creationDate, op == FileModificationOperation.UPDATE_FILE, true, escapedNodePath);
                        if (rd != null) break block48;
                        CRFileRevision cRFileRevision2 = null;
                        Utils.close(raf);
                        Utils.close(backupRaf);
                        if (mustDeleteFile) {
                            file.delete();
                        }
                        if (backupFile != null) {
                            backupFile.delete();
                        }
                        try {
                            this._lockManager.releaseWriteLock(file);
                            return cRFileRevision2;
                        }
                        finally {
                            if (backupFile != null) {
                                this._lockManager.releaseWriteLock(backupFile);
                            }
                        }
                    }
                    try {
                        rev = rd.getRevision();
                        boolean updateNecessary = false;
                        switch (op) {
                            case UPDATE_FILE: {
                                acls = rd.getACLs();
                                updateNecessary = true;
                                break;
                            }
                            case ADD_ACLS: {
                                data = rev.getFileData();
                                metaData = rev.getFileMetaData();
                                Set<CRAccessControl> fileACLs = rd.getACLs();
                                updateNecessary = fileACLs.addAll(acls);
                                acls = fileACLs;
                                break;
                            }
                            case REMOVE_ACLS: {
                                data = rev.getFileData();
                                metaData = rev.getFileMetaData();
                                Set<CRAccessControl> fileACLs = rd.getACLs();
                                updateNecessary = fileACLs.removeAll(acls);
                                acls = fileACLs;
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("Unsupported file modification operation: " + (Object)((Object)op));
                            }
                        }
                        if (updateNecessary) {
                            if (this._backupDir != null) {
                                backupFile = new File(this._backupDir, escapedNodePath);
                                this._lockManager.acquireWriteLock(backupFile);
                                try {
                                    boolean success;
                                    File dir = backupFile.getParentFile();
                                    if (!dir.exists() && !(success = this.mkdirs(dir))) {
                                        throw new IOException("Failed to create backup directory: " + dir.getAbsolutePath());
                                    }
                                    backupRaf = new RandomAccessFile(backupFile, "rw");
                                    backupChannel = backupRaf.getChannel();
                                    FileUtils.getFileLock(backupChannel, 15000L);
                                    FileUtils.copyFile(file, channel, backupFile, backupChannel, true);
                                }
                                catch (IOException e) {
                                    throw new CRIOException("Failed to create backup file for: " + nodePath, e);
                                }
                            }
                            channel.truncate(0L);
                            wroteIntoTheFile = true;
                            channel.position(0L);
                            rev = this.writeRevision(channel, nodePath, acls, data, metaData);
                            break block49;
                        }
                        backupFile = null;
                    }
                    catch (FileNotFoundException e) {
                        block50: {
                            String message = e.getMessage();
                            if (!message.contains("Access") || !message.contains("denied")) break block50;
                            throw new CRAccessDeniedException(e.getMessage(), (Throwable)e);
                            {
                                catch (Throwable throwable) {
                                    Utils.close(raf);
                                    Utils.close(backupRaf);
                                    if (mustDeleteFile) {
                                        file.delete();
                                    }
                                    if (backupFile == null) throw throwable;
                                    backupFile.delete();
                                    throw throwable;
                                }
                            }
                        }
                        Utils.close(raf);
                        Utils.close(backupRaf);
                        if (mustDeleteFile) {
                            file.delete();
                        }
                        if (backupFile != null) {
                            backupFile.delete();
                        }
                        break block51;
                        catch (CRAccessDeniedException e2) {
                            throw e2;
                            catch (Exception e3) {
                                if (wroteIntoTheFile) {
                                    if (backupFile != null) {
                                        try {
                                            FileUtils.copyFile(backupFile, backupChannel, file, channel, true);
                                        }
                                        catch (IOException ioe) {
                                            mustDeleteFile = true;
                                        }
                                    } else {
                                        mustDeleteFile = true;
                                    }
                                }
                                if (e3 instanceof CRAccessDeniedException) {
                                    throw (CRAccessDeniedException)((Object)e3);
                                }
                                if (e3 instanceof CRFileNotExistsException) {
                                    throw (CRFileNotExistsException)((Object)e3);
                                }
                                if (e3 instanceof FileNotFoundException) {
                                    throw new CRFileNotExistsException((Throwable)e3);
                                }
                                if (e3 instanceof RuntimeException) throw (RuntimeException)e3;
                                throw new CRIOException("Failed to update file: " + nodePath, e3);
                            }
                        }
                    }
                }
                Utils.close(raf);
                Utils.close(backupRaf);
                if (mustDeleteFile) {
                    file.delete();
                }
                if (backupFile != null) {
                    backupFile.delete();
                }
            }
            cRFileRevision = rev;
        }
        catch (Throwable throwable) {
            try {
                this._lockManager.releaseWriteLock(file);
                throw throwable;
            }
            finally {
                if (backupFile != null) {
                    this._lockManager.releaseWriteLock(backupFile);
                }
            }
        }
        try {
            this._lockManager.releaseWriteLock(file);
            return cRFileRevision;
        }
        finally {
            if (backupFile != null) {
                this._lockManager.releaseWriteLock(backupFile);
            }
        }
    }

    public CRFileRevision updateFile(String nodePath, CRFileData data, Map<String, String> metaData, boolean trackRevision) throws CRAccessDeniedException, CRFileNotExistsException {
        return this.modifyFile(FileModificationOperation.UPDATE_FILE, nodePath, data, metaData, null);
    }

    public CRFileRevision updateFile(String nodePath, CRFileData data, boolean trackRevision) throws CRAccessDeniedException, CRFileNotExistsException {
        return this.updateFile(nodePath, data, null, trackRevision);
    }

    public void addAcls(String nodePath, List<CRAccessControl> acls) throws CRAccessDeniedException, CRFileNotExistsException {
        this.modifyFile(FileModificationOperation.ADD_ACLS, nodePath, null, null, acls);
    }

    public void removeAcls(String nodePath, Collection<CRAccessControl> acls) throws CRAccessDeniedException, CRFileNotExistsException {
        this.modifyFile(FileModificationOperation.REMOVE_ACLS, nodePath, null, null, acls);
    }

    public void removeAcl(String nodePath, CRAccessControl acl) throws CRAccessDeniedException, CRFileNotExistsException {
        HashSet<CRAccessControl> acls = new HashSet<CRAccessControl>(1);
        acls.add(acl);
        this.removeAcls(nodePath, acls);
    }

    Set<CRAccessControl> getFileACLs(String nodePath, boolean javaLock) throws CRAccessDeniedException {
        Utils.assertPathIsValid(nodePath);
        RevisionData rd = this.getLatestFileRevision(nodePath, true, true, null, javaLock);
        if (rd == null) {
            return null;
        }
        return rd.getACLs();
    }

    int getLockCount() {
        return this._lockManager.getLockCount();
    }

    public void rollbackToRevision(String filePath, int revisionNumber) throws CRAccessDeniedException {
    }

    public void clearRepository() throws CRAccessDeniedException {
        Set<CRAccessControl> acls = this.getFolderACLs(this._rootDir, CRNode.NODE_ROOT);
        this.assertIsAllowed(CRNode.NODE_ROOT, acls, Permission.READ_WRITE);
        FileUtils.removeAllContentFromRepositoryFolder(this._rootDir, this._rootNode.getNodePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverFileFromBackup(String nodePath) {
        Utils.assertPathIsValid(nodePath);
        if (this._backupDir == null) {
            throw new CRRuntimeException("Backup repository not specified.");
        }
        String escapedNodePath = Utils.escapeNodePath(nodePath);
        File backupFile = new File(this._backupDir, escapedNodePath);
        if (!backupFile.exists()) {
            throw new CRRuntimeException("There's no backup for: " + nodePath);
        }
        if (backupFile.isDirectory()) {
            throw new CRRuntimeException("The node path points to a directory in the backup repository, not a file: " + nodePath);
        }
        File file = new File(this._rootDir, escapedNodePath);
        this._lockManager.acquireWriteLock(file);
        try {
            this._lockManager.acquireReadLock(backupFile);
            try {
                FileUtils.copyFile(backupFile, null, file, null, true);
            }
            catch (IOException e) {
                throw new CRIOException("Failed to copy the backup file to the main repository: " + e.getMessage(), e);
            }
            finally {
                this._lockManager.releaseReadLock(backupFile);
            }
        }
        finally {
            this._lockManager.releaseWriteLock(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mkdirs(File dirs) {
        assert (dirs != null);
        this._lockManager.acquireWriteLock(dirs);
        try {
            boolean exists;
            boolean success = dirs.mkdirs();
            if (success) {
                boolean bl = true;
                return bl;
            }
            boolean bl = exists = dirs.exists();
            return bl;
        }
        finally {
            this._lockManager.releaseWriteLock(dirs);
        }
    }

    private static class ReadWriteLockWithReferrerCount {
        private final ReadWriteLock _lock = new ReentrantReadWriteLock();
        private final AtomicInteger _countReferrers = new AtomicInteger(0);

        private ReadWriteLockWithReferrerCount() {
        }

        public ReadWriteLock getLock() {
            return this._lock;
        }

        public int incrementReferrers() {
            return this._countReferrers.incrementAndGet();
        }

        public int decrementReferrers() {
            return this._countReferrers.decrementAndGet();
        }
    }

    static class LockManager {
        private static final long LOCK_TIMEOUT = 15L;
        private static final TimeUnit LOCK_TIMEOUT_UNITS = TimeUnit.SECONDS;
        private final boolean _lockingEnabled;
        private static final Map<String, ReadWriteLockWithReferrerCount> _locks = new HashMap<String, ReadWriteLockWithReferrerCount>();

        public LockManager(boolean lockingEnabled) {
            this._lockingEnabled = lockingEnabled;
        }

        public void acquireReadLock(File file) throws CRIOException {
            Utils.assertArgNotNull(file, "file");
            String absolutePath = file.getAbsolutePath();
            this.acquireReadLock(absolutePath);
        }

        public void acquireReadLock(String absolutePath) throws CRIOException {
            Utils.assertArgNotNull(absolutePath, "absolutePath");
            this.acquireLock(absolutePath, LockType.READ);
        }

        public void releaseReadLock(File file) throws CRIOException {
            Utils.assertArgNotNull(file, "file");
            String absolutePath = file.getAbsolutePath();
            this.releaseReadLock(absolutePath);
        }

        public void releaseReadLock(String absolutePath) throws CRIOException {
            Utils.assertArgNotNull(absolutePath, "absolutePath");
            this.releaseLock(absolutePath, LockType.READ);
        }

        public void acquireWriteLock(File file) throws CRIOException {
            Utils.assertArgNotNull(file, "file");
            String absolutePath = file.getAbsolutePath();
            this.acquireWriteLock(absolutePath);
        }

        public void acquireWriteLock(String absolutePath) throws CRIOException {
            Utils.assertArgNotNull(absolutePath, "absolutePath");
            this.acquireLock(absolutePath, LockType.WRITE);
        }

        public void releaseWriteLock(File file) throws CRIOException {
            Utils.assertArgNotNull(file, "file");
            String absolutePath = file.getAbsolutePath();
            this.releaseWriteLock(absolutePath);
        }

        public void releaseWriteLock(String absolutePath) throws CRIOException {
            Utils.assertArgNotNull(absolutePath, "absolutePath");
            this.releaseLock(absolutePath, LockType.WRITE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acquireLock(String absolutePath, LockType lockType) throws CRIOException {
            boolean acquired;
            ReadWriteLockWithReferrerCount lock;
            if (!this._lockingEnabled) {
                return;
            }
            Map<String, ReadWriteLockWithReferrerCount> map = _locks;
            synchronized (map) {
                lock = this.getLock(absolutePath);
                lock.incrementReferrers();
            }
            Lock actualLock = lockType == LockType.READ ? lock.getLock().readLock() : lock.getLock().writeLock();
            try {
                acquired = actualLock.tryLock(15L, LOCK_TIMEOUT_UNITS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                acquired = false;
            }
            if (!acquired) {
                Map<String, ReadWriteLockWithReferrerCount> map2 = _locks;
                synchronized (map2) {
                    int remainingReferrers = lock.decrementReferrers();
                    if (remainingReferrers == 0) {
                        _locks.remove(absolutePath);
                    }
                }
                throw new CRIOException("Failed to acquire " + (Object)((Object)lockType) + " lock on: " + absolutePath);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseLock(String absolutePath, LockType lockType) {
            if (!this._lockingEnabled) {
                return;
            }
            Map<String, ReadWriteLockWithReferrerCount> map = _locks;
            synchronized (map) {
                ReadWriteLockWithReferrerCount lock = _locks.get(absolutePath);
                if (lock == null) {
                    throw new CRIOException("There's no lock for " + absolutePath);
                }
                Lock actualLock = lockType == LockType.READ ? lock.getLock().readLock() : lock.getLock().writeLock();
                actualLock.unlock();
                int countReferrers = lock.decrementReferrers();
                if (countReferrers <= 0) {
                    _locks.remove(absolutePath);
                    if (countReferrers < 0) {
                        throw new IllegalStateException("Unbalanced lock release for " + absolutePath + ": " + countReferrers);
                    }
                }
            }
        }

        private ReadWriteLockWithReferrerCount getLock(String absolutePath) {
            assert (absolutePath != null) : "absolutePath should not be null";
            ReadWriteLockWithReferrerCount lock = _locks.get(absolutePath);
            if (lock == null) {
                lock = new ReadWriteLockWithReferrerCount();
                _locks.put(absolutePath, lock);
            }
            return lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getLockCount() {
            if (_locks == null) {
                return 0;
            }
            Map<String, ReadWriteLockWithReferrerCount> map = _locks;
            synchronized (map) {
                int size = _locks.size();
                return size;
            }
        }

        void clear() {
            if (_locks != null) {
                _locks.clear();
            }
        }

        private static enum LockType {
            READ,
            WRITE;

        }
    }

    static class RevisionData {
        private final Set<CRAccessControl> _acls;
        private final CRFileRevision _revision;
        private final String _nodeName;
        private final String _nodePath;
        private final Date _creationDate;

        RevisionData(Set<CRAccessControl> acls, CRFileRevision revision, String nodeName, String nodePath, Date creationDate) {
            this._acls = acls;
            this._revision = revision;
            this._nodeName = nodeName;
            this._nodePath = nodePath;
            this._creationDate = creationDate;
        }

        public Set<CRAccessControl> getACLs() {
            return this._acls;
        }

        public CRFileRevision getRevision() {
            return this._revision;
        }

        public String getNodeName() {
            return this._nodeName;
        }

        public String getNodePath() {
            return this._nodePath;
        }

        public Date getCreationDate() {
            return this._creationDate;
        }
    }

    private static enum FileModificationOperation {
        UPDATE_FILE,
        ADD_ACLS,
        REMOVE_ACLS;

    }
}

