/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.fs.impl;

import com.vmware.vim.zeppelin.cr.auth.CRAccessControl;
import com.vmware.vim.zeppelin.cr.exception.CRRuntimeException;
import com.vmware.vim.zeppelin.cr.fs.util.Utils;

enum Permission {
    READ(CRAccessControl.PERMISSION_READ_ONLY, "READ", "R"),
    READ_WRITE(CRAccessControl.PERMISSION_READ_WRITE, "READ/WRITE", "RW");

    private final int _intValue;
    private final String _description;
    private final String _shortDescription;

    private Permission(int intValue, String description, String shortDescription) {
        this._intValue = intValue;
        this._description = description;
        this._shortDescription = shortDescription;
    }

    public int getIntValue() {
        return this._intValue;
    }

    public String getDescription() {
        return this._description;
    }

    public String getShortDescription() {
        return this._shortDescription;
    }

    public static Permission parsePermission(int permission) {
        for (Permission p : Permission.values()) {
            if (p.getIntValue() != permission) continue;
            return p;
        }
        throw new CRRuntimeException("Invalid permission: " + permission);
    }

    public static Permission parsePermission(String shortDescription) {
        Utils.assertArgNotBlank(shortDescription, "shortDescription");
        for (Permission p : Permission.values()) {
            if (!shortDescription.equals(p.getShortDescription())) continue;
            return p;
        }
        throw new CRRuntimeException("Invalid permission identifier: " + shortDescription);
    }
}

