/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.fs.util;

import com.vmware.vim.zeppelin.cr.exception.CRFileNotExistsException;
import com.vmware.vim.zeppelin.cr.fs.impl.exception.CRFileTooLargeException;
import com.vmware.vim.zeppelin.cr.fs.impl.exception.CRIOException;
import com.vmware.vim.zeppelin.cr.fs.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.TimeoutException;

public class FileUtils {
    public static final long FILE_LOCK_TIMEOUT_IN_MILLIS = 15000L;

    public static boolean deleteDirectory(File dir) {
        return FileUtils.deleteDirectory(dir, true);
    }

    public static boolean deleteDirectory(File dir, boolean deleteSubDirs) {
        if (dir.exists()) {
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return dir.delete();
    }

    public static boolean delete(File f, boolean deleteSubDirs) {
        if (f.exists()) {
            if (f.isDirectory()) {
                return FileUtils.deleteDirectory(f, deleteSubDirs);
            }
            return f.delete();
        }
        return true;
    }

    public static void removeAllContentFromRepositoryFolder(File folder, String nodePath) {
        FileUtils.assertIsDirectory(folder, nodePath);
        for (String childName : folder.list()) {
            File child = new File(folder, childName);
            boolean success = child.isFile() ? child.delete() : FileUtils.deleteDirectory(child);
            if (success || !child.exists()) continue;
            String childNodePath = Utils.getNodePath(folder, child);
            String unescapedChildNodePath = Utils.unescapeNodePath(childNodePath);
            throw new CRIOException("Failed to delete: " + unescapedChildNodePath);
        }
    }

    public static void assertIsDirectory(File f, String nodePath) throws CRIOException {
        if (!f.isDirectory()) {
            throw new CRIOException("Path '" + nodePath + "' is a file, not a folder.");
        }
    }

    public static void assertIsFile(File f, String nodePath) throws CRIOException {
        if (f.isDirectory()) {
            throw new CRIOException("Path '" + nodePath + "' is a directory, not a file.");
        }
    }

    public static void assertExistsAndIsDirectory(File f, String nodePath) throws CRFileNotExistsException, CRIOException {
        if (!f.exists()) {
            throw new CRFileNotExistsException("Path not found: " + nodePath);
        }
        FileUtils.assertIsDirectory(f, nodePath);
    }

    public static void assertExistsAndIsFile(File f, String nodePath) throws CRFileNotExistsException, CRIOException {
        if (!f.exists()) {
            throw new CRFileNotExistsException("File not found: " + nodePath);
        }
        FileUtils.assertIsFile(f, nodePath);
    }

    private static IOException newFileIsDirectoryException(File file) {
        return new IOException("'" + file.getAbsolutePath() + "' is a directory, not a file.");
    }

    private static IOException newFileNotFoundException(File file) {
        return new FileNotFoundException("The file '" + file.getAbsolutePath() + "' doesn't exist.");
    }

    private static int assertFileIsOkForReading(File file, long maxFileSize) throws IOException, CRFileTooLargeException {
        Utils.assertArgNotNull(file, "file");
        if (!file.exists()) {
            throw FileUtils.newFileNotFoundException(file);
        }
        if (file.isDirectory()) {
            throw FileUtils.newFileIsDirectoryException(file);
        }
        long fileSize = file.length();
        if (fileSize > maxFileSize) {
            throw new CRFileTooLargeException("File too large: " + file.getAbsolutePath(), fileSize, maxFileSize);
        }
        return (int)fileSize;
    }

    private static void assertFileIsOkForWriting(File file, boolean overwriteIfExists) throws IOException {
        Utils.assertArgNotNull(file, "file");
        if (file.exists()) {
            if (file.isDirectory()) {
                throw FileUtils.newFileIsDirectoryException(file);
            }
            if (!overwriteIfExists && file.length() > 0L) {
                throw new IOException("The file '" + file.getAbsolutePath() + "' exists and will not be overwritten.");
            }
            file.delete();
        }
    }

    public static byte[] readFileToByteArray(FileChannel channel, int maxFileSize) throws IOException, CRFileTooLargeException {
        long fileSize = channel.size();
        if (fileSize > (long)maxFileSize) {
            throw new CRFileTooLargeException("File too large", fileSize, maxFileSize);
        }
        byte[] fileContent = new byte[(int)fileSize];
        ByteBuffer buf = ByteBuffer.wrap(fileContent);
        while (channel.read(buf) > 0) {
        }
        return fileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(File file, int maxFileSize) throws IOException, CRFileTooLargeException {
        byte[] fileContent;
        FileUtils.assertFileIsOkForReading(file, maxFileSize);
        RandomAccessFile f = new RandomAccessFile(file, "r");
        try {
            FileChannel channel = f.getChannel();
            try {
                fileContent = FileUtils.readFileToByteArray(channel, maxFileSize);
            }
            finally {
                Utils.close(channel);
            }
        }
        finally {
            Utils.close(f);
        }
        return fileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteArrayToFile(File file, byte[] data, boolean overwriteIfExists) throws IOException {
        FileUtils.assertFileIsOkForWriting(file, overwriteIfExists);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        RandomAccessFile f = new RandomAccessFile(file, "rw");
        try {
            FileChannel channel = f.getChannel();
            try {
                try {
                    FileUtils.getFileLock(channel, 15000L);
                }
                catch (TimeoutException e) {
                    throw new IOException(e.getMessage(), e);
                }
                channel.truncate(0L);
                while (buffer.hasRemaining()) {
                    channel.write(buffer);
                }
            }
            finally {
                Utils.close(channel);
            }
        }
        finally {
            Utils.close(f);
        }
    }

    public static FileLock getFileLock(FileChannel channel, long timeoutInMillis, boolean exclusive) throws TimeoutException, IOException {
        Utils.assertArgNotNull(channel, "channel");
        long endMillis = System.currentTimeMillis() + timeoutInMillis;
        while (true) {
            try {
                if (exclusive) {
                    return channel.lock();
                }
                return channel.lock(0L, channel.size(), true);
            }
            catch (OverlappingFileLockException e) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Thread interrupted while trying to acquire a lock on a FileChannel", ie);
                }
                if (System.currentTimeMillis() <= endMillis) continue;
                throw new TimeoutException("Failed to acquire file lock within the specified timeout");
            }
            break;
        }
    }

    public static FileLock getFileLock(FileChannel channel, long timeoutInMillis) throws TimeoutException, IOException {
        return FileUtils.getFileLock(channel, timeoutInMillis, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void copyFile(File src, FileChannel srcChannel, File dest, FileChannel destChannel, boolean overwriteIfExists) throws IOException {
        boolean success;
        Utils.assertArgNotNull(src, "src");
        Utils.assertArgNotNull(dest, "dest");
        if (!overwriteIfExists && dest.exists()) {
            throw new IOException("File already exists. Will not overwrite it. Copy operation aborted!");
        }
        File destDir = dest.getParentFile();
        if (!destDir.exists() && !(success = destDir.mkdirs())) {
            throw new IOException("Failed to create the destination directory: " + destDir.getAbsolutePath());
        }
        RandomAccessFile srcRaf = null;
        RandomAccessFile destRaf = null;
        IOException exc = null;
        try {
            if (srcChannel == null) {
                srcRaf = new RandomAccessFile(src, "r");
                srcChannel = srcRaf.getChannel();
                FileUtils.getFileLock(srcChannel, 15000L, false);
            }
            if (destChannel == null) {
                destRaf = new RandomAccessFile(dest, "rw");
                destChannel = destRaf.getChannel();
                FileUtils.getFileLock(destChannel, 15000L, true);
            }
            destChannel.truncate(0L);
            destChannel.position(0L);
            long numBytesInFile = srcChannel.size();
            int maxCount = 67076096;
            for (long position = 0L; position < numBytesInFile; position += srcChannel.transferTo(position, maxCount, destChannel)) {
            }
        }
        catch (IOException e) {
            exc = e;
            Utils.close(destRaf);
            Utils.close(srcRaf);
        }
        catch (TimeoutException e2) {
            exc = new IOException("Failed to acquire a file lock", e2);
            {
                catch (Throwable throwable) {
                    Utils.close(destRaf);
                    Utils.close(srcRaf);
                    throw throwable;
                }
            }
            Utils.close(destRaf);
            Utils.close(srcRaf);
        }
        Utils.close(destRaf);
        Utils.close(srcRaf);
        if (exc != null) {
            if (dest.exists() && destChannel == null) {
                dest.delete();
            }
            throw new IOException("Failed to copy from " + src.getAbsolutePath() + " to " + dest.getAbsolutePath(), exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file, String charset) throws IOException, UnsupportedEncodingException {
        String string;
        Utils.assertArgNotNull(file, "file");
        if (!file.exists()) {
            throw new IOException("The file doesn't exist: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IOException("The file is a directory: " + file.getAbsolutePath());
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            fis = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)fis, charset);
            br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder(1000);
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
            sb.deleteCharAt(sb.length() - 1);
            string = sb.toString();
        }
        catch (Throwable throwable) {
            Utils.close(br);
            Utils.close(isr);
            Utils.close(fis);
            throw throwable;
        }
        Utils.close(br);
        Utils.close(isr);
        Utils.close(fis);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String str, File file, String charset) throws IOException, UnsupportedEncodingException {
        Utils.assertArgNotNull(str, "str");
        Utils.assertArgNotNull(file, "file");
        if (file.isDirectory()) {
            throw new IOException("The file is a directory: " + file.getAbsolutePath());
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        PrintWriter pw = null;
        try {
            fos = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)fos, charset);
            pw = new PrintWriter(osw);
            pw.print(str);
        }
        catch (Throwable throwable) {
            Utils.close(pw);
            Utils.close(osw);
            Utils.close(fos);
            throw throwable;
        }
        Utils.close(pw);
        Utils.close(osw);
        Utils.close(fos);
    }
}

