/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.fs.util;

import com.vmware.vim.zeppelin.cr.exception.CRInvalidNodePathException;
import com.vmware.vim.zeppelin.cr.exception.CRRuntimeException;
import com.vmware.vim.zeppelin.cr.fs.CRFileData;
import com.vmware.vim.zeppelin.cr.fs.util.StringUtils;
import com.vmware.vim.zeppelin.cr.node.CRNode;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.channels.FileLock;

public class Utils {
    private static final char escapeChar = '%';

    public static void assertArgNotNull(Object arg, String argName) {
        if (arg == null) {
            throw new IllegalArgumentException("The '" + argName + "' argument should not be null.");
        }
    }

    public static void assertArgNotBlank(String arg, String argName) {
        if (StringUtils.isEmpty(arg)) {
            throw new IllegalArgumentException("The '" + argName + "' argument should not be null or empty.");
        }
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void releaseLock(FileLock lock) {
        try {
            if (lock != null && lock.isValid()) {
                lock.release();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void assertPathIsValid(String nodePath) throws CRInvalidNodePathException {
        if (StringUtils.isBlank(nodePath)) {
            throw new CRInvalidNodePathException("The node path cannot be null");
        }
        if (CRNode.NODE_ROOT.equals(nodePath)) {
            return;
        }
        if (nodePath.startsWith(CRNode.NODE_ROOT) && !nodePath.endsWith(CRNode.NODE_ROOT)) {
            return;
        }
        throw new CRInvalidNodePathException("Node path should start with root node and cannot end with path separator: " + nodePath);
    }

    public static String getNodePath(File rootDir, File file) {
        String repoRootPath = rootDir.getAbsolutePath();
        String filePath = file.getAbsolutePath();
        String nodePath = null;
        if (filePath.startsWith(repoRootPath)) {
            nodePath = filePath.substring(repoRootPath.length());
            if (StringUtils.isEmpty(nodePath)) {
                nodePath = CRNode.NODE_ROOT;
            } else if ((nodePath = nodePath.replace(System.getProperty("file.separator"), CRNode.NODE_PATH_SEPARATOR)).endsWith(CRNode.NODE_PATH_SEPARATOR)) {
                nodePath = nodePath.substring(0, nodePath.length() - 1);
            }
        }
        return nodePath;
    }

    public static String appendNameToNodePath(String nodePath, String name) {
        if (StringUtils.isBlank(name)) {
            if (nodePath.endsWith(CRNode.NODE_PATH_SEPARATOR)) {
                nodePath = nodePath.substring(0, nodePath.length() - 1);
            }
            return nodePath;
        }
        if (name.startsWith(CRNode.NODE_PATH_SEPARATOR)) {
            name = name.substring(1);
        }
        if (name.endsWith(CRNode.NODE_PATH_SEPARATOR)) {
            name = name.substring(0, name.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isBlank(nodePath)) {
            sb.append(CRNode.NODE_ROOT);
        } else {
            sb.append(nodePath);
            if (!nodePath.endsWith(CRNode.NODE_PATH_SEPARATOR)) {
                sb.append(CRNode.NODE_PATH_SEPARATOR);
            }
        }
        sb.append(name);
        return sb.toString();
    }

    static boolean isCharForbiddenInNodeFileNames(char ch) {
        return ch < ' ' || ch >= '\u007f' || ch == '\\' || ch == '/' || ch == ':' || ch == '*' || ch == '?' || ch == '\"' || ch == '<' || ch == '>' || ch == '|';
    }

    static boolean charShouldBeEscapedInFileNames(char ch) {
        return Utils.isCharForbiddenInNodeFileNames(ch) || ch == '%';
    }

    public static String escapeFileName(String fileName) {
        if (StringUtils.isBlank(fileName)) {
            return "";
        }
        boolean fileNameIsSpecialDirName = ".".equals(fileName) || "..".equals(fileName);
        int len = fileName.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = fileName.charAt(i);
            if (Utils.isCharForbiddenInNodeFileNames(ch) || fileNameIsSpecialDirName && i == 0 || ch == '%') {
                sb.append('%');
                String code = StringUtils.leftPad(Integer.toHexString(ch), 4, '0');
                sb.append(code);
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 255) {
            throw new IllegalArgumentException("Escaped string name is too long");
        }
        return sb.toString();
    }

    public static String unescapeFileName(String fileName) {
        if (StringUtils.isBlank(fileName)) {
            return "";
        }
        int len = fileName.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = fileName.charAt(i);
            if (ch == '%') {
                if (i >= len - 4) {
                    throw new IllegalArgumentException("Incomplete escape sequence at the end. Cannot unescape string: " + fileName);
                }
                String code = fileName.substring(i + 1, i + 5);
                sb.append((char)Integer.parseInt(code, 16));
                i += 4;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void assertFileNameIsValid(String fileName) {
        String errorMsg = null;
        if (StringUtils.isBlank(fileName)) {
            errorMsg = "Blank file name";
        } else if (".".equals(fileName) || "..".equals(fileName)) {
            errorMsg = "File name is a special directory name: " + fileName;
        } else {
            int len = fileName.length();
            for (int i = 0; i < len; ++i) {
                if (!Utils.isCharForbiddenInNodeFileNames(fileName.charAt(i))) continue;
                errorMsg = "Invalid character in file name at position " + i + ": " + fileName;
                break;
            }
        }
        if (errorMsg != null) {
            throw new CRRuntimeException("Invalid file name. " + errorMsg);
        }
    }

    private static String escapeOrUnescapeNodePath(String nodePath, boolean escape) {
        Utils.assertArgNotBlank(nodePath, "filePath");
        if (CRNode.NODE_PATH_SEPARATOR.equals(nodePath)) {
            return nodePath;
        }
        String[] components = nodePath.split(CRNode.NODE_PATH_SEPARATOR);
        StringBuilder sb = new StringBuilder();
        int total = components.length;
        for (int i = 0; i < total; ++i) {
            String component = components[i];
            if (i > 0) {
                sb.append(CRNode.NODE_PATH_SEPARATOR);
            }
            if (StringUtils.isBlank(component)) continue;
            if (escape) {
                sb.append(Utils.escapeFileName(component));
                continue;
            }
            sb.append(Utils.unescapeFileName(component));
        }
        return sb.toString();
    }

    public static String escapeNodePath(String nodePath) {
        return Utils.escapeOrUnescapeNodePath(nodePath, true);
    }

    public static String unescapeNodePath(String nodePath) {
        return Utils.escapeOrUnescapeNodePath(nodePath, false);
    }

    public static void assertFilePathIsValid(String path) {
        String[] components;
        if (StringUtils.isBlank(path)) {
            throw new CRRuntimeException("Blank path");
        }
        if (CRNode.NODE_ROOT.equals(path)) {
            return;
        }
        for (String component : components = path.split(CRNode.NODE_PATH_SEPARATOR)) {
            if (StringUtils.isBlank(component)) continue;
            Utils.assertFileNameIsValid(component);
        }
    }

    public static String getParentNodePath(String nodePath) {
        Utils.assertPathIsValid(nodePath);
        if (CRNode.NODE_ROOT.equals(nodePath)) {
            return null;
        }
        int idx = nodePath.lastIndexOf(CRNode.NODE_PATH_SEPARATOR);
        if (idx == 0) {
            return CRNode.NODE_ROOT;
        }
        if (idx > 0) {
            return nodePath.substring(0, idx);
        }
        throw new CRInvalidNodePathException("Node paths should contain at least one path separator");
    }

    public static String getNodeName(String nodePath) {
        Utils.assertPathIsValid(nodePath);
        if (CRNode.NODE_ROOT.equals(nodePath)) {
            return CRNode.NODE_ROOT;
        }
        int idx = nodePath.lastIndexOf(CRNode.NODE_PATH_SEPARATOR);
        return nodePath.substring(idx + 1);
    }

    public static String getStackTraceAsString(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static CRFileData buildFileData(String data) {
        return new CRFileData(data.getBytes());
    }
}

