/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms;

import com.google.common.base.Optional;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDefinition;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AlarmDefinitionCreator {
    private static final String DEFINED_IN = "definedIn.this.object";
    private static final String ALARM_INFO_ENTITY_NAME = "name";
    private static final String DECLARED_ALARMS = "declaredAlarmState";
    private static final String ALARM_INFO = "info";
    private final QueryExecutor _queryExecutor;

    public AlarmDefinitionCreator(QueryExecutor queryExecutor) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{queryExecutor});
        this._queryExecutor = queryExecutor;
    }

    public List<AlarmDefinition> createAlarmDefinitions(Object object, String string) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object});
        Object[] objectArray = (AlarmState[])this._queryExecutor.getProperty(object, DECLARED_ALARMS);
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return Collections.emptyList();
        }
        Set<ManagedObjectReference> set = this.findAlarmInfoMors((AlarmState[])objectArray);
        PropertyValue[] propertyValueArray = this._queryExecutor.getProperty(set.toArray(), ALARM_INFO);
        Set<ManagedObjectReference> set2 = this.findAlarmInfoEntities(propertyValueArray);
        PropertyValue[] propertyValueArray2 = null;
        if (!set2.isEmpty()) {
            propertyValueArray2 = this._queryExecutor.getProperty(set2.toArray(), ALARM_INFO_ENTITY_NAME);
        }
        ArrayList<AlarmDefinition> arrayList = new ArrayList<AlarmDefinition>();
        for (Object object2 : objectArray) {
            Optional<AlarmInfo> optional = this.findAlarmInfo(propertyValueArray, ((AlarmState)object2).alarm);
            if (!optional.isPresent()) continue;
            AlarmInfo alarmInfo = (AlarmInfo)optional.get();
            String string2 = this.makeDefinedInName(object, string, propertyValueArray2, alarmInfo);
            if (alarmInfo != null) {
                alarmInfo.action = null;
            }
            AlarmDefinition alarmDefinition = new AlarmDefinition((AlarmState)object2, alarmInfo, string2);
            arrayList.add(alarmDefinition);
        }
        return arrayList;
    }

    private String makeDefinedInName(Object object, String string, PropertyValue[] propertyValueArray, AlarmInfo alarmInfo) {
        String string2 = object.equals(alarmInfo.entity) ? Localization.getString(DEFINED_IN) : this.findDefinedInName(propertyValueArray, alarmInfo.entity, string);
        return string2;
    }

    private Set<ManagedObjectReference> findAlarmInfoMors(AlarmState[] alarmStateArray) {
        HashSet<ManagedObjectReference> hashSet = new HashSet<ManagedObjectReference>();
        for (AlarmState alarmState : alarmStateArray) {
            hashSet.add(alarmState.alarm);
        }
        return hashSet;
    }

    private String findDefinedInName(PropertyValue[] propertyValueArray, ManagedObjectReference managedObjectReference, String string) {
        if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)managedObjectReference)) {
            return string;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])propertyValueArray)) {
            return "";
        }
        for (PropertyValue propertyValue : propertyValueArray) {
            if (!propertyValue.resourceObject.equals(managedObjectReference)) continue;
            return (String)propertyValue.value;
        }
        return "";
    }

    private Optional<AlarmInfo> findAlarmInfo(PropertyValue[] propertyValueArray, ManagedObjectReference managedObjectReference) {
        if (ArrayUtil.isNullOrEmpty((Object[])propertyValueArray)) {
            return Optional.absent();
        }
        for (PropertyValue propertyValue : propertyValueArray) {
            if (!propertyValue.resourceObject.equals(managedObjectReference)) continue;
            AlarmInfo alarmInfo = (AlarmInfo)propertyValue.value;
            return Optional.of((Object)alarmInfo);
        }
        return Optional.absent();
    }

    private Set<ManagedObjectReference> findAlarmInfoEntities(PropertyValue[] propertyValueArray) {
        HashSet<ManagedObjectReference> hashSet = new HashSet<ManagedObjectReference>();
        if (ArrayUtil.isNullOrEmpty((Object[])propertyValueArray)) {
            return hashSet;
        }
        for (PropertyValue propertyValue : propertyValueArray) {
            AlarmInfo alarmInfo = (AlarmInfo)propertyValue.value;
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)alarmInfo.entity)) continue;
            hashSet.add(alarmInfo.entity);
        }
        return hashSet;
    }
}

