/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms;

import com.google.common.base.Optional;
import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDetails;
import com.vmware.opsmgmt.client.extension.alarms.AlarmsUtil;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.actions.ActionGroupFactory;
import com.vmware.opsmgmt.client.extension.alarms.actions.AlarmActionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.configuration.AlarmConfiguration;
import com.vmware.opsmgmt.client.extension.alarms.configuration.AlarmConfigurator;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionGroup;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionFactory;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionGroup;
import com.vmware.opsmgmt.client.extension.alarms.expressions.AlarmExpressionWrapper;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlarmDetailsCreator {
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;
    private AlarmConfiguration _alarmConfig;
    private static final String ALARM_INFO = "info";
    private static final String ALARM_DEFINITION_INFO = "alarmDefinitionInfo";

    public AlarmDetailsCreator(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{queryExecutor});
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._alarmConfig = new AlarmConfigurator().parseConfig();
    }

    public AlarmDetails createAlarmDetails(Object object) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object});
        Optional<AlarmDefinitionInfo> optional = this.getAlarmDefinitionInfo(object);
        if (!optional.isPresent()) {
            return null;
        }
        AlarmDefinitionInfo alarmDefinitionInfo = (AlarmDefinitionInfo)optional.get();
        AlarmInfo alarmInfo = (AlarmInfo)this._queryExecutor.getProperty(object, ALARM_INFO);
        AlarmExpressionWrapper alarmExpressionWrapper = new AlarmExpressionWrapper(alarmInfo.expression);
        List<TriggerConditionGroup> list = new TriggerConditionFactory().build(alarmExpressionWrapper, alarmDefinitionInfo);
        AlarmDetails alarmDetails = new AlarmDetails();
        alarmDetails.triggersBodyTxt = this.createTriggersBodyTxt(alarmExpressionWrapper);
        alarmDetails.triggersConditionTxt = this.createTriggersConditionTxt(alarmExpressionWrapper);
        alarmDetails.triggerConditionGroups = list;
        alarmDetails.actionGroups = this.createActionGroups(alarmDefinitionInfo, alarmInfo);
        String string = AlarmsUtil.getMonitorType(alarmInfo.expression);
        alarmDetails.localizedMonitorType = AlarmsUtil.getLocalizedMonitorType(string);
        return alarmDetails;
    }

    private Optional<AlarmDefinitionInfo> getAlarmDefinitionInfo(Object object) throws Exception {
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(object, new String[]{ALARM_DEFINITION_INFO});
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.propertyName = ALARM_DEFINITION_INFO;
        parameterSpec.parameter = this._alarmConfig.getServerCollection().toArray();
        querySpec.resourceSpec.propertySpecs[0].parameters = new ParameterSpec[]{parameterSpec};
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        if (resultSet == null || resultSet.items == null) {
            return Optional.absent();
        }
        for (ResultItem resultItem : resultSet.items) {
            if (resultItem == null || resultItem.properties == null) continue;
            for (PropertyValue propertyValue : resultItem.properties) {
                if (propertyValue == null || !ALARM_DEFINITION_INFO.equals(propertyValue.propertyName)) continue;
                return Optional.of((Object)((AlarmDefinitionInfo)propertyValue.value));
            }
        }
        return Optional.absent();
    }

    private List<ActionGroup> createActionGroups(AlarmDefinitionInfo alarmDefinitionInfo, AlarmInfo alarmInfo) {
        if (alarmInfo.action == null) {
            return Collections.emptyList();
        }
        Map<ManagedObjectReference, String> map = this.buildObjectNamesMap(alarmDefinitionInfo);
        ActionGroupFactory actionGroupFactory = new ActionGroupFactory();
        AlarmActionWrapper alarmActionWrapper = new AlarmActionWrapper(alarmInfo.action);
        List<ActionGroup> list = actionGroupFactory.build(alarmActionWrapper, map);
        return list;
    }

    private Map<ManagedObjectReference, String> buildObjectNamesMap(AlarmDefinitionInfo alarmDefinitionInfo) {
        if (alarmDefinitionInfo == null || ArrayUtil.isNullOrEmpty((Object[])alarmDefinitionInfo.migrateActionArgs)) {
            return Collections.emptyMap();
        }
        HashMap<ManagedObjectReference, String> hashMap = new HashMap<ManagedObjectReference, String>();
        for (PropertyValue propertyValue : alarmDefinitionInfo.migrateActionArgs) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)propertyValue.resourceObject;
            hashMap.put(managedObjectReference, (String)propertyValue.value);
        }
        return hashMap;
    }

    private String createTriggersConditionTxt(AlarmExpressionWrapper alarmExpressionWrapper) {
        if (alarmExpressionWrapper.getIsAndExpression()) {
            return this.createAndExpressionCondition(alarmExpressionWrapper);
        }
        if (alarmExpressionWrapper.getIsOrExpression()) {
            return this.createOrExpressionCondition(alarmExpressionWrapper);
        }
        return "";
    }

    private String createOrExpressionCondition(AlarmExpressionWrapper alarmExpressionWrapper) {
        String string = alarmExpressionWrapper.getIsEventBased() ? "triggersBlock.lblAllAny.events" : "triggersBlock.lblAllAny.states";
        String[] stringArray = new String[]{Localization.getString("triggers.any")};
        String string2 = Localization.getFormattedString(string, stringArray);
        return string2;
    }

    private String createAndExpressionCondition(AlarmExpressionWrapper alarmExpressionWrapper) {
        String string = alarmExpressionWrapper.getIsEventBased() ? "triggersBlock.lblAllAny.events" : "triggersBlock.lblAllAny.states";
        String[] stringArray = new String[]{Localization.getString("triggers.all")};
        String string2 = Localization.getFormattedString(string, stringArray);
        return string2;
    }

    private String createTriggersBodyTxt(AlarmExpressionWrapper alarmExpressionWrapper) {
        String string = alarmExpressionWrapper.getIsEventBased() ? "triggersBlock.eventTriggersRow.label" : "triggersBlock.stateTriggersRow.label";
        String string2 = Localization.getString(string);
        return string2;
    }
}

