/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms;

import com.vmware.opsmgmt.client.extension.alarms.AlarmDefinition;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDetails;
import com.vmware.opsmgmt.client.extension.alarms.PropertyFacade;
import com.vmware.vim.binding.vim.alarm.Alarm;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import java.util.ArrayList;
import java.util.List;

public class AlarmsPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final String ALARM_DEFINITIONS = "alarmDefinitions";
    private static final String ALARM_DETAILS = "alarmDetails";
    private final PropertyFacade _propertyFacade;

    public AlarmsPropertyProviderAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry, PropertyFacade propertyFacade) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataServiceExtensionRegistry});
        dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._propertyFacade = propertyFacade;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = "*";
        typeInfo.properties = new String[]{ALARM_DEFINITIONS};
        TypeInfo typeInfo2 = new TypeInfo();
        typeInfo2.type = Alarm.class.getSimpleName();
        typeInfo2.properties = new String[]{ALARM_DETAILS};
        return new TypeInfo[]{typeInfo, typeInfo2};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequestSpec});
        Object[] objectArray = propertyRequestSpec.objects;
        PropertySpec[] propertySpecArray = propertyRequestSpec.properties;
        if (objectArray == null || objectArray.length == 0 || propertySpecArray == null || propertySpecArray.length == 0) {
            return null;
        }
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        ArrayList<MethodFault> arrayList2 = new ArrayList<MethodFault>();
        for (Object object : objectArray) {
            try {
                ResultItem resultItem;
                List<AlarmDefinition> list;
                if (this.isPropertyRequested(ALARM_DEFINITIONS, propertySpecArray)) {
                    list = this._propertyFacade.createAlarmDefinitions(object);
                    resultItem = this.createAlarmDefResult(object, list);
                    arrayList.add(resultItem);
                }
                if (!this.isPropertyRequested(ALARM_DETAILS, propertySpecArray) || !(list = this._propertyFacade.createAlarmDetails(object)).isPresent()) continue;
                resultItem = this.createAlarmDetailsResult(object, (AlarmDetails)list.get());
                arrayList.add(resultItem);
            }
            catch (Exception exception) {
                arrayList2.add(MixedUtil.getMethodFault((Throwable)exception));
            }
        }
        if (!arrayList2.isEmpty()) {
            resultSet.error = new CompositeException(arrayList2);
        }
        resultSet.items = arrayList.toArray(new ResultItem[0]);
        return resultSet;
    }

    private ResultItem createAlarmDetailsResult(Object object, AlarmDetails alarmDetails) {
        return this.createResultItem(object, alarmDetails, ALARM_DETAILS);
    }

    private ResultItem createAlarmDefResult(Object object, List<AlarmDefinition> list) {
        return this.createResultItem(object, list, ALARM_DEFINITIONS);
    }

    private ResultItem createResultItem(Object object, Object object2, String string) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.resourceObject = object;
        propertyValue.propertyName = string;
        propertyValue.value = object2;
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = object;
        resultItem.properties = new PropertyValue[]{propertyValue};
        return resultItem;
    }

    private boolean isPropertyRequested(String string, PropertySpec[] propertySpecArray) {
        for (PropertySpec propertySpec : propertySpecArray) {
            for (String string2 : propertySpec.propertyNames) {
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }
}

