/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms;

import com.google.common.base.Optional;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDefinition;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDefinitionCreator;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDetails;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDetailsCreator;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyFacade {
    private final AlarmDefinitionCreator _alarmDefinitionCreator;
    private final AlarmDetailsCreator _alarmDetailsCreator;
    private static final Log _logger = LogFactory.getLog(PropertyFacade.class);

    public PropertyFacade(AlarmDefinitionCreator alarmDefinitionCreator, AlarmDetailsCreator alarmDetailsCreator) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{alarmDefinitionCreator, alarmDetailsCreator});
        this._alarmDefinitionCreator = alarmDefinitionCreator;
        this._alarmDetailsCreator = alarmDetailsCreator;
    }

    public List<AlarmDefinition> createAlarmDefinitions(Object object) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object});
        try {
            String string = VcServiceUtil.getServiceName((String)((ManagedObjectReference)object).getServerGuid());
            return this._alarmDefinitionCreator.createAlarmDefinitions(object, string);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return Collections.emptyList();
        }
    }

    public Optional<AlarmDetails> createAlarmDetails(Object object) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object});
        try {
            return Optional.of((Object)this._alarmDetailsCreator.createAlarmDetails(object));
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return Optional.absent();
        }
    }
}

