/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.actions;

import com.vmware.vim.binding.vim.alarm.AlarmAction;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vim.binding.vim.alarm.GroupAlarmAction;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmActionWrapper {
    private static final Log _logger = LogFactory.getLog(AlarmActionWrapper.class);
    private List<AlarmTriggeringAction> _alarmTrigeringActions;

    public AlarmActionWrapper(AlarmAction alarmAction) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{alarmAction});
        this._alarmTrigeringActions = new ArrayList<AlarmTriggeringAction>();
        this.processActions(alarmAction);
    }

    public List<AlarmTriggeringAction> getAlarmTrigeringActions() {
        return this._alarmTrigeringActions;
    }

    public void addAction(AlarmTriggeringAction alarmTriggeringAction) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{alarmTriggeringAction});
        this._alarmTrigeringActions.add(alarmTriggeringAction);
    }

    public void removeAction(AlarmTriggeringAction alarmTriggeringAction) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{alarmTriggeringAction});
        this._alarmTrigeringActions.remove(alarmTriggeringAction);
    }

    public void removeAllActions() {
        this._alarmTrigeringActions = new ArrayList<AlarmTriggeringAction>();
    }

    private void processActions(AlarmAction alarmAction) {
        if (alarmAction == null) {
            return;
        }
        if (alarmAction instanceof GroupAlarmAction) {
            GroupAlarmAction groupAlarmAction = (GroupAlarmAction)alarmAction;
            for (AlarmAction alarmAction2 : groupAlarmAction.action) {
                this.processActions(alarmAction2);
            }
        } else if (alarmAction instanceof AlarmTriggeringAction) {
            this._alarmTrigeringActions.add((AlarmTriggeringAction)alarmAction);
        } else {
            _logger.warn((Object)("Unsupported type of action " + alarmAction));
        }
    }
}

