/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.configuration;

import com.google.common.base.Joiner;
import com.vmware.opsmgmt.client.extension.alarms.configuration.DefaultTrigger;
import com.vmware.opsmgmt.client.extension.alarms.configuration.MetricTrigger;
import com.vmware.opsmgmt.client.extension.alarms.configuration.StateTrigger;
import com.vmware.opsmgmt.client.extension.alarms.configuration.Trigger;
import com.vmware.opsmgmt.client.extension.alarms.configuration.TriggerGroup;
import com.vmware.vim.binding.vim.alarm.MetricAlarmExpression;
import com.vmware.vim.binding.vim.alarm.StateAlarmExpression;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="alarmConfiguration")
public class AlarmConfiguration {
    private static final String STATE_PATH_SEPARATOR_ESC = "\\.";
    private static final String STATE_PATH_SEPARATOR = ".";
    private List<StateTrigger> _stateTriggers;
    private List<MetricTrigger> _metricTriggers;
    private List<DefaultTrigger> _defaultTriggers;
    private List<TriggerGroup> _triggerGroups;
    private List<String> _serverCollections = new ArrayList<String>();

    public AlarmConfiguration() {
        this._stateTriggers = new ArrayList<StateTrigger>();
        this._metricTriggers = new ArrayList<MetricTrigger>();
        this._defaultTriggers = new ArrayList<DefaultTrigger>();
        this._triggerGroups = new ArrayList<TriggerGroup>();
    }

    @XmlElementWrapper(name="triggerGroups")
    @XmlElement(name="TriggerGroup")
    public void setTriggerGroups(List<TriggerGroup> list) {
        this._triggerGroups = list;
    }

    @XmlElementWrapper(name="stateTriggers")
    @XmlElement(name="Trigger")
    public void setStateTriggers(List<StateTrigger> list) {
        this._stateTriggers = list;
    }

    @XmlElementWrapper(name="metricTriggers")
    @XmlElement(name="Trigger")
    public void setMetricTriggers(List<MetricTrigger> list) {
        this._metricTriggers = list;
    }

    @XmlElementWrapper(name="defaultTriggers")
    @XmlElement(name="DefaultTrigger")
    public void setDefaultTriggers(List<DefaultTrigger> list) {
        this._defaultTriggers = list;
    }

    public List<StateTrigger> getStateTriggers() {
        return this._stateTriggers;
    }

    public List<MetricTrigger> getMetricTriggers() {
        return this._metricTriggers;
    }

    public List<DefaultTrigger> getDefaultTriggers() {
        return this._defaultTriggers;
    }

    public List<TriggerGroup> getTriggerGroups() {
        return this._triggerGroups;
    }

    public List<String> getServerCollection() {
        return this._serverCollections;
    }

    public StateTrigger getStateTrigger(StateAlarmExpression stateAlarmExpression) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{stateAlarmExpression});
        String string = this.stripPackageName(stateAlarmExpression.type.getName());
        String string2 = stateAlarmExpression.statePath;
        for (StateTrigger stateTrigger : this._stateTriggers) {
            if (!stateTrigger.monitorObjectType.equals(string) || !stateTrigger.statePath.equals(string2)) continue;
            return stateTrigger;
        }
        return null;
    }

    public MetricTrigger getMetricTrigger(MetricAlarmExpression metricAlarmExpression, String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{metricAlarmExpression});
        String string2 = metricAlarmExpression.metric.instance;
        String string3 = this.stripPackageName(metricAlarmExpression.type.getName());
        if (!StringUtil.isNullOrEmpty((String)string)) {
            string = string.toLowerCase();
        }
        if (!StringUtil.isNullOrEmpty((String)string2)) {
            string2 = string2.toLowerCase();
        }
        for (MetricTrigger metricTrigger : this._metricTriggers) {
            if (!metricTrigger.monitorObjectType.equals(string3) || !metricTrigger.counter.equals(string) || !metricTrigger.counterInstance.equals(string2)) continue;
            return metricTrigger;
        }
        return null;
    }

    private String stripPackageName(String string) {
        return string.substring(string.lastIndexOf(STATE_PATH_SEPARATOR) + 1);
    }

    public Trigger getDefaultTrigger(String string, int n) {
        if (n == -1) {
            TriggerGroup triggerGroup = this._triggerGroups.get(0);
            n = triggerGroup.id;
        }
        DefaultTrigger object = null;
        for (DefaultTrigger object2 : this._defaultTriggers) {
            if (!object2.monitorObjectType.equals(string) || object2.groupId != n) continue;
            object = object2;
            break;
        }
        if (object != null) {
            for (StateTrigger stateTrigger : this._stateTriggers) {
                if (!stateTrigger.nameResourceId.equals(object.triggerNameResourceId) || stateTrigger.groupId != object.groupId) continue;
                return stateTrigger;
            }
            for (MetricTrigger metricTrigger : this._metricTriggers) {
                if (!metricTrigger.nameResourceId.equals(object.triggerNameResourceId) || metricTrigger.groupId != object.groupId) continue;
                return metricTrigger;
            }
        }
        return null;
    }

    public List<Trigger> getTriggersByMoType(String string) {
        ArrayList<Trigger> arrayList = new ArrayList<Trigger>();
        for (StateTrigger trigger : this._stateTriggers) {
            if (!trigger.monitorObjectType.equals(string)) continue;
            arrayList.add(trigger);
        }
        for (MetricTrigger metricTrigger : this._metricTriggers) {
            if (!metricTrigger.monitorObjectType.equals(string)) continue;
            arrayList.add(metricTrigger);
        }
        return arrayList;
    }

    public List<MetricTrigger> getMetricTriggersByMoType(String string) {
        ArrayList<MetricTrigger> arrayList = new ArrayList<MetricTrigger>();
        for (MetricTrigger metricTrigger : this._metricTriggers) {
            if (!metricTrigger.monitorObjectType.equals(string)) continue;
            arrayList.add(metricTrigger);
        }
        return arrayList;
    }

    private void processStateTrigger(StateTrigger stateTrigger) {
        String string;
        Object[] objectArray = stateTrigger.statePath.split(STATE_PATH_SEPARATOR_ESC);
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = objectArray[i];
            if ((string2 = this.lowerFirstLetter(string2)).charAt(string2.length() - 1) == '_') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            objectArray[i] = string2;
        }
        stateTrigger.statePath = Joiner.on((String)STATE_PATH_SEPARATOR).join(objectArray);
        stateTrigger.states.serverCollection = string = this.lowerFirstLetter(stateTrigger.states.serverCollection);
        if (string != null && !string.isEmpty()) {
            this._serverCollections.add(string);
        }
    }

    private String lowerFirstLetter(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return string;
        }
        if (string.length() == 1) {
            return string.toLowerCase();
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    private void processMetricTrigger(MetricTrigger metricTrigger) {
        metricTrigger.counter = metricTrigger.counter.toLowerCase();
        if (!StringUtil.isNullOrEmpty((String)metricTrigger.counterInstance)) {
            metricTrigger.counterInstance = metricTrigger.counterInstance.toLowerCase();
        }
    }

    private TriggerGroup getTriggerGroup(int n) {
        for (TriggerGroup triggerGroup : this._triggerGroups) {
            if (triggerGroup.id != n) continue;
            return triggerGroup;
        }
        return null;
    }

    public void process() {
        this._serverCollections.clear();
        for (StateTrigger trigger : this._stateTriggers) {
            this.processStateTrigger(trigger);
        }
        for (MetricTrigger metricTrigger : this._metricTriggers) {
            this.processMetricTrigger(metricTrigger);
        }
    }
}

