/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.actions;

import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionConfigDescription;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionGroup;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionWrapperFactory;
import com.vmware.vim.binding.vim.action.Action;
import com.vmware.vim.binding.vim.action.CreateTaskAction;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.action.RunScriptAction;
import com.vmware.vim.binding.vim.action.SendEmailAction;
import com.vmware.vim.binding.vim.action.SendSNMPAction;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ActionGroupBuilder {
    public static final String NEW_LINE = "<br />";
    protected ActionWrapperFactory _actionWrapperFactory = new ActionWrapperFactory();

    public List<ActionGroup> build(AlarmTriggeringAction alarmTriggeringAction, Map<ManagedObjectReference, String> map) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{alarmTriggeringAction, map});
        ArrayList<ActionGroup> arrayList = new ArrayList<ActionGroup>();
        if (ArrayUtil.isNullOrEmpty((Object[])alarmTriggeringAction.transitionSpecs)) {
            return arrayList;
        }
        for (AlarmTriggeringAction.TransitionSpec transitionSpec : alarmTriggeringAction.transitionSpecs) {
            arrayList.add(this.createActionGroup(alarmTriggeringAction, transitionSpec, map));
        }
        return arrayList;
    }

    protected ActionGroup createActionGroup(AlarmTriggeringAction alarmTriggeringAction, AlarmTriggeringAction.TransitionSpec transitionSpec, Map<ManagedObjectReference, String> map) {
        ActionWrapper actionWrapper = this._actionWrapperFactory.create(alarmTriggeringAction, map);
        String string = this.buildActionName(actionWrapper.getName(), transitionSpec);
        for (ActionConfigDescription actionConfigDescription : actionWrapper.getConfiguration()) {
            string = this.appendProperty(string, actionConfigDescription);
        }
        return new ActionGroup(string, transitionSpec);
    }

    protected String buildActionName(String string, AlarmTriggeringAction.TransitionSpec transitionSpec) {
        String string2 = this.getRepetition(transitionSpec);
        String string3 = "actions.template";
        String string4 = Localization.getFormattedString(string3, new String[]{string, string2});
        return string4;
    }

    protected String getRepetition(AlarmTriggeringAction.TransitionSpec transitionSpec) {
        if (transitionSpec.repeats) {
            return Localization.getString("actions.repeat.recur");
        }
        return Localization.getString("actions.repeat.once");
    }

    protected String appendProperty(String string, ActionConfigDescription actionConfigDescription) {
        if (actionConfigDescription == null || StringUtil.isNullOrEmpty((String)actionConfigDescription.toString())) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(NEW_LINE);
        stringBuilder.append("<b>" + actionConfigDescription.getLocalizedName() + "</b> ");
        stringBuilder.append(actionConfigDescription.getLocalizedValue());
        return stringBuilder.toString();
    }

    public boolean isSupported(Action action) {
        return action instanceof CreateTaskAction || action instanceof MethodAction || action instanceof RunScriptAction || action instanceof SendEmailAction || action instanceof SendSNMPAction;
    }
}

