/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.actions;

import com.vmware.opsmgmt.client.commons.util.ManagedObjectTypes;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.CreateTaskActionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.MethodNameWrapper;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.MigrateVmActionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.RunScriptActionWrapper;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.SendMailActionWrapper;
import com.vmware.vim.binding.impl.vmodl.MethodNameImpl;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.action.Action;
import com.vmware.vim.binding.vim.action.CreateTaskAction;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.action.MethodActionArgument;
import com.vmware.vim.binding.vim.action.RunScriptAction;
import com.vmware.vim.binding.vim.action.SendEmailAction;
import com.vmware.vim.binding.vim.action.SendSNMPAction;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ActionWrapperFactory {
    private static final String POWER_ON_ACTION = "PowerOnVM_Task";
    private static final String POWER_OFF_ACTION = "PowerOffVM_Task";
    private static final String SUSPEND_ACTION = "SuspendVM_Task";
    private static final String RESET_VM_ACTION = "ResetVM_Task";
    private static final String REBOOT_GUEST_ACTION = "RebootGuest";
    private static final String SHUTDOWN_GUEST_ACTION = "ShutdownGuest";
    private static final String MIGRATE_VM_ACTION = "MigrateVM_Task";
    private static final String ENTER_MAINTENANCE_ACTION = "EnterMaintenanceMode_Task";
    private static final String EXIT_MAINTENANCE_ACTION = "ExitMaintenanceMode_Task";
    private static final String ENTER_STANDBY_ACTION = "PowerDownHostToStandBy_Task";
    private static final String EXIT_STANDBY_ACTION = "PowerUpHostFromStandBy_Task";
    private static final String REBOOT_HOST_ACTION = "RebootHost_Task";
    private static final String SHUTDOWN_HOST_ACTION = "ShutdownHost_Task";

    public ActionWrapper create(AlarmTriggeringAction alarmTriggeringAction, Map<ManagedObjectReference, String> map) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{alarmTriggeringAction, map});
        Action action = alarmTriggeringAction.action;
        if (action instanceof SendSNMPAction) {
            String string = Localization.getVpxString("Alarm.AlarmHelper.SendTrap");
            return new ActionWrapper(alarmTriggeringAction, string);
        }
        if (action instanceof SendEmailAction) {
            return new SendMailActionWrapper(alarmTriggeringAction);
        }
        if (action instanceof RunScriptAction) {
            return new RunScriptActionWrapper(alarmTriggeringAction);
        }
        if (action instanceof CreateTaskAction) {
            return new CreateTaskActionWrapper(alarmTriggeringAction);
        }
        if (action instanceof MethodAction) {
            String string;
            MethodAction methodAction = (MethodAction)action;
            switch (string = ((MethodNameImpl)methodAction.name).getWsdlName()) {
                case "PowerOnVM_Task": {
                    return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.PowerOnVM"));
                }
                case "PowerOffVM_Task": {
                    return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.PowerOffVM"));
                }
                case "SuspendVM_Task": {
                    return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.SuspendVM"));
                }
                case "ResetVM_Task": {
                    return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.ResetVM"));
                }
                case "RebootHost_Task": {
                    return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.RebootHost"));
                }
                case "RebootGuest": {
                    return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.RebootGuestOnVM"));
                }
                case "ShutdownHost_Task": {
                    return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.ShutdownHost"));
                }
                case "ShutdownGuest": {
                    return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.ShutdownGuestOnVM"));
                }
                case "EnterMaintenanceMode_Task": {
                    return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.EnterMaintenanceMode"));
                }
                case "ExitMaintenanceMode_Task": {
                    return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.ExitMaintenanceMode"));
                }
                case "PowerDownHostToStandBy_Task": {
                    return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.EnterStandbyMode"));
                }
                case "PowerUpHostFromStandBy_Task": {
                    return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.ExitStandbyMode"));
                }
                case "MigrateVM_Task": {
                    MigrateVmActionWrapper migrateVmActionWrapper = new MigrateVmActionWrapper(alarmTriggeringAction);
                    migrateVmActionWrapper.setRpName(map.get(migrateVmActionWrapper.getResourcePool()));
                    migrateVmActionWrapper.setHostName(map.get(migrateVmActionWrapper.getHost()));
                    return migrateVmActionWrapper;
                }
            }
        }
        return null;
    }

    private String getVpxString(String string) {
        return Localization.getVpxString(string);
    }

    public List<ActionWrapper> createDefault(String string) {
        ArrayList<ActionWrapper> arrayList = new ArrayList<ActionWrapper>();
        AlarmTriggeringAction alarmTriggeringAction = new AlarmTriggeringAction();
        alarmTriggeringAction.action = new SendEmailAction();
        arrayList.add(new SendMailActionWrapper(alarmTriggeringAction));
        alarmTriggeringAction = new AlarmTriggeringAction();
        alarmTriggeringAction.action = new SendSNMPAction();
        arrayList.add(new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.SendTrap")));
        alarmTriggeringAction = new AlarmTriggeringAction();
        alarmTriggeringAction.action = new RunScriptAction();
        arrayList.add(new RunScriptActionWrapper(alarmTriggeringAction));
        if (ManagedObjectTypes.VIRTUAL_MACHINE.name().equals(string)) {
            this.addVmDefaultActions(arrayList);
        }
        if (ManagedObjectTypes.HOST.name().equals(string)) {
            this.addHostDefaultActions(arrayList);
        }
        for (ActionWrapper actionWrapper : arrayList) {
            this.addDefaulTransitionSpec(actionWrapper);
        }
        return arrayList;
    }

    private void addVmDefaultActions(List<ActionWrapper> list) {
        AlarmTriggeringAction alarmTriggeringAction = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(RESET_VM_ACTION);
        alarmTriggeringAction.action = methodAction;
        list.add(new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.ResetVM")));
        alarmTriggeringAction = new AlarmTriggeringAction();
        methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(POWER_ON_ACTION);
        alarmTriggeringAction.action = methodAction;
        list.add(new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.PowerOnVM")));
        alarmTriggeringAction = new AlarmTriggeringAction();
        methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(POWER_OFF_ACTION);
        alarmTriggeringAction.action = methodAction;
        list.add(new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.PowerOffVM")));
        alarmTriggeringAction = new AlarmTriggeringAction();
        methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(SUSPEND_ACTION);
        alarmTriggeringAction.action = methodAction;
        list.add(new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.SuspendVM")));
        alarmTriggeringAction = new AlarmTriggeringAction();
        methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(MIGRATE_VM_ACTION);
        alarmTriggeringAction.action = methodAction;
        list.add(new MigrateVmActionWrapper(alarmTriggeringAction));
        alarmTriggeringAction = new AlarmTriggeringAction();
        methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(REBOOT_GUEST_ACTION);
        alarmTriggeringAction.action = methodAction;
        list.add(new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.RebootGuestOnVM")));
        alarmTriggeringAction = new AlarmTriggeringAction();
        methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(SHUTDOWN_GUEST_ACTION);
        alarmTriggeringAction.action = methodAction;
        list.add(new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.ShutdownGuestOnVM")));
    }

    private void addHostDefaultActions(List<ActionWrapper> list) {
        list.add(this.createEnterMaintenanceMode());
        list.add(this.createExitMaintenanceMode());
        list.add(this.createStandByMode());
        list.add(this.createExitStandByMode());
        list.add(this.createRebootHost());
        list.add(this.createShutdownHost());
    }

    private ActionWrapper createShutdownHost() {
        AlarmTriggeringAction alarmTriggeringAction = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(SHUTDOWN_HOST_ACTION);
        MethodActionArgument methodActionArgument = new MethodActionArgument();
        methodActionArgument.value = true;
        methodAction.argument = new MethodActionArgument[]{methodActionArgument};
        alarmTriggeringAction.action = methodAction;
        return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.ShutdownHost"));
    }

    private ActionWrapper createRebootHost() {
        AlarmTriggeringAction alarmTriggeringAction = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(REBOOT_HOST_ACTION);
        MethodActionArgument methodActionArgument = new MethodActionArgument();
        methodActionArgument.value = true;
        methodAction.argument = new MethodActionArgument[]{methodActionArgument};
        alarmTriggeringAction.action = methodAction;
        return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.RebootHost"));
    }

    private ActionWrapper createExitStandByMode() {
        AlarmTriggeringAction alarmTriggeringAction = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(EXIT_STANDBY_ACTION);
        MethodActionArgument methodActionArgument = new MethodActionArgument();
        methodActionArgument.value = 0;
        methodAction.argument = new MethodActionArgument[]{methodActionArgument};
        alarmTriggeringAction.action = methodAction;
        return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.ExitStandbyMode"));
    }

    private ActionWrapper createStandByMode() {
        AlarmTriggeringAction alarmTriggeringAction = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(ENTER_STANDBY_ACTION);
        MethodActionArgument methodActionArgument = new MethodActionArgument();
        methodActionArgument.value = 0;
        MethodActionArgument methodActionArgument2 = new MethodActionArgument();
        methodActionArgument.value = false;
        methodAction.argument = new MethodActionArgument[]{methodActionArgument, methodActionArgument2};
        alarmTriggeringAction.action = methodAction;
        return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.EnterStandbyMode"));
    }

    private ActionWrapper createExitMaintenanceMode() {
        AlarmTriggeringAction alarmTriggeringAction = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(EXIT_MAINTENANCE_ACTION);
        MethodActionArgument methodActionArgument = new MethodActionArgument();
        methodActionArgument.value = 0;
        methodAction.argument = new MethodActionArgument[]{methodActionArgument};
        alarmTriggeringAction.action = methodAction;
        return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.ExitMaintenanceMode"));
    }

    private ActionWrapper createEnterMaintenanceMode() {
        AlarmTriggeringAction alarmTriggeringAction = new AlarmTriggeringAction();
        MethodAction methodAction = new MethodAction();
        methodAction.name = new MethodNameWrapper(ENTER_MAINTENANCE_ACTION);
        MethodActionArgument methodActionArgument = new MethodActionArgument();
        methodActionArgument.value = 0;
        MethodActionArgument methodActionArgument2 = new MethodActionArgument();
        methodActionArgument.value = false;
        methodAction.argument = new MethodActionArgument[]{methodActionArgument, methodActionArgument2};
        alarmTriggeringAction.action = methodAction;
        return new ActionWrapper(alarmTriggeringAction, this.getVpxString("Alarm.AlarmHelper.EnterMaintenanceMode"));
    }

    private void addDefaulTransitionSpec(ActionWrapper actionWrapper) {
        AlarmTriggeringAction.TransitionSpec transitionSpec = new AlarmTriggeringAction.TransitionSpec();
        transitionSpec.startState = ManagedEntity.Status.yellow;
        transitionSpec.finalState = ManagedEntity.Status.red;
        transitionSpec.repeats = false;
        actionWrapper.setYellowToRed(transitionSpec);
    }
}

