/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.actions;

import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionConfigDescription;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionWrapper;
import com.vmware.vim.binding.vim.action.CreateTaskAction;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;

public class CreateTaskActionWrapper
extends ActionWrapper {
    public static final String CANCELABLE = "cancelable";
    public static final String TASK_TYPE_ID = "taskTypeId";

    public CreateTaskActionWrapper(AlarmTriggeringAction alarmTriggeringAction) {
        super(alarmTriggeringAction, Localization.getVpxString("action.task.actionName"));
    }

    @Override
    public List<ActionConfigDescription> getConfiguration() {
        ArrayList<ActionConfigDescription> arrayList = new ArrayList<ActionConfigDescription>();
        CreateTaskAction createTaskAction = (CreateTaskAction)this._action.action;
        ActionConfigDescription actionConfigDescription = new ActionConfigDescription(CANCELABLE, Localization.getString("action.task.cancelable"), createTaskAction.cancelable, this.getTaskCancelable(createTaskAction));
        arrayList.add(actionConfigDescription);
        ActionConfigDescription actionConfigDescription2 = new ActionConfigDescription(TASK_TYPE_ID, Localization.getString("action.task.taskTypeId"), createTaskAction.taskTypeId.toString(), createTaskAction.taskTypeId.toString());
        arrayList.add(actionConfigDescription2);
        return arrayList;
    }

    @Override
    public void setConfiguration(List<ActionConfigDescription> list) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list});
        CreateTaskAction createTaskAction = (CreateTaskAction)this._action.action;
        for (ActionConfigDescription actionConfigDescription : list) {
            String string;
            switch (string = actionConfigDescription.getName()) {
                case "taskTypeId": {
                    createTaskAction.taskTypeId = actionConfigDescription.getValue().toString();
                    break;
                }
                case "cancelable": {
                    createTaskAction.cancelable = Boolean.getBoolean(actionConfigDescription.getValue().toString());
                }
            }
        }
    }

    @Override
    public String getConfigString() {
        CreateTaskAction createTaskAction = (CreateTaskAction)this._action.action;
        String string = Boolean.toString(createTaskAction.cancelable);
        String string2 = createTaskAction.taskTypeId;
        if (StringUtil.isNullOrEmpty((String)string2)) {
            return "";
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            string = "false";
        }
        return Localization.getString("action.task.taskTypeId") + " " + string2 + ", " + Localization.getString("action.task.cancelable") + " " + string;
    }

    @Override
    public String validateConfigString(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            String string2 = "createTaskActionWrapper.error.configure.taskId";
            return Localization.getString(string2);
        }
        return "";
    }

    @Override
    public boolean supportsConfiguration() {
        return true;
    }

    @Override
    protected String validateConfigurationInternal() {
        CreateTaskAction createTaskAction = (CreateTaskAction)this._action.action;
        return this.validateConfigString(createTaskAction.taskTypeId);
    }

    private String getTaskCancelable(CreateTaskAction createTaskAction) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{createTaskAction});
        if (createTaskAction.cancelable) {
            return Localization.getString("action.task.cancelable.true");
        }
        return Localization.getString("action.task.cancelable.false");
    }
}

