/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.expressions;

import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.alarms.EventAlarmDetails;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.configuration.Trigger;
import com.vmware.opsmgmt.client.extension.alarms.expressions.ExpressionWrapper;
import com.vmware.vim.binding.vim.alarm.EventAlarmExpression;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;

public class EventExpressionWrapper
extends ExpressionWrapper {
    private static final String BINDING_PACKAGE = "com.vmware.vim.binding.";
    private final EventAlarmExpression _expression;
    private EventAlarmDetails _details;
    private String _name;

    public EventExpressionWrapper(EventAlarmExpression eventAlarmExpression, AlarmDefinitionInfo alarmDefinitionInfo) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{eventAlarmExpression, alarmDefinitionInfo});
        this._expression = eventAlarmExpression;
        this._info = alarmDefinitionInfo;
        String string = this.getEventTypeId();
        this._details = this.getEventDetails(string, this._info);
        if (this._details != null) {
            this._name = this._details.description;
        }
        if (StringUtil.isNullOrEmpty((String)this._name)) {
            this._name = string;
        }
    }

    public EventAlarmExpression getExpression() {
        return this._expression;
    }

    public EventAlarmDetails getDetails() {
        return this._details;
    }

    public EventAlarmExpression.Comparison[] getComparisons() {
        return this._expression.comparisons;
    }

    public void setComparisons(EventAlarmExpression.Comparison[] comparisonArray) {
        this._expression.comparisons = comparisonArray;
    }

    @Override
    public Trigger getTrigger() {
        return null;
    }

    public String getName() {
        return this._name;
    }

    public String getStatus() {
        if (this._expression.status == null) {
            return Localization.getVpxString("Alarm.AlarmHelper.AlarmStatus.Unset");
        }
        switch (this._expression.status) {
            case gray: {
                return Localization.getVpxString("Alarm.AlarmHelper.AlarmStatus.Unset");
            }
            case green: {
                return Localization.getVpxString("Alarm.AlarmHelper.AlarmStatus.Green");
            }
            case yellow: {
                return Localization.getVpxString("Alarm.AlarmHelper.AlarmStatus.Yellow");
            }
            case red: {
                return Localization.getVpxString("Alarm.AlarmHelper.AlarmStatus.Red");
            }
        }
        return Localization.getVpxString("Alarm.AlarmHelper.AlarmStatus.Unset");
    }

    public String getAttributeName(String string) {
        if (this._details != null) {
            for (EventDescription.EventArgDesc eventArgDesc : this._details.eventArguments) {
                if (!eventArgDesc.name.equals(string)) continue;
                return eventArgDesc.description.label;
            }
        }
        return string;
    }

    public String getOperator(String string) {
        if (EventAlarmExpression.ComparisonOperator.startsWith.name().equals(string)) {
            return Localization.getVpxString("Alarm.AlarmHelper.Comparison.StartsWith");
        }
        if (EventAlarmExpression.ComparisonOperator.doesNotStartWith.name().equals(string)) {
            return Localization.getVpxString("Alarm.AlarmHelper.Comparison.DoesNotStartWith");
        }
        if (EventAlarmExpression.ComparisonOperator.endsWith.name().equals(string)) {
            return Localization.getVpxString("Alarm.AlarmHelper.Comparison.EndsWith");
        }
        if (EventAlarmExpression.ComparisonOperator.doesNotEndWith.name().equals(string)) {
            return Localization.getVpxString("Alarm.AlarmHelper.Comparison.DoesNotEndWith");
        }
        if (EventAlarmExpression.ComparisonOperator.equals.name().equals(string)) {
            return Localization.getVpxString("Alarm.AlarmHelper.Comparison.Equals");
        }
        if (EventAlarmExpression.ComparisonOperator.notEqualTo.name().equals(string)) {
            return Localization.getVpxString("Alarm.AlarmHelper.Comparison.NotEqualTo");
        }
        return string;
    }

    public boolean isCustomEvent() {
        if (this.getDetails() == null) {
            return true;
        }
        return this._details.isCustomEvent;
    }

    public Boolean isSystemUnknownEvent() {
        return !this.isCustomEvent() && (this._details == null || StringUtil.isNullOrEmpty((String)this._details.description));
    }

    private String getEventTypeId() {
        String string = this._expression.eventTypeId;
        if (StringUtil.isNullOrEmpty((String)string)) {
            String string2 = this._expression.eventType.getName();
            string = string2.replace(BINDING_PACKAGE, "");
        }
        return string;
    }

    private EventAlarmDetails getEventDetails(String string, AlarmDefinitionInfo alarmDefinitionInfo) {
        for (EventAlarmDetails eventAlarmDetails : alarmDefinitionInfo.events) {
            if (!eventAlarmDetails.eventTypeId.equals(string)) continue;
            return eventAlarmDetails;
        }
        return null;
    }
}

