/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.websso;

import com.vmware.identity.websso.client.MetadataSettings;
import com.vmware.identity.websso.client.endpoint.SsoResponseListener;
import com.vmware.vsphere.client.security.websso.MetadataGenerator;
import com.vmware.vsphere.client.security.websso.WebssoUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.HttpRequestHandler;

public class WebssoAssertionHandler
implements HttpRequestHandler {
    private static final Log _logger = LogFactory.getLog(WebssoAssertionHandler.class);
    private final SsoResponseListener _ssoResponseListener;
    private final MetadataSettings _metadataSettings;
    private final MetadataGenerator _metadataGenerator;

    @Autowired
    public WebssoAssertionHandler(SsoResponseListener ssoResponseListener, MetadataSettings metadataSettings, MetadataGenerator metadataGenerator) {
        this._ssoResponseListener = ssoResponseListener;
        this._metadataSettings = metadataSettings;
        this._metadataGenerator = metadataGenerator;
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean bl;
        _logger.info((Object)"Received an SAML assertion from SSO server. Processing it now...");
        do {
            try {
                this._ssoResponseListener.consumeResponse("csp_ngc", httpServletRequest, httpServletResponse);
                WebssoUtil.WebssoAction webssoAction = WebssoUtil.WebssoAction.getFromRequest(httpServletRequest);
                if (webssoAction == WebssoUtil.WebssoAction.REFRESH_METADATA_AND_RETRY) {
                    _logger.info((Object)"Will refresh the metadata and will retry processing the WebSSO assertion");
                    this._metadataSettings.clear();
                    this._metadataGenerator.processMetadata((ServletRequest)httpServletRequest);
                    WebssoUtil.WebssoAction.REFRESHED_METADATA_AND_RETRYING.setInRequest(httpServletRequest);
                    bl = false;
                    continue;
                }
                bl = true;
            }
            catch (IOException | RuntimeException | ServletException throwable) {
                _logger.error((Object)"The handling of a WebSSO assertion failed", throwable);
                throw throwable;
            }
        } while (!bl);
    }
}

