/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.websso;

import com.vmware.identity.websso.client.SloRequestSettings;
import com.vmware.identity.websso.client.endpoint.SloRequestSender;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vsphere.client.security.util.Util;
import com.vmware.vsphere.client.security.websso.MetadataGenerator;
import com.vmware.vsphere.client.security.websso.WebssoUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.HttpRequestHandler;

public class WebssoLogoutRequestHandler
implements HttpRequestHandler {
    private static final Log _logger = LogFactory.getLog(WebssoLogoutRequestHandler.class);
    private final SloRequestSender _sloRequestSender;
    private final MetadataGenerator _metadataGenerator;

    @Autowired
    public WebssoLogoutRequestHandler(SloRequestSender sloRequestSender, MetadataGenerator metadataGenerator) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{sloRequestSender, metadataGenerator});
        this._sloRequestSender = sloRequestSender;
        this._metadataGenerator = metadataGenerator;
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            _logger.info((Object)"Received WebSSO logout request");
            this._metadataGenerator.processMetadata((ServletRequest)httpServletRequest);
            String string = WebssoUtil.getSPAlias(httpServletRequest);
            String string2 = (String)SessionUtil.getData((String)"USER_NAME");
            if (string2 == null) {
                _logger.trace((Object)"Username not found in session. Session probably expired. Trying browser cookies.");
                string2 = WebssoUtil.getUsernameCookieValue(httpServletRequest);
            }
            if (string2 == null) {
                _logger.warn((Object)"Username not found in browser cookies, will skip logging out of SSO.");
                return;
            }
            String string3 = WebssoUtil.getWebSsoSessionIndex(httpServletRequest);
            if (string3 == null) {
                _logger.trace((Object)"Session index not found in session. Session probably expired. Trying browser cookies.");
                string3 = WebssoUtil.getSessionIndexCookieValue(httpServletRequest);
            }
            if (string3 == null) {
                _logger.warn((Object)"Session index not found in browser cookies, will skip logging out of SSO.");
                return;
            }
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)("Resolved userName to: " + string2 + " sessionIndex to: " + string3));
            }
            SloRequestSettings sloRequestSettings = new SloRequestSettings(string, "csp_ngc", Boolean.valueOf(true), string2, "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", string3, null);
            _logger.info((Object)"Redirecting to WebSSO");
            this._sloRequestSender.sendRequest(sloRequestSettings, httpServletResponse);
            if (httpServletResponse.getStatus() != 302) {
                throw new IllegalStateException("The redirect to WebSSO failed");
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"The handling of the WebSSO logout request failed", (Throwable)exception);
            String string = String.format(Util.getLocalizedString("websso.logoutRequestError", new String[0]), exception.getMessage());
            httpServletResponse.sendError(400, string);
        }
    }
}

