/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.ssl;

import java.io.FileOutputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;

public class VecsCopyTool {
    KeyStore _keystore;
    KeyStore _solutionUserKeyStore;
    KeyStore _destination;
    static final char[] password = "vmw@re".toCharArray();
    static final String SERVICE_ALIAS = "vsphere-webclient";

    public VecsCopyTool(KeyStore keyStore, KeyStore keyStore2, KeyStore keyStore3) {
        this._keystore = keyStore;
        this._solutionUserKeyStore = keyStore2;
        this._destination = keyStore3;
    }

    private void msg(String string, Object ... objectArray) {
        System.out.println(MessageFormat.format(string, objectArray));
    }

    public void printContents() throws KeyStoreException {
        this.printContents(this._keystore);
        this.printContents(this._solutionUserKeyStore);
    }

    private void printContents(KeyStore keyStore) throws KeyStoreException {
        Provider provider = keyStore.getProvider();
        this.msg("Keystore provider is {0}, version {1}, info {2} ", provider.getName(), provider.getVersion(), provider.getInfo());
        Enumeration<String> enumeration = keyStore.aliases();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            ++n;
            String string = enumeration.nextElement();
            this.msg("", new Object[0]);
            this.msg("", new Object[0]);
            this.msg("================================================================================", new Object[0]);
            this.msg("{0}. {1}", n4, string);
            this.msg("================================================================================", new Object[0]);
            try {
                Serializable serializable;
                KeyStore.Entry entry = keyStore.getEntry(string, null);
                if (this._destination != null) {
                    this._destination.setEntry(string, entry, null);
                }
                if (entry instanceof KeyStore.TrustedCertificateEntry) {
                    serializable = ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
                    this.msg("Trusted certificate of type {0} with contents {1}", ((Certificate)serializable).getType(), ((Certificate)serializable).toString());
                    ++n3;
                } else if (entry instanceof KeyStore.SecretKeyEntry) {
                    serializable = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
                    this.msg("Secret key with algorithm {0} and format {1}", serializable.getAlgorithm(), serializable.getFormat());
                } else if (entry instanceof KeyStore.PrivateKeyEntry) {
                    serializable = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
                    this.msg("Private key with algorithm {0} and format {1}", serializable.getAlgorithm(), serializable.getFormat());
                }
            }
            catch (KeyStoreException keyStoreException) {
                this.msg("KeyStoreException error printing alias {0}", string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.msg("NoSuchAlgorithmException error printing alias {0}", string);
            }
            catch (UnrecoverableEntryException unrecoverableEntryException) {
                this.msg("UnrecoverableEntryException error printing alias {0}", string);
            }
            n2 += this.printKey(keyStore, string) ? 1 : 0;
            ++n4;
        }
        this.msg("Listed {0} certificates and {1} private keys out of {2} entries", n3, n2, n);
    }

    private boolean printKey(KeyStore keyStore, String string) {
        try {
            Key key = keyStore.getKey(string, null);
            if (null != key) {
                this.msg("Private key for alias {0} has algorithm {1} and format {2}", string, key.getAlgorithm(), key.getFormat());
                if (this._destination != null) {
                    Certificate[] certificateArray = new Certificate[]{keyStore.getCertificate(string)};
                    this._destination.setKeyEntry(string, key, password, certificateArray);
                }
                return true;
            }
            this.msg("No key found for alias {0}", string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.msg("No Private Key under alias {0} exception class {1} message {2}", string, generalSecurityException.getClass().getName(), generalSecurityException.getMessage());
        }
        return false;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        KeyStore keyStore;
        System.out.println("Starting VECS explorer...");
        System.out.println("Running as: " + System.getProperty("user.name"));
        try {
            keyStore = KeyStore.getInstance("VKS");
            System.out.println("VKS keystore resolved");
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
            return;
        }
        try {
            object3 = Class.forName("com.vmware.provider.VecsLoadStoreParameter");
            object2 = (KeyStore.LoadStoreParameter)((Class)object3).getConstructor(String.class).newInstance("TRUSTED_ROOTS");
            keyStore.load((KeyStore.LoadStoreParameter)object2);
            System.out.println("VKS keystore loaded");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            object3 = KeyStore.getInstance("VKS");
            object2 = Class.forName("com.vmware.provider.VecsLoadStoreParameter");
            object = (KeyStore.LoadStoreParameter)((Class)object2).getConstructor(String.class).newInstance(SERVICE_ALIAS);
            ((KeyStore)object3).load((KeyStore.LoadStoreParameter)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        object2 = null;
        if (stringArray.length > 0 && "-dump".equals(stringArray[0])) {
            try {
                object2 = KeyStore.getInstance(KeyStore.getDefaultType());
                ((KeyStore)object2).load(null, password);
            }
            catch (Exception exception) {
                System.out.println("Cannot initialize destination keystore");
                exception.printStackTrace();
                return;
            }
        }
        object = new VecsCopyTool(keyStore, (KeyStore)object3, (KeyStore)object2);
        try {
            ((VecsCopyTool)object).printContents();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        if (object2 != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream("dump.jks");
                ((KeyStore)object2).store(fileOutputStream, password);
            }
            catch (Exception exception) {
                System.out.println("Cannot persist destination keystore");
                exception.printStackTrace();
            }
        }
        System.out.println("Done.");
    }
}

