/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.util;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VecsUtil {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    @Nullable
    public static CertStore getVecsCrlCertStore() {
        return VecsCrlCertStoreHolder.VECS_CRL_CERT_STORE;
    }

    private static class VecsCrlCertStoreHolder {
        private static final String VECS_CERT_STORE_PARAMS_CLASS_NAME = "com.vmware.provider.VecsCertStoreParameters";
        private static final String VECS_CRL_CERT_STORE_NAME = "TRUSTED_ROOT_CRLS";
        private static final CertStore VECS_CRL_CERT_STORE = VecsCrlCertStoreHolder.loadVecsCrlCertStore();

        private VecsCrlCertStoreHolder() {
        }

        @Nullable
        private static CertStore loadVecsCrlCertStore() {
            try {
                Class<?> clazz = Class.forName(VECS_CERT_STORE_PARAMS_CLASS_NAME);
                Constructor<?> constructor = clazz.getConstructor(String.class);
                CertStoreParameters certStoreParameters = (CertStoreParameters)constructor.newInstance(VECS_CRL_CERT_STORE_NAME);
                CertStore certStore = CertStore.getInstance("VCS", certStoreParameters);
                return certStore;
            }
            catch (ClassNotFoundException classNotFoundException) {
                _logger.warn((Object)"VECS is unavailable: can't find class com.vmware.provider.VecsCertStoreParameters. Will not use certificate revocation lists when checking the validity of certificates");
                return null;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException | InvalidAlgorithmParameterException | NoSuchAlgorithmException exception) {
                _logger.error((Object)"Failed to load the VECS CRL store 'TRUSTED_ROOT_CRLS'", (Throwable)exception);
                return null;
            }
        }
    }
}

