/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.util;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vise.util.StringUtil;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmodlUtil {
    private static final Log _logger = LogFactory.getLog(VmodlUtil.class);
    public static final String MOREF_UID_PREFIX = "urn:vmomi";

    public static String morefToString(String string, String string2, String string3) {
        return "urn:vmomi:" + string + ':' + string2 + ":" + string3;
    }

    public static Class<?> getClassFromTypeName(String string) {
        if (string == null) {
            return null;
        }
        if (string.contains(".")) {
            string = string.substring(string.lastIndexOf(".") + 1);
        }
        return VmodlUtil.wsdlNameToJavaType(string);
    }

    public static <T extends ManagedObject> Class<T> wsdlNameToJavaType(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        Class clazz = null;
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(string);
        if (vmodlType != null) {
            clazz = vmodlType.getTypeClass();
        } else if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Not a valid Vmodl Type: %s", string));
        }
        return clazz;
    }

    public static Class<?> getType(@Nullable ManagedObjectReference managedObjectReference) {
        return VmodlUtil.getType(managedObjectReference, null);
    }

    public static Class<?> getType(@Nullable ManagedObjectReference managedObjectReference, @Nullable VmodlContext vmodlContext) {
        if (managedObjectReference == null) {
            return null;
        }
        String string = managedObjectReference.getType();
        return VmodlUtil.getType(string, vmodlContext);
    }

    public static Class<?> getType(@Nullable String string) {
        return VmodlUtil.getType(string, null);
    }

    public static Class<?> getType(@Nullable String string, @Nullable VmodlContext vmodlContext) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return null;
        }
        VmodlTypeMap vmodlTypeMap = vmodlContext != null ? vmodlContext.getVmodlTypeMap() : VmodlTypeMap.Factory.getTypeMap();
        VmodlType vmodlType = vmodlTypeMap.getVmodlType(string);
        if (vmodlType == null) {
            return null;
        }
        return vmodlType.getTypeClass();
    }
}

