/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vmomi;

import com.vmware.vim.vmomi.client.Client;
import com.vmware.vise.vim.commons.vmomi.ClientAdapter;
import com.vmware.vise.vim.commons.vmomi.HttpConfigurationProvider;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.Validate;

@ThreadSafe
public class ClientWithSharedHttpConfig
extends ClientAdapter {
    private final HttpConfigurationProvider _httpConfigProvider;
    private final String _httpConfigId;

    public ClientWithSharedHttpConfig(@Nonnull Client client, @Nonnull HttpConfigurationProvider httpConfigurationProvider) {
        this(client, httpConfigurationProvider, null);
    }

    public ClientWithSharedHttpConfig(@Nonnull Client client, @Nonnull SharedHttpConfigPool sharedHttpConfigPool) {
        this(client, sharedHttpConfigPool, null);
    }

    public ClientWithSharedHttpConfig(@Nonnull Client client, @Nonnull HttpConfigurationProvider httpConfigurationProvider, @Nullable String string) {
        super(client);
        Validate.notNull((Object)httpConfigurationProvider, (String)"httpConfigProvider is null");
        this._httpConfigProvider = httpConfigurationProvider;
        this._httpConfigId = string;
    }

    @Override
    public void shutdown() {
        RuntimeException runtimeException = null;
        try {
            this._client.shutdown();
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
            throw runtimeException2;
        }
        finally {
            String string = this._httpConfigId;
            if (string == null) {
                string = this._client.getBinding().getEndpointUri().toString();
            }
            try {
                this._httpConfigProvider.releaseHttpConfig(string);
            }
            catch (RuntimeException runtimeException3) {
                if (runtimeException != null) {
                    runtimeException.addSuppressed(runtimeException3);
                }
                throw runtimeException3;
            }
        }
    }
}

