/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.xmlrpc;

import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ssl.SslThumbprintVerifier;
import com.vmware.vise.vim.commons.xmlrpc.CommonXmlRpcHttpTransportFactory;
import com.vmware.vise.vim.commons.xmlrpc.HeaderAwareXmlRpcHttpTransportFactory;
import com.vmware.vise.vim.commons.xmlrpc.SslXmlRpcHttpTransportFactory;
import java.net.URL;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class XmlRpcClient
extends org.apache.xmlrpc.client.XmlRpcClient {
    private static final String COOKIE_KEY = "Cookie";
    private static final Log _logger = LogFactory.getLog(XmlRpcClient.class);
    private String _thumbprint;
    private final KeyStore _keystore;
    private Map<String, String> _customHeaders;
    public HeaderAwareXmlRpcHttpTransportFactory _httpTransportFactory;

    public XmlRpcClient() {
        this._keystore = null;
        this.setupXmlRpcClientForHttp();
    }

    public XmlRpcClient(String string) {
        this._thumbprint = string;
        this._keystore = null;
        this.setupXmlRpcClientForHttps();
    }

    public XmlRpcClient(KeyStore keyStore) {
        this._keystore = keyStore;
        this.setupXmlRpcClientForHttps();
    }

    public XmlRpcClient(Map<String, String> map) {
        this._keystore = null;
        this._customHeaders = map;
        this.setupXmlRpcClientForHttp();
    }

    public XmlRpcClient(String string, Map<String, String> map) {
        this._thumbprint = string;
        this._keystore = null;
        this._customHeaders = map;
        this.setupXmlRpcClientForHttps();
    }

    public XmlRpcClient(KeyStore keyStore, Map<String, String> map) {
        this._keystore = keyStore;
        this._customHeaders = map;
        this.setupXmlRpcClientForHttps();
    }

    public XmlRpcClient(URL uRL) {
        this((String)null, uRL, false);
    }

    public XmlRpcClient(URL uRL, boolean bl) {
        this((String)null, uRL, bl);
    }

    public XmlRpcClient(String string, URL uRL, boolean bl) {
        this._thumbprint = string;
        this._keystore = null;
        XmlRpcClientConfigImpl xmlRpcClientConfigImpl = new XmlRpcClientConfigImpl();
        xmlRpcClientConfigImpl.setServerURL(uRL);
        xmlRpcClientConfigImpl.setEnabledForExtensions(bl);
        this.setConfig((XmlRpcClientConfig)xmlRpcClientConfigImpl);
        if (this._thumbprint == null) {
            this.setupXmlRpcClientForHttp();
        } else {
            this.setupXmlRpcClientForHttps();
        }
    }

    public XmlRpcClient(KeyStore keyStore, URL uRL, boolean bl) {
        this._keystore = keyStore;
        XmlRpcClientConfigImpl xmlRpcClientConfigImpl = new XmlRpcClientConfigImpl();
        xmlRpcClientConfigImpl.setServerURL(uRL);
        xmlRpcClientConfigImpl.setEnabledForExtensions(bl);
        this.setConfig((XmlRpcClientConfig)xmlRpcClientConfigImpl);
        if (this._keystore == null) {
            this.setupXmlRpcClientForHttp();
        } else {
            this.setupXmlRpcClientForHttps();
        }
    }

    public String getThumbprint() {
        return this._thumbprint;
    }

    public void setThumbprint(String string) {
        if (string != null && string.equals(this._thumbprint) || string == null && this._thumbprint == null) {
            return;
        }
        this._thumbprint = string;
        if (StringUtil.isNullOrEmpty((String)this._thumbprint)) {
            this.setupXmlRpcClientForHttp();
        } else {
            this.setupXmlRpcClientForHttps();
        }
    }

    public Map<String, String> getCustomHeaders() {
        return this._customHeaders;
    }

    public void setCustomHeaders(Map<String, String> map) {
        this._customHeaders = map;
        this._httpTransportFactory.setCustomRequestHeaders(this._customHeaders);
    }

    public Map<String, List<String>> getLastTransactionResponseHeaders() {
        return this._httpTransportFactory.getLastTransactionResponseHeaders();
    }

    private void setupXmlRpcClientForHttps() {
        try {
            SslThumbprintVerifier sslThumbprintVerifier;
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            ThumbprintTrustManager thumbprintTrustManager = null;
            if (this._keystore != null) {
                thumbprintTrustManager = new ThumbprintTrustManager(this._keystore, null);
            } else {
                sslThumbprintVerifier = new SslThumbprintVerifier();
                sslThumbprintVerifier.setThumbprint(this._thumbprint);
                thumbprintTrustManager = new ThumbprintTrustManager(null, (ThumbprintVerifier)sslThumbprintVerifier);
            }
            sSLContext.init(null, new TrustManager[]{thumbprintTrustManager}, null);
            sslThumbprintVerifier = new ThumbprintTrustManager.HostnameVerifier(thumbprintTrustManager);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            SslXmlRpcHttpTransportFactory sslXmlRpcHttpTransportFactory = new SslXmlRpcHttpTransportFactory(this, this._customHeaders);
            sslXmlRpcHttpTransportFactory.setSSLSocketFactory(sSLSocketFactory);
            this.setTransportFactory(sslXmlRpcHttpTransportFactory);
            this._httpTransportFactory = sslXmlRpcHttpTransportFactory;
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)((Object)sslThumbprintVerifier));
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when initializing XML RPC Client", (Throwable)exception);
        }
    }

    private void setupXmlRpcClientForHttp() {
        CommonXmlRpcHttpTransportFactory commonXmlRpcHttpTransportFactory = new CommonXmlRpcHttpTransportFactory(this, this._customHeaders);
        this.setTransportFactory(commonXmlRpcHttpTransportFactory);
        this._httpTransportFactory = commonXmlRpcHttpTransportFactory;
    }
}

