/*
 * Decompiled with CFR 0.152.
 */
package CisTagging.util;

import com.vmware.cis.tagging.BatchDefinitions;
import com.vmware.cis.tagging.CategoryDefinitions;
import com.vmware.cis.tagging.StructDefinitions;
import com.vmware.cis.tagging.TagAssociationDefinitions;
import com.vmware.cis.tagging.TagDefinitions;
import com.vmware.vapi.bindings.type.StructType;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class StructTypeUtil {
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> map) {
        Validate.notNull(map);
        StructTypeUtil.add(map, "com.vmware.cis.tagging.category_model", StructDefinitions.categoryModel);
        StructTypeUtil.add(map, "com.vmware.cis.tagging.tag_model", StructDefinitions.tagModel);
        StructTypeUtil.add(map, "com.vmware.cis.tagging.batch.tag_to_objects", BatchDefinitions.tagToObjects);
        StructTypeUtil.add(map, "com.vmware.cis.tagging.batch.object_to_tags", BatchDefinitions.objectToTags);
        StructTypeUtil.add(map, "com.vmware.cis.tagging.category.create_spec", CategoryDefinitions.createSpec);
        StructTypeUtil.add(map, "com.vmware.cis.tagging.category.update_spec", CategoryDefinitions.updateSpec);
        StructTypeUtil.add(map, "com.vmware.cis.tagging.tag.create_spec", TagDefinitions.createSpec);
        StructTypeUtil.add(map, "com.vmware.cis.tagging.tag.update_spec", TagDefinitions.updateSpec);
        StructTypeUtil.add(map, "com.vmware.cis.tagging.tag_association.batch_result", TagAssociationDefinitions.batchResult);
        StructTypeUtil.add(map, "com.vmware.cis.tagging.tag_association.tag_to_objects", TagAssociationDefinitions.tagToObjects);
        StructTypeUtil.add(map, "com.vmware.cis.tagging.tag_association.object_to_tags", TagAssociationDefinitions.objectToTags);
    }

    private static void add(Map<String, StructType> map, String string, StructType structType) {
        if (map.containsKey(string)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + string + ". Unable to populate the map.");
        }
        map.put(string, structType);
    }
}

