/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.tagging;

import com.vmware.cis.tagging.BatchDefinitions;
import com.vmware.cis.tagging.BatchProvider;
import com.vmware.cis.tagging.BatchTypes;
import com.vmware.cis.tagging.CategoryModel;
import com.vmware.cis.tagging.TagModel;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.server.impl.AsyncContextImpl;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.DynamicID;
import java.util.List;
import org.apache.commons.lang.Validate;

public class BatchApiInterface
extends ApiInterfaceSkeleton {
    private BatchProvider impl;

    public BatchApiInterface() {
        this((Class<? extends BatchProvider>)null);
    }

    public BatchApiInterface(Class<? extends BatchProvider> clazz) {
        this((BatchProvider)BatchApiInterface.createImplInstance(clazz, (String)"com.vmware.cis.tagging.impl.BatchImpl", BatchProvider.class));
    }

    public BatchApiInterface(BatchProvider batchProvider) {
        super("com.vmware.cis.tagging.batch");
        Validate.notNull((Object)batchProvider);
        this.impl = batchProvider;
        this.registerMethod((ApiMethod)new GetCategoriesApiMethod());
        this.registerMethod((ApiMethod)new GetAllCategoriesApiMethod());
        this.registerMethod((ApiMethod)new GetTagsApiMethod());
        this.registerMethod((ApiMethod)new GetAllTagsApiMethod());
        this.registerMethod((ApiMethod)new ListTagsForCategoriesApiMethod());
        this.registerMethod((ApiMethod)new FindTagsByNameApiMethod());
        this.registerMethod((ApiMethod)new ListAttachedObjectsApiMethod());
        this.registerMethod((ApiMethod)new ListAttachedObjectsOnTagsApiMethod());
        this.registerMethod((ApiMethod)new ListAllAttachedObjectsOnTagsApiMethod());
        this.registerMethod((ApiMethod)new ListAttachedTagsApiMethod());
        this.registerMethod((ApiMethod)new ListAttachedTagsOnObjectsApiMethod());
    }

    private class ListAttachedTagsOnObjectsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachedTagsOnObjectsApiMethod() {
            super(BatchApiInterface.this.getIdentifier(), "list_attached_tags_on_objects", BatchDefinitions.__listAttachedTagsOnObjectsInput, BatchDefinitions.__listAttachedTagsOnObjectsOutput, BatchApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, BatchDefinitions.__listAttachedTagsOnObjectsInput, BatchApiInterface.this.getTypeConverter());
            List list = (List)structValueExtractor.valueForField("object_ids");
            BatchApiInterface.this.impl.listAttachedTagsOnObjects(list, (AsyncContext<List<BatchTypes.ObjectToTags>>)new AsyncContextImpl(BatchApiInterface.this.getTypeConverter(), BatchDefinitions.__listAttachedTagsOnObjectsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListAttachedTagsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachedTagsApiMethod() {
            super(BatchApiInterface.this.getIdentifier(), "list_attached_tags", BatchDefinitions.__listAttachedTagsInput, BatchDefinitions.__listAttachedTagsOutput, BatchApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, BatchDefinitions.__listAttachedTagsInput, BatchApiInterface.this.getTypeConverter());
            List list = (List)structValueExtractor.valueForField("object_ids");
            BatchApiInterface.this.impl.listAttachedTags(list, (AsyncContext<List<String>>)new AsyncContextImpl(BatchApiInterface.this.getTypeConverter(), BatchDefinitions.__listAttachedTagsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListAllAttachedObjectsOnTagsApiMethod
    extends ApiMethodSkeleton {
        public ListAllAttachedObjectsOnTagsApiMethod() {
            super(BatchApiInterface.this.getIdentifier(), "list_all_attached_objects_on_tags", BatchDefinitions.__listAllAttachedObjectsOnTagsInput, BatchDefinitions.__listAllAttachedObjectsOnTagsOutput, BatchApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            new StructValueExtractor(structValue, BatchDefinitions.__listAllAttachedObjectsOnTagsInput, BatchApiInterface.this.getTypeConverter());
            BatchApiInterface.this.impl.listAllAttachedObjectsOnTags((AsyncContext<List<BatchTypes.TagToObjects>>)new AsyncContextImpl(BatchApiInterface.this.getTypeConverter(), BatchDefinitions.__listAllAttachedObjectsOnTagsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListAttachedObjectsOnTagsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachedObjectsOnTagsApiMethod() {
            super(BatchApiInterface.this.getIdentifier(), "list_attached_objects_on_tags", BatchDefinitions.__listAttachedObjectsOnTagsInput, BatchDefinitions.__listAttachedObjectsOnTagsOutput, BatchApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, BatchDefinitions.__listAttachedObjectsOnTagsInput, BatchApiInterface.this.getTypeConverter());
            List list = (List)structValueExtractor.valueForField("tag_ids");
            BatchApiInterface.this.impl.listAttachedObjectsOnTags(list, (AsyncContext<List<BatchTypes.TagToObjects>>)new AsyncContextImpl(BatchApiInterface.this.getTypeConverter(), BatchDefinitions.__listAttachedObjectsOnTagsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListAttachedObjectsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachedObjectsApiMethod() {
            super(BatchApiInterface.this.getIdentifier(), "list_attached_objects", BatchDefinitions.__listAttachedObjectsInput, BatchDefinitions.__listAttachedObjectsOutput, BatchApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, BatchDefinitions.__listAttachedObjectsInput, BatchApiInterface.this.getTypeConverter());
            List list = (List)structValueExtractor.valueForField("tag_ids");
            BatchApiInterface.this.impl.listAttachedObjects(list, (AsyncContext<List<DynamicID>>)new AsyncContextImpl(BatchApiInterface.this.getTypeConverter(), BatchDefinitions.__listAttachedObjectsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class FindTagsByNameApiMethod
    extends ApiMethodSkeleton {
        public FindTagsByNameApiMethod() {
            super(BatchApiInterface.this.getIdentifier(), "find_tags_by_name", BatchDefinitions.__findTagsByNameInput, BatchDefinitions.__findTagsByNameOutput, BatchApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, BatchDefinitions.__findTagsByNameInput, BatchApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_name");
            BatchApiInterface.this.impl.findTagsByName(string, (AsyncContext<List<String>>)new AsyncContextImpl(BatchApiInterface.this.getTypeConverter(), BatchDefinitions.__findTagsByNameOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class ListTagsForCategoriesApiMethod
    extends ApiMethodSkeleton {
        public ListTagsForCategoriesApiMethod() {
            super(BatchApiInterface.this.getIdentifier(), "list_tags_for_categories", BatchDefinitions.__listTagsForCategoriesInput, BatchDefinitions.__listTagsForCategoriesOutput, BatchApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, BatchDefinitions.__listTagsForCategoriesInput, BatchApiInterface.this.getTypeConverter());
            List list = (List)structValueExtractor.valueForField("category_ids");
            BatchApiInterface.this.impl.listTagsForCategories(list, (AsyncContext<List<String>>)new AsyncContextImpl(BatchApiInterface.this.getTypeConverter(), BatchDefinitions.__listTagsForCategoriesOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetAllTagsApiMethod
    extends ApiMethodSkeleton {
        public GetAllTagsApiMethod() {
            super(BatchApiInterface.this.getIdentifier(), "get_all_tags", BatchDefinitions.__getAllTagsInput, BatchDefinitions.__getAllTagsOutput, BatchApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            new StructValueExtractor(structValue, BatchDefinitions.__getAllTagsInput, BatchApiInterface.this.getTypeConverter());
            BatchApiInterface.this.impl.getAllTags((AsyncContext<List<TagModel>>)new AsyncContextImpl(BatchApiInterface.this.getTypeConverter(), BatchDefinitions.__getAllTagsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetTagsApiMethod
    extends ApiMethodSkeleton {
        public GetTagsApiMethod() {
            super(BatchApiInterface.this.getIdentifier(), "get_tags", BatchDefinitions.__getTagsInput, BatchDefinitions.__getTagsOutput, BatchApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, BatchDefinitions.__getTagsInput, BatchApiInterface.this.getTypeConverter());
            List list = (List)structValueExtractor.valueForField("tag_ids");
            BatchApiInterface.this.impl.getTags(list, (AsyncContext<List<TagModel>>)new AsyncContextImpl(BatchApiInterface.this.getTypeConverter(), BatchDefinitions.__getTagsOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetAllCategoriesApiMethod
    extends ApiMethodSkeleton {
        public GetAllCategoriesApiMethod() {
            super(BatchApiInterface.this.getIdentifier(), "get_all_categories", BatchDefinitions.__getAllCategoriesInput, BatchDefinitions.__getAllCategoriesOutput, BatchApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            new StructValueExtractor(structValue, BatchDefinitions.__getAllCategoriesInput, BatchApiInterface.this.getTypeConverter());
            BatchApiInterface.this.impl.getAllCategories((AsyncContext<List<CategoryModel>>)new AsyncContextImpl(BatchApiInterface.this.getTypeConverter(), BatchDefinitions.__getAllCategoriesOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }

    private class GetCategoriesApiMethod
    extends ApiMethodSkeleton {
        public GetCategoriesApiMethod() {
            super(BatchApiInterface.this.getIdentifier(), "get_categories", BatchDefinitions.__getCategoriesInput, BatchDefinitions.__getCategoriesOutput, BatchApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, BatchDefinitions.__getCategoriesInput, BatchApiInterface.this.getTypeConverter());
            List list = (List)structValueExtractor.valueForField("category_ids");
            BatchApiInterface.this.impl.getCategories(list, (AsyncContext<List<CategoryModel>>)new AsyncContextImpl(BatchApiInterface.this.getTypeConverter(), BatchDefinitions.__getCategoriesOutput, invocationContext, asyncHandle, (ApiMethodSkeleton)this));
        }
    }
}

