/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.tagging;

import com.vmware.cis.tagging.CategoryDefinitions;
import com.vmware.cis.tagging.CategorySyncProvider;
import com.vmware.cis.tagging.CategoryTypes;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class CategorySyncApiInterface
extends ApiInterfaceSkeleton {
    private CategorySyncProvider impl;

    public CategorySyncApiInterface() {
        this((Class<? extends CategorySyncProvider>)null);
    }

    public CategorySyncApiInterface(Class<? extends CategorySyncProvider> clazz) {
        this((CategorySyncProvider)CategorySyncApiInterface.createImplInstance(clazz, (String)"com.vmware.cis.tagging.impl.CategoryImpl", CategorySyncProvider.class));
    }

    public CategorySyncApiInterface(CategorySyncProvider categorySyncProvider) {
        super("com.vmware.cis.tagging.category");
        Validate.notNull((Object)categorySyncProvider);
        this.impl = categorySyncProvider;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new UpdateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new ListUsedCategoriesApiMethod());
        this.registerMethod((ApiMethod)new AddToUsedByApiMethod());
        this.registerMethod((ApiMethod)new RemoveFromUsedByApiMethod());
        this.registerMethod((ApiMethod)new RevokePropagatingPermissionsApiMethod());
    }

    private class RevokePropagatingPermissionsApiMethod
    extends ApiMethodSkeleton {
        public RevokePropagatingPermissionsApiMethod() {
            super(CategorySyncApiInterface.this.getIdentifier(), "revoke_propagating_permissions", CategoryDefinitions.__revokePropagatingPermissionsInput, CategoryDefinitions.__revokePropagatingPermissionsOutput, CategorySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__revokePropagatingPermissionsInput, CategorySyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            try {
                CategorySyncApiInterface.this.impl.revokePropagatingPermissions(string, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class RemoveFromUsedByApiMethod
    extends ApiMethodSkeleton {
        public RemoveFromUsedByApiMethod() {
            super(CategorySyncApiInterface.this.getIdentifier(), "remove_from_used_by", CategoryDefinitions.__removeFromUsedByInput, CategoryDefinitions.__removeFromUsedByOutput, CategorySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__removeFromUsedByInput, CategorySyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            String string2 = (String)structValueExtractor.valueForField("used_by_entity");
            try {
                CategorySyncApiInterface.this.impl.removeFromUsedBy(string, string2, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class AddToUsedByApiMethod
    extends ApiMethodSkeleton {
        public AddToUsedByApiMethod() {
            super(CategorySyncApiInterface.this.getIdentifier(), "add_to_used_by", CategoryDefinitions.__addToUsedByInput, CategoryDefinitions.__addToUsedByOutput, CategorySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__addToUsedByInput, CategorySyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            String string2 = (String)structValueExtractor.valueForField("used_by_entity");
            try {
                CategorySyncApiInterface.this.impl.addToUsedBy(string, string2, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class ListUsedCategoriesApiMethod
    extends ApiMethodSkeleton {
        public ListUsedCategoriesApiMethod() {
            super(CategorySyncApiInterface.this.getIdentifier(), "list_used_categories", CategoryDefinitions.__listUsedCategoriesInput, CategoryDefinitions.__listUsedCategoriesOutput, CategorySyncApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__listUsedCategoriesInput, CategorySyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("used_by_entity");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)CategorySyncApiInterface.this.getTypeConverter().convertToVapi(CategorySyncApiInterface.this.impl.listUsedCategories(string, invocationContext), CategoryDefinitions.__listUsedCategoriesOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(CategorySyncApiInterface.this.getIdentifier(), "list", CategoryDefinitions.__listInput, CategoryDefinitions.__listOutput, CategorySyncApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            new StructValueExtractor(structValue, CategoryDefinitions.__listInput, CategorySyncApiInterface.this.getTypeConverter());
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)CategorySyncApiInterface.this.getTypeConverter().convertToVapi(CategorySyncApiInterface.this.impl.list(invocationContext), CategoryDefinitions.__listOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(CategorySyncApiInterface.this.getIdentifier(), "delete", CategoryDefinitions.__deleteInput, CategoryDefinitions.__deleteOutput, CategorySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__deleteInput, CategorySyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            try {
                CategorySyncApiInterface.this.impl.delete(string, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class UpdateApiMethod
    extends ApiMethodSkeleton {
        public UpdateApiMethod() {
            super(CategorySyncApiInterface.this.getIdentifier(), "update", CategoryDefinitions.__updateInput, CategoryDefinitions.__updateOutput, CategorySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__updateInput, CategorySyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            CategoryTypes.UpdateSpec updateSpec = (CategoryTypes.UpdateSpec)structValueExtractor.valueForField("update_spec");
            try {
                CategorySyncApiInterface.this.impl.update(string, updateSpec, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(CategorySyncApiInterface.this.getIdentifier(), "get", CategoryDefinitions.__getInput, CategoryDefinitions.__getOutput, CategorySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__getInput, CategorySyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("category_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)CategorySyncApiInterface.this.getTypeConverter().convertToVapi((Object)CategorySyncApiInterface.this.impl.get(string, invocationContext), CategoryDefinitions.__getOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(CategorySyncApiInterface.this.getIdentifier(), "create", CategoryDefinitions.__createInput, CategoryDefinitions.__createOutput, CategorySyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, CategoryDefinitions.__createInput, CategorySyncApiInterface.this.getTypeConverter());
            CategoryTypes.CreateSpec createSpec = (CategoryTypes.CreateSpec)structValueExtractor.valueForField("create_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)CategorySyncApiInterface.this.getTypeConverter().convertToVapi((Object)CategorySyncApiInterface.this.impl.create(createSpec, invocationContext), CategoryDefinitions.__createOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }
}

