/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.tagging;

import com.vmware.cis.tagging.TagAssociationDefinitions;
import com.vmware.cis.tagging.TagAssociationSyncProvider;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.DynamicID;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.Validate;

public class TagAssociationSyncApiInterface
extends ApiInterfaceSkeleton {
    private TagAssociationSyncProvider impl;

    public TagAssociationSyncApiInterface() {
        this((Class<? extends TagAssociationSyncProvider>)null);
    }

    public TagAssociationSyncApiInterface(Class<? extends TagAssociationSyncProvider> clazz) {
        this((TagAssociationSyncProvider)TagAssociationSyncApiInterface.createImplInstance(clazz, (String)"com.vmware.cis.tagging.impl.TagAssociationImpl", TagAssociationSyncProvider.class));
    }

    public TagAssociationSyncApiInterface(TagAssociationSyncProvider tagAssociationSyncProvider) {
        super("com.vmware.cis.tagging.tag_association");
        Validate.notNull((Object)tagAssociationSyncProvider);
        this.impl = tagAssociationSyncProvider;
        this.registerMethod((ApiMethod)new AttachApiMethod());
        this.registerMethod((ApiMethod)new AttachMultipleTagsToObjectApiMethod());
        this.registerMethod((ApiMethod)new AttachTagToMultipleObjectsApiMethod());
        this.registerMethod((ApiMethod)new DetachApiMethod());
        this.registerMethod((ApiMethod)new DetachMultipleTagsFromObjectApiMethod());
        this.registerMethod((ApiMethod)new DetachTagFromMultipleObjectsApiMethod());
        this.registerMethod((ApiMethod)new ListAttachedObjectsApiMethod());
        this.registerMethod((ApiMethod)new ListAttachedObjectsOnTagsApiMethod());
        this.registerMethod((ApiMethod)new ListAttachedTagsApiMethod());
        this.registerMethod((ApiMethod)new ListAttachedTagsOnObjectsApiMethod());
        this.registerMethod((ApiMethod)new ListAttachableTagsApiMethod());
    }

    private class ListAttachableTagsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachableTagsApiMethod() {
            super(TagAssociationSyncApiInterface.this.getIdentifier(), "list_attachable_tags", TagAssociationDefinitions.__listAttachableTagsInput, TagAssociationDefinitions.__listAttachableTagsOutput, TagAssociationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__listAttachableTagsInput, TagAssociationSyncApiInterface.this.getTypeConverter());
            DynamicID dynamicID = (DynamicID)structValueExtractor.valueForField("object_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagAssociationSyncApiInterface.this.getTypeConverter().convertToVapi(TagAssociationSyncApiInterface.this.impl.listAttachableTags(dynamicID, invocationContext), TagAssociationDefinitions.__listAttachableTagsOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class ListAttachedTagsOnObjectsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachedTagsOnObjectsApiMethod() {
            super(TagAssociationSyncApiInterface.this.getIdentifier(), "list_attached_tags_on_objects", TagAssociationDefinitions.__listAttachedTagsOnObjectsInput, TagAssociationDefinitions.__listAttachedTagsOnObjectsOutput, TagAssociationSyncApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__listAttachedTagsOnObjectsInput, TagAssociationSyncApiInterface.this.getTypeConverter());
            List list = (List)structValueExtractor.valueForField("object_ids");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagAssociationSyncApiInterface.this.getTypeConverter().convertToVapi(TagAssociationSyncApiInterface.this.impl.listAttachedTagsOnObjects(list, invocationContext), TagAssociationDefinitions.__listAttachedTagsOnObjectsOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class ListAttachedTagsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachedTagsApiMethod() {
            super(TagAssociationSyncApiInterface.this.getIdentifier(), "list_attached_tags", TagAssociationDefinitions.__listAttachedTagsInput, TagAssociationDefinitions.__listAttachedTagsOutput, TagAssociationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__listAttachedTagsInput, TagAssociationSyncApiInterface.this.getTypeConverter());
            DynamicID dynamicID = (DynamicID)structValueExtractor.valueForField("object_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagAssociationSyncApiInterface.this.getTypeConverter().convertToVapi(TagAssociationSyncApiInterface.this.impl.listAttachedTags(dynamicID, invocationContext), TagAssociationDefinitions.__listAttachedTagsOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class ListAttachedObjectsOnTagsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachedObjectsOnTagsApiMethod() {
            super(TagAssociationSyncApiInterface.this.getIdentifier(), "list_attached_objects_on_tags", TagAssociationDefinitions.__listAttachedObjectsOnTagsInput, TagAssociationDefinitions.__listAttachedObjectsOnTagsOutput, TagAssociationSyncApiInterface.this.getTypeConverter(), null);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__listAttachedObjectsOnTagsInput, TagAssociationSyncApiInterface.this.getTypeConverter());
            List list = (List)structValueExtractor.valueForField("tag_ids");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagAssociationSyncApiInterface.this.getTypeConverter().convertToVapi(TagAssociationSyncApiInterface.this.impl.listAttachedObjectsOnTags(list, invocationContext), TagAssociationDefinitions.__listAttachedObjectsOnTagsOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class ListAttachedObjectsApiMethod
    extends ApiMethodSkeleton {
        public ListAttachedObjectsApiMethod() {
            super(TagAssociationSyncApiInterface.this.getIdentifier(), "list_attached_objects", TagAssociationDefinitions.__listAttachedObjectsInput, TagAssociationDefinitions.__listAttachedObjectsOutput, TagAssociationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__listAttachedObjectsInput, TagAssociationSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagAssociationSyncApiInterface.this.getTypeConverter().convertToVapi(TagAssociationSyncApiInterface.this.impl.listAttachedObjects(string, invocationContext), TagAssociationDefinitions.__listAttachedObjectsOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class DetachTagFromMultipleObjectsApiMethod
    extends ApiMethodSkeleton {
        public DetachTagFromMultipleObjectsApiMethod() {
            super(TagAssociationSyncApiInterface.this.getIdentifier(), "detach_tag_from_multiple_objects", TagAssociationDefinitions.__detachTagFromMultipleObjectsInput, TagAssociationDefinitions.__detachTagFromMultipleObjectsOutput, TagAssociationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__detachTagFromMultipleObjectsInput, TagAssociationSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            List list = (List)structValueExtractor.valueForField("object_ids");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagAssociationSyncApiInterface.this.getTypeConverter().convertToVapi((Object)TagAssociationSyncApiInterface.this.impl.detachTagFromMultipleObjects(string, list, invocationContext), TagAssociationDefinitions.__detachTagFromMultipleObjectsOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class DetachMultipleTagsFromObjectApiMethod
    extends ApiMethodSkeleton {
        public DetachMultipleTagsFromObjectApiMethod() {
            super(TagAssociationSyncApiInterface.this.getIdentifier(), "detach_multiple_tags_from_object", TagAssociationDefinitions.__detachMultipleTagsFromObjectInput, TagAssociationDefinitions.__detachMultipleTagsFromObjectOutput, TagAssociationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__detachMultipleTagsFromObjectInput, TagAssociationSyncApiInterface.this.getTypeConverter());
            DynamicID dynamicID = (DynamicID)structValueExtractor.valueForField("object_id");
            List list = (List)structValueExtractor.valueForField("tag_ids");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagAssociationSyncApiInterface.this.getTypeConverter().convertToVapi((Object)TagAssociationSyncApiInterface.this.impl.detachMultipleTagsFromObject(dynamicID, list, invocationContext), TagAssociationDefinitions.__detachMultipleTagsFromObjectOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class DetachApiMethod
    extends ApiMethodSkeleton {
        public DetachApiMethod() {
            super(TagAssociationSyncApiInterface.this.getIdentifier(), "detach", TagAssociationDefinitions.__detachInput, TagAssociationDefinitions.__detachOutput, TagAssociationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__detachInput, TagAssociationSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            DynamicID dynamicID = (DynamicID)structValueExtractor.valueForField("object_id");
            try {
                TagAssociationSyncApiInterface.this.impl.detach(string, dynamicID, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class AttachTagToMultipleObjectsApiMethod
    extends ApiMethodSkeleton {
        public AttachTagToMultipleObjectsApiMethod() {
            super(TagAssociationSyncApiInterface.this.getIdentifier(), "attach_tag_to_multiple_objects", TagAssociationDefinitions.__attachTagToMultipleObjectsInput, TagAssociationDefinitions.__attachTagToMultipleObjectsOutput, TagAssociationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__attachTagToMultipleObjectsInput, TagAssociationSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            List list = (List)structValueExtractor.valueForField("object_ids");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagAssociationSyncApiInterface.this.getTypeConverter().convertToVapi((Object)TagAssociationSyncApiInterface.this.impl.attachTagToMultipleObjects(string, list, invocationContext), TagAssociationDefinitions.__attachTagToMultipleObjectsOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class AttachMultipleTagsToObjectApiMethod
    extends ApiMethodSkeleton {
        public AttachMultipleTagsToObjectApiMethod() {
            super(TagAssociationSyncApiInterface.this.getIdentifier(), "attach_multiple_tags_to_object", TagAssociationDefinitions.__attachMultipleTagsToObjectInput, TagAssociationDefinitions.__attachMultipleTagsToObjectOutput, TagAssociationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__attachMultipleTagsToObjectInput, TagAssociationSyncApiInterface.this.getTypeConverter());
            DynamicID dynamicID = (DynamicID)structValueExtractor.valueForField("object_id");
            List list = (List)structValueExtractor.valueForField("tag_ids");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TagAssociationSyncApiInterface.this.getTypeConverter().convertToVapi((Object)TagAssociationSyncApiInterface.this.impl.attachMultipleTagsToObject(dynamicID, list, invocationContext), TagAssociationDefinitions.__attachMultipleTagsToObjectOutput)));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }

    private class AttachApiMethod
    extends ApiMethodSkeleton {
        public AttachApiMethod() {
            super(TagAssociationSyncApiInterface.this.getIdentifier(), "attach", TagAssociationDefinitions.__attachInput, TagAssociationDefinitions.__attachOutput, TagAssociationSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }));
        }

        public void doInvoke(InvocationContext invocationContext, StructValue structValue, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor structValueExtractor = new StructValueExtractor(structValue, TagAssociationDefinitions.__attachInput, TagAssociationSyncApiInterface.this.getTypeConverter());
            String string = (String)structValueExtractor.valueForField("tag_id");
            DynamicID dynamicID = (DynamicID)structValueExtractor.valueForField("object_id");
            try {
                TagAssociationSyncApiInterface.this.impl.attach(string, dynamicID, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException runtimeException) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(runtimeException)));
            }
        }
    }
}

