/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.util.QueryQualifier;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.adapters.core.CorePropertyConverter;
import com.vmware.vise.data.adapters.core.CoreRequest;
import com.vmware.vise.data.adapters.core.InvalidPropertyNameException;
import com.vmware.vise.data.adapters.core.RequestConverter;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.CoreResourceModelResolver;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.query.FacetSpec;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.search.model.ModelUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkQueryBuilder {
    private static final Logger _logger = LoggerFactory.getLogger(ChunkQueryBuilder.class);
    private final CorePropertyConverter _propertyConverter;
    private final RequestPropertyValidator _propertyValidator;
    private final CoreResourceModelResolver _resourceModelResolver;
    private final String _resourceType;
    private final boolean _isCompositeRequest;
    private final Filter _filter;
    private final Multimap<String, String> _returnByCorePropertyMaping = LinkedHashMultimap.create();
    private final Multimap<String, CoreRequest.RelatedPropertyInfo> _relatedPropertyInfosByCoreRelation = HashMultimap.create();
    private final Multimap<String, CoreRequest.RelatedOrderingInfo> _relatedOrderingInfosByCoreRelation = HashMultimap.create();
    private final Map<String, PropertySpec> _facetByCorePropertyMapping = new HashMap<String, PropertySpec>();
    private final Set<String> _extraPropertiesToReturn = new HashSet<String>();
    private CoreRequest.ChunkOrdering _chunkOrdering = CoreRequest.ChunkOrdering.NONE;
    private List<SortCriterion> _sortClauseProjection = Collections.emptyList();
    private int _offset = 0;
    private int _limit = -1;

    public ChunkQueryBuilder(CorePropertyConverter corePropertyConverter, RequestPropertyValidator requestPropertyValidator, CoreResourceModelResolver coreResourceModelResolver, String string, TranslationResult translationResult, boolean bl) {
        this._propertyConverter = corePropertyConverter;
        this._propertyValidator = requestPropertyValidator;
        this._resourceModelResolver = coreResourceModelResolver;
        this._resourceType = string;
        this._isCompositeRequest = bl;
        this._filter = translationResult.getFilter();
    }

    public ChunkQueryBuilder setReturnClause(PropertySpec[] propertySpecArray) {
        if (ArrayUtils.isEmpty((Object[])propertySpecArray)) {
            return this;
        }
        for (PropertySpec propertySpec : propertySpecArray) {
            this.addReturnPropertyMapping(propertySpec);
        }
        return this;
    }

    public ChunkQueryBuilder setResultSpec(ResultSpec resultSpec) {
        this.setRange(resultSpec);
        this.setOrderingSpec(resultSpec);
        this.setFacetSpec(resultSpec);
        return this;
    }

    public CoreRequest.ChunkQuery create() {
        CoreRequest.ChunkQuery chunkQuery = this._limit == 0 ? this.createQueryForTotalCountOnly() : this.createQueryForItemList();
        return chunkQuery;
    }

    private CoreRequest.ChunkQuery createQueryForTotalCountOnly() {
        assert (this._limit == 0);
        List<String> list = this.getFromClause(Collections.emptyList(), Collections.emptyList(), this._filter, this._resourceType);
        if (list == null) {
            return null;
        }
        Query query = Query.Builder.select((String[])new String[0]).from(list).where(this._filter).orderBy(Collections.emptyList()).offset(0).limit(0).withTotalCount(true).build();
        return new CoreRequest.ChunkQuery(query, (Multimap<String, String>)ImmutableSetMultimap.of(), (Multimap<String, CoreRequest.RelatedPropertyInfo>)ImmutableSetMultimap.of(), Collections.emptyMap(), CoreRequest.ChunkOrdering.NONE, Collections.emptyList(), (Multimap<String, CoreRequest.RelatedOrderingInfo>)ImmutableSetMultimap.of());
    }

    private CoreRequest.ChunkQuery createQueryForItemList() {
        List<SortCriterion> list;
        List<String> list2;
        assert (this._limit != 0);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add("@modelKey");
        linkedHashSet.add("@type");
        List<String> list3 = this._propertyValidator.getSelectableProperties(this._returnByCorePropertyMaping.keySet());
        linkedHashSet.addAll(list3);
        if (!this._relatedPropertyInfosByCoreRelation.isEmpty()) {
            list2 = this._propertyValidator.getSelectableProperties(this._relatedPropertyInfosByCoreRelation.keySet());
            linkedHashSet.addAll(list2);
        }
        list2 = this._propertyValidator.getSelectableProperties(this._facetByCorePropertyMapping.keySet());
        linkedHashSet.addAll(list2);
        linkedHashSet.addAll(this._extraPropertiesToReturn);
        assert (this._chunkOrdering == CoreRequest.ChunkOrdering.NONE || !this._sortClauseProjection.isEmpty());
        switch (this._chunkOrdering) {
            case NONE: 
            case CLIENT_SIDE: {
                list = Collections.emptyList();
                this._offset = 0;
                this._limit = -1;
                break;
            }
            case SORTED: {
                list = this._sortClauseProjection;
                break;
            }
            default: {
                throw new IllegalStateException("BUG: unexpected chunkOrdering = " + (Object)((Object)this._chunkOrdering));
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>(linkedHashSet);
        List<String> list4 = this.getFromClause(arrayList, list, this._filter, this._resourceType);
        if (list4 == null) {
            return null;
        }
        Query query = Query.Builder.select(arrayList).from(list4).where(this._filter).orderBy(list).offset(this._offset).limit(this._limit).withTotalCount(true).build();
        return new CoreRequest.ChunkQuery(query, this._returnByCorePropertyMaping, this._relatedPropertyInfosByCoreRelation, this._facetByCorePropertyMapping, this._chunkOrdering, this._sortClauseProjection, this._relatedOrderingInfosByCoreRelation);
    }

    private void setRange(ResultSpec resultSpec) {
        int n = RequestConverter.toCoreQueryOffset(resultSpec);
        int n2 = RequestConverter.toCoreQueryLimit(resultSpec);
        if (this._isCompositeRequest) {
            this._offset = 0;
            this._limit = n2 > 0 ? n + n2 : n2;
        } else {
            this._offset = n;
            this._limit = n2;
        }
    }

    private void setOrderingSpec(ResultSpec resultSpec) {
        if (resultSpec == null || resultSpec.order == null || ArrayUtils.isEmpty((Object[])resultSpec.order.orderingProperties)) {
            this._chunkOrdering = CoreRequest.ChunkOrdering.NONE;
            return;
        }
        OrderingPropertySpec[] orderingPropertySpecArray = resultSpec.order.orderingProperties;
        ArrayList<SortCriterion> arrayList = new ArrayList<SortCriterion>(orderingPropertySpecArray.length);
        ArrayList<String> arrayList2 = new ArrayList<String>(orderingPropertySpecArray.length);
        OrderingCriteriaInfo orderingCriteriaInfo = this.handleOrderingPropertySpecs(orderingPropertySpecArray, arrayList, arrayList2);
        if (orderingCriteriaInfo.sortsByViseProperties || arrayList.isEmpty() && !orderingCriteriaInfo.sortsByRelatedProperties) {
            this._chunkOrdering = CoreRequest.ChunkOrdering.NONE;
        } else {
            this._sortClauseProjection = arrayList;
            this._extraPropertiesToReturn.addAll(arrayList2);
            this._chunkOrdering = orderingCriteriaInfo.sortsByUnfilterableProperties || orderingCriteriaInfo.sortsByRelatedProperties ? CoreRequest.ChunkOrdering.CLIENT_SIDE : CoreRequest.ChunkOrdering.SORTED;
        }
    }

    private OrderingCriteriaInfo handleOrderingPropertySpecs(OrderingPropertySpec[] orderingPropertySpecArray, List<SortCriterion> list, List<String> list2) {
        OrderingCriteriaInfo orderingCriteriaInfo = new OrderingCriteriaInfo();
        for (OrderingPropertySpec orderingPropertySpec : orderingPropertySpecArray) {
            if (ArrayUtils.isEmpty((Object[])orderingPropertySpec.propertyNames)) continue;
            if (StringUtils.isEmpty((String)orderingPropertySpec.relation)) {
                this.handleOrderingPropertySpec(orderingPropertySpec, orderingCriteriaInfo, list, list2);
            } else {
                this.handleRelatedOrderingPropertySpec(orderingPropertySpec, orderingCriteriaInfo, list, list2);
            }
            if (orderingCriteriaInfo.sortsByViseProperties) break;
        }
        return orderingCriteriaInfo;
    }

    private void handleOrderingPropertySpec(OrderingPropertySpec orderingPropertySpec, OrderingCriteriaInfo orderingCriteriaInfo, List<SortCriterion> list, List<String> list2) {
        SortCriterion.SortDirection sortDirection = this.toCoreSortDirection(orderingPropertySpec.orderingType);
        for (String string : orderingPropertySpec.propertyNames) {
            boolean bl;
            String string2 = this.toCoreSortProperty(orderingPropertySpec.type, string);
            if (string2 != null && this._propertyValidator.canSelectByProperty(string2)) {
                if (this._propertyValidator.canFilterByProperty(string2)) {
                    QuerySchema.PropertyInfo propertyInfo = this._propertyValidator.getPropertyInfo(string2);
                    assert (propertyInfo != null);
                    bl = QuerySchema.PropertyType.STRING.equals((Object)propertyInfo.getType());
                } else {
                    _logger.warn("Ordering on '{}' will be done client-side because the property is not marked as filterable.", (Object)string2);
                    orderingCriteriaInfo.sortsByUnfilterableProperties = true;
                    bl = true;
                }
            } else {
                orderingCriteriaInfo.sortsByViseProperties = true;
                break;
            }
            list.add(new SortCriterion(string2, sortDirection, bl));
            list2.add(string2);
        }
    }

    private void handleRelatedOrderingPropertySpec(OrderingPropertySpec orderingPropertySpec, OrderingCriteriaInfo orderingCriteriaInfo, List<SortCriterion> list, List<String> list2) {
        String[] stringArray = orderingPropertySpec.relation.split(";", 2);
        String string = stringArray[0];
        String string2 = this.toCoreSortProperty(orderingPropertySpec.type, string);
        SortCriterion.SortDirection sortDirection = this.toCoreSortDirection(orderingPropertySpec.orderingType);
        if (string2 != null) {
            orderingCriteriaInfo.sortsByRelatedProperties = true;
            if (this._propertyValidator.canSelectByProperty(string2)) {
                list2.add(string2);
            }
            int n = this._relatedOrderingInfosByCoreRelation.entries().size();
            int n2 = list.size() + n;
            String string3 = "";
            if (stringArray.length == 2) {
                string3 = stringArray[1];
            }
            CoreRequest.RelatedOrderingInfo relatedOrderingInfo = new CoreRequest.RelatedOrderingInfo(string3, n2, sortDirection, orderingPropertySpec.propertyNames);
            this._relatedOrderingInfosByCoreRelation.put((Object)string2, (Object)relatedOrderingInfo);
            _logger.warn("Ordering on '{}' will be done client-side because the property is relation.", (Object)string2);
        } else {
            orderingCriteriaInfo.sortsByViseProperties = true;
        }
    }

    private void setFacetSpec(ResultSpec resultSpec) {
        if (resultSpec == null || ArrayUtils.isEmpty((Object[])resultSpec.facets)) {
            return;
        }
        for (FacetSpec facetSpec : resultSpec.facets) {
            Validate.notNull((Object)facetSpec.propSpec, (String)"Invalid FacetSpec: propSpec is null.");
            Validate.notEmpty((String)facetSpec.propSpec.type, (String)"Invalid FacetSpec.propSpec: type not specified.");
            if (ArrayUtils.getLength((Object)facetSpec.propSpec.propertyNames) != 1) {
                throw new IllegalArgumentException("Invalid FacetSpec.propSpec.propertyNames: must contain exactly one property name");
            }
            PropertySpec propertySpec = facetSpec.propSpec;
            if (StringUtils.isEmpty((String)propertySpec.relation)) {
                this.addDirectPropertyFacetSpec(propertySpec);
                continue;
            }
            this._offset = 0;
            this._limit = -1;
        }
        if (!this._facetByCorePropertyMapping.isEmpty()) {
            this._offset = 0;
            this._limit = -1;
        }
    }

    private void addDirectPropertyFacetSpec(PropertySpec propertySpec) {
        String string;
        assert (StringUtils.isEmpty((String)propertySpec.relation));
        String string2 = propertySpec.type;
        String string3 = propertySpec.propertyNames[0];
        if (this.propertyIsCompatibleWithConstraintType(string2, string3) && (string = this.tryConvertToCoreProperty(this._resourceType, string3)) != null) {
            this._facetByCorePropertyMapping.put(string, propertySpec);
        }
    }

    private void addReturnPropertyMapping(PropertySpec propertySpec) {
        Validate.notNull((Object)propertySpec, (String)"NULL PropertySpec in array.");
        if (ArrayUtils.isEmpty((Object[])propertySpec.propertyNames)) {
            return;
        }
        if (!StringUtils.isEmpty((String)propertySpec.relation)) {
            this.handleRelatedPropertySpec(propertySpec);
            return;
        }
        for (String string : propertySpec.propertyNames) {
            String string2;
            if (StringUtils.isEmpty((String)string) || !this.propertyIsCompatibleWithConstraintType(propertySpec.type, string) || (string2 = this.tryConvertToCoreProperty(this._resourceType, string)) == null) continue;
            this._returnByCorePropertyMaping.put((Object)string2, (Object)string);
        }
    }

    private void handleRelatedPropertySpec(PropertySpec propertySpec) {
        assert (propertySpec != null);
        assert (!StringUtils.isEmpty((String)propertySpec.relation));
        String[] stringArray = propertySpec.relation.split(";", 2);
        String string = stringArray[0];
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        if (!this.propertyIsCompatibleWithConstraintType(propertySpec.type, string)) {
            return;
        }
        String string2 = this.tryConvertToCoreProperty(this._resourceType, string);
        if (string2 == null) {
            return;
        }
        String string3 = "";
        if (stringArray.length == 2) {
            string3 = stringArray[1];
        }
        CoreRequest.RelatedPropertyInfo relatedPropertyInfo = CoreRequest.RelatedPropertyInfo.of(string3, propertySpec.propertyNames);
        this._relatedPropertyInfosByCoreRelation.put((Object)string2, (Object)relatedPropertyInfo);
    }

    private String toCoreSortProperty(String string, String string2) {
        String string3 = CorePropertyConverter.isObjectIdProperty(string, string2) ? "@modelKey" : (this.propertyIsCompatibleWithConstraintType(string, string2) ? this.tryConvertToCoreProperty(this._resourceType, string2) : null);
        return string3;
    }

    private SortCriterion.SortDirection toCoreSortDirection(SortType sortType) {
        if (sortType == null) {
            return SortCriterion.SortDirection.ASCENDING;
        }
        switch (sortType) {
            case ASCENDING: {
                return SortCriterion.SortDirection.ASCENDING;
            }
            case DESCENDING: {
                return SortCriterion.SortDirection.DESCENDING;
            }
        }
        throw new IllegalArgumentException("Unsupported sort type: " + sortType);
    }

    private boolean propertyIsCompatibleWithConstraintType(String string, String string2) {
        boolean bl = ModelUtils.isQualifiedWithResourceModel((String)string2);
        if (bl) {
            if (StringUtils.isEmpty((String)string)) {
                _logger.warn("Qualified property in a PropertySpec without type: " + string2);
                return ModelUtils.isVmodl2Name((String)this._resourceType);
            }
            return this._resourceType == null || string.equals(this._resourceType);
        }
        return true;
    }

    private List<String> getFromClause(List<String> list, List<SortCriterion> list2, Filter filter, String string) {
        List list3 = QueryQualifier.getFromClause(list, (Filter)filter, list2);
        if (list3.isEmpty()) {
            return this.getDefaultFromClause(string);
        }
        return list3;
    }

    private List<String> getDefaultFromClause(String string) {
        if (string == null) {
            throw new UnsupportedOperationException("Query without model names and without type");
        }
        String string2 = this._resourceModelResolver.getDefaultModel(string);
        if (!this._propertyValidator.isModelSupported(string2)) {
            return null;
        }
        return Collections.singletonList(string2);
    }

    private String tryConvertToCoreProperty(String string, String string2) {
        try {
            return this._propertyConverter.toCoreProperty(string, string2);
        }
        catch (InvalidPropertyNameException invalidPropertyNameException) {
            if (_logger.isDebugEnabled()) {
                Object[] objectArray = new Object[]{string, string2.toString(), invalidPropertyNameException};
                _logger.debug("Cannot convert VISE property [type = {}; name = {}] to Core format: {}", objectArray);
            }
            return null;
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    private static final class OrderingCriteriaInfo {
        boolean sortsByViseProperties = false;
        boolean sortsByUnfilterableProperties = false;
        boolean sortsByRelatedProperties = false;

        private OrderingCriteriaInfo() {
        }
    }
}

