/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.util.SchemaUtil;
import com.vmware.cis.data.internal.provider.util.filter.PredicateEvaluator;
import com.vmware.cis.data.internal.provider.util.property.PropertyByName;
import com.vmware.cis.data.internal.provider.util.property.PropertyByNameBackedByResourceItem;
import com.vmware.cis.data.internal.provider.util.property.ResourceItemPropertyByName;
import com.vmware.cis.data.internal.provider.util.property.ResourceItemPropertyValueByNameViaIndexMap;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class ClientSideFilteringConnection
implements CoreQueryService {
    private final CoreQueryService _delegate;
    private final Map<String, QuerySchema.PropertyInfo> _clientSideFilterableProperties;

    public ClientSideFilteringConnection(CoreQueryService coreQueryService, Map<String, QuerySchema.PropertyInfo> map) {
        Validate.notNull((Object)coreQueryService);
        Validate.notNull(map);
        this._delegate = coreQueryService;
        this._clientSideFilterableProperties = Collections.unmodifiableMap(map);
    }

    @Override
    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query);
        if (this.skipQuery(query)) {
            return this._delegate.executeQuery(query);
        }
        List<String> list = this.concatAndDedup(query.getProperties(), this.getClientSideFilterableProperties(query.getFilter()));
        Query query2 = Query.Builder.copyAndSelect((Query)query, list).where(this.getExecutableFilter(query.getFilter())).limit(-1).offset(0).withTotalCount(false).build();
        ResultSet resultSet = this._delegate.executeQuery(query2);
        ResourceItemPropertyValueByNameViaIndexMap resourceItemPropertyValueByNameViaIndexMap = new ResourceItemPropertyValueByNameViaIndexMap(resultSet.getProperties());
        List<ResourceItem> list2 = this.filter(this.getClientSideFilter(query.getFilter()), (ResourceItemPropertyByName)resourceItemPropertyValueByNameViaIndexMap, resultSet.getItems());
        Integer n = query.getWithTotalCount() ? Integer.valueOf(list2.size()) : null;
        List<ResourceItem> list3 = ClientSideFilteringConnection.page(list2, query.getOffset(), query.getLimit());
        List<ResourceItem> list4 = ClientSideFilteringConnection.adaptItems(list3, (ResourceItemPropertyByName)resourceItemPropertyValueByNameViaIndexMap, query.getProperties());
        return new ResultSet(query.getProperties(), list4, n);
    }

    private boolean skipQuery(Query query) {
        assert (query != null);
        if (query.getFilter() == null) {
            return true;
        }
        for (PropertyPredicate propertyPredicate : query.getFilter().getCriteria()) {
            if (!this._clientSideFilterableProperties.containsKey(propertyPredicate.getProperty())) continue;
            return false;
        }
        return true;
    }

    private Filter getExecutableFilter(Filter filter) {
        assert (filter != null);
        if (this.isDisjunction(filter)) {
            return null;
        }
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>(filter.getCriteria().size());
        for (PropertyPredicate propertyPredicate : filter.getCriteria()) {
            String string = propertyPredicate.getProperty();
            if (this._clientSideFilterableProperties.containsKey(string)) continue;
            arrayList.add(propertyPredicate);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new Filter(arrayList, filter.getOperator());
    }

    private Filter getClientSideFilter(Filter filter) {
        assert (filter != null);
        if (this.isDisjunction(filter)) {
            return filter;
        }
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>(filter.getCriteria().size());
        for (PropertyPredicate propertyPredicate : filter.getCriteria()) {
            String string = propertyPredicate.getProperty();
            if (!this._clientSideFilterableProperties.containsKey(string)) continue;
            arrayList.add(propertyPredicate);
        }
        assert (!arrayList.isEmpty());
        return new Filter(arrayList, filter.getOperator());
    }

    private List<String> getClientSideFilterableProperties(Filter filter) {
        assert (filter != null);
        boolean bl = this.isDisjunction(filter);
        ArrayList<String> arrayList = new ArrayList<String>(filter.getCriteria().size());
        for (PropertyPredicate propertyPredicate : filter.getCriteria()) {
            String string = propertyPredicate.getProperty();
            if (!bl && !this._clientSideFilterableProperties.containsKey(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private boolean isDisjunction(Filter filter) {
        assert (filter != null);
        return filter.getCriteria().size() > 1 && LogicalOperator.OR.equals((Object)filter.getOperator());
    }

    private List<String> concatAndDedup(List<String> list, List<String> list2) {
        assert (list != null);
        assert (list2 != null);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(list.size() + list2.size());
        linkedHashSet.addAll(list);
        linkedHashSet.addAll(list2);
        return new ArrayList<String>(linkedHashSet);
    }

    private List<ResourceItem> filter(Filter filter, ResourceItemPropertyByName resourceItemPropertyByName, List<ResourceItem> list) {
        assert (filter != null);
        assert (resourceItemPropertyByName != null);
        assert (list != null);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>(list.size());
        for (ResourceItem resourceItem : list) {
            PropertyByNameBackedByResourceItem propertyByNameBackedByResourceItem = new PropertyByNameBackedByResourceItem(resourceItem, resourceItemPropertyByName);
            if (!ClientSideFilteringConnection.evalFilter(filter, (PropertyByName)propertyByNameBackedByResourceItem)) continue;
            arrayList.add(resourceItem);
        }
        return arrayList;
    }

    private static boolean evalFilter(Filter filter, PropertyByName propertyByName) {
        assert (filter != null);
        assert (propertyByName != null);
        switch (filter.getOperator()) {
            case AND: {
                return ClientSideFilteringConnection.evalConjunction(filter.getCriteria(), propertyByName);
            }
            case OR: {
                return ClientSideFilteringConnection.evalDisjunction(filter.getCriteria(), propertyByName);
            }
        }
        throw new IllegalStateException("Unsupported logical operator " + filter.getOperator());
    }

    private static boolean evalConjunction(List<PropertyPredicate> list, PropertyByName propertyByName) {
        assert (list != null);
        assert (propertyByName != null);
        for (PropertyPredicate propertyPredicate : list) {
            if (ClientSideFilteringConnection.evalPredicate(propertyPredicate, propertyByName)) continue;
            return false;
        }
        return true;
    }

    private static boolean evalDisjunction(List<PropertyPredicate> list, PropertyByName propertyByName) {
        assert (list != null);
        assert (propertyByName != null);
        for (PropertyPredicate propertyPredicate : list) {
            if (!ClientSideFilteringConnection.evalPredicate(propertyPredicate, propertyByName)) continue;
            return true;
        }
        return false;
    }

    private static boolean evalPredicate(PropertyPredicate propertyPredicate, PropertyByName propertyByName) {
        assert (propertyPredicate != null);
        assert (propertyByName != null);
        String string = propertyPredicate.getProperty();
        Object object = propertyByName.getValue(string);
        for (Object obj : ClientSideFilteringConnection.asCollection(object)) {
            if (!PredicateEvaluator.eval((PropertyPredicate)propertyPredicate, obj)) continue;
            return true;
        }
        return false;
    }

    private static Collection<?> asCollection(Object object) {
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object);
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        return Collections.singletonList(object);
    }

    private static <T> List<T> page(List<T> list, int n, int n2) {
        assert (list != null);
        assert (n >= 0);
        if (list.isEmpty()) {
            return list;
        }
        if (n2 < 0) {
            return list;
        }
        if (n2 == 0 || n >= list.size()) {
            return Collections.emptyList();
        }
        if (n + n2 >= list.size()) {
            return list.subList(n, list.size());
        }
        return list.subList(n, n + n2);
    }

    private static List<ResourceItem> adaptItems(List<ResourceItem> list, ResourceItemPropertyByName resourceItemPropertyByName, List<String> list2) {
        assert (list != null);
        assert (resourceItemPropertyByName != null);
        assert (list2 != null);
        ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>(list.size());
        for (ResourceItem resourceItem : list) {
            PropertyByNameBackedByResourceItem propertyByNameBackedByResourceItem = new PropertyByNameBackedByResourceItem(resourceItem, resourceItemPropertyByName);
            arrayList.add(ClientSideFilteringConnection.adaptItem((PropertyByName)propertyByNameBackedByResourceItem, list2));
        }
        return arrayList;
    }

    private static ResourceItem adaptItem(PropertyByName propertyByName, List<String> list) {
        assert (propertyByName != null);
        assert (list != null);
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (String string : list) {
            arrayList.add(propertyByName.getValue(string));
        }
        return new ResourceItem(arrayList);
    }

    @Override
    public QuerySchema getSchema() {
        QuerySchema querySchema = this._delegate.getSchema();
        QuerySchema querySchema2 = QuerySchema.forProperties(this._clientSideFilterableProperties);
        return SchemaUtil.merge((QuerySchema)querySchema, (QuerySchema)querySchema2);
    }
}

