/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.federation.VersionAnalyzer;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiProtocolConnectionFactory;
import com.vmware.cis.data.internal.adapters.vmomi.impl.HttpConfigurationFactory;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.cis.data.provider.registry.DataProviderLookup;
import com.vmware.cis.data.provider.registry.QueryModelLookup;
import com.vmware.cis.data.provider.registry.VcenterDataProviderFactoryLookup;
import com.vmware.vise.data.adapters.core.ClientSideFilteringConnection;
import com.vmware.vise.data.adapters.core.ComponentManagerServiceLocator;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.DataServiceMode;
import com.vmware.vise.data.adapters.core.DataServiceRiseModeAdapter;
import com.vmware.vise.data.adapters.core.ObjectPropertyRequestReducerDecorator;
import com.vmware.vise.data.adapters.core.QueryServiceConnection;
import com.vmware.vise.data.adapters.core.QueryServiceConnectionFactory;
import com.vmware.vise.data.adapters.core.alien.AlienVcAwareQueryService;
import com.vmware.vise.data.adapters.core.mixfed.DataServiceMixedFederationAdapter;
import com.vmware.vise.data.adapters.core.tagging.InventoryServiceTaggingQueryModel;
import com.vmware.vise.data.adapters.core.translator.cornercase.AllowMultipleModelKeyPredicates;
import com.vmware.vise.data.adapters.core.translator.cornercase.WebClientDerivedProperties;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vapi.ResourceModelTypeProvider;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.data.adapters.common.DataAdapterConfiguration;
import com.vmware.vise.vim.data.adapters.common.SearchMetadataQueryCriteria;
import com.vmware.vise.vim.security.sso.SsoService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataServiceCoreAdapter
implements DynamicProviderAdapter,
UserSessionListener {
    private static final Logger _logger = LoggerFactory.getLogger(DataServiceCoreAdapter.class);
    private static final String SESSION_KEY_DS2_CONTEXT = "SESSION_KEY_DS2_CONTEXT";
    private final ConfigurationService _configurationService;
    private final FeatureStateService _featureStateService;
    private final DynamicProviderAdapter _isa;
    private final SsoService _ssoService;
    private final ExecutorService _executor;
    private final SearchMetadataQueryCriteria _searchMetadataQueryCriteria;
    private final DataAdapterConfiguration _dataAdapterConfiguration;
    private final ResourceModelTypeProvider _vapiTypeProvider;
    private final HttpConfigurationFactory _vlsiHttpConfigFactory;
    private final VapiProtocolConnectionFactory _vapiConnectionFactory;
    private final DataProviderLookup _clientProviders;
    private final VcenterDataProviderFactoryLookup _vcenterDataProviderFactoryLookup;
    private final QueryModelLookup _queryModelLookup;
    private final KeystoreService _keystoreService;
    private final ComponentManagerService _componentManagerService;
    private final AtomicBoolean _schemaDumped = new AtomicBoolean(false);

    public DataServiceCoreAdapter(DynamicProviderAdapter dynamicProviderAdapter, ConfigurationService configurationService, FeatureStateService featureStateService, SsoService ssoService, ExecutorService executorService, SearchMetadataQueryCriteria searchMetadataQueryCriteria, DataAdapterConfiguration dataAdapterConfiguration, ResourceModelTypeProvider resourceModelTypeProvider, HttpConfigurationFactory httpConfigurationFactory, VapiProtocolConnectionFactory vapiProtocolConnectionFactory, DataProviderLookup dataProviderLookup, VcenterDataProviderFactoryLookup vcenterDataProviderFactoryLookup, QueryModelLookup queryModelLookup, KeystoreService keystoreService, ComponentManagerService componentManagerService) {
        Validate.notNull((Object)dynamicProviderAdapter, (String)"isa");
        Validate.notNull((Object)configurationService, (String)"configurationService");
        Validate.notNull((Object)featureStateService, (String)"featureStateService");
        Validate.notNull((Object)ssoService, (String)"ssoService");
        Validate.notNull((Object)executorService, (String)"executor");
        Validate.notNull((Object)searchMetadataQueryCriteria, (String)"searchMetadataQueryCriteria");
        Validate.notNull((Object)dataAdapterConfiguration, (String)"dataAdapterConfiguration");
        Validate.notNull((Object)resourceModelTypeProvider, (String)"vapiTypeProvider");
        Validate.notNull((Object)httpConfigurationFactory, (String)"vlsiHttpConfigFactory");
        Validate.notNull((Object)vapiProtocolConnectionFactory, (String)"vapiConnectionFactory");
        Validate.notNull((Object)dataProviderLookup, (String)"clientProviders");
        Validate.notNull((Object)vcenterDataProviderFactoryLookup, (String)"vcenterDataProviderFactoryLookup");
        Validate.notNull((Object)queryModelLookup, (String)"queryModelLookup");
        Validate.notNull((Object)keystoreService, (String)"keystoreService");
        Validate.notNull((Object)componentManagerService, (String)"componentManagerService");
        this._isa = dynamicProviderAdapter;
        this._configurationService = configurationService;
        this._featureStateService = featureStateService;
        this._ssoService = ssoService;
        this._executor = executorService;
        this._searchMetadataQueryCriteria = searchMetadataQueryCriteria;
        this._dataAdapterConfiguration = dataAdapterConfiguration;
        this._vapiTypeProvider = resourceModelTypeProvider;
        this._vlsiHttpConfigFactory = httpConfigurationFactory;
        this._vapiConnectionFactory = vapiProtocolConnectionFactory;
        this._clientProviders = dataProviderLookup;
        this._queryModelLookup = queryModelLookup;
        this._vcenterDataProviderFactoryLookup = vcenterDataProviderFactoryLookup;
        this._keystoreService = keystoreService;
        this._componentManagerService = componentManagerService;
    }

    public Response getData(RequestSpec requestSpec) throws Exception {
        Validate.notNull((Object)requestSpec);
        DynamicProviderAdapter dynamicProviderAdapter = this.getAdapterForCurrentSession();
        return dynamicProviderAdapter.getData(requestSpec);
    }

    private DynamicProviderAdapter getAdapterForCurrentSession() {
        DataServiceMode dataServiceMode = DataServiceMode.getCurrentMode(this._featureStateService);
        if (DataServiceMode.IS == dataServiceMode) {
            return this._isa;
        }
        HttpSession httpSession = SessionUtil.getHttpSession();
        final String string = SessionUtil.getClientId((HttpSession)httpSession);
        this.requireTokenInSession(string);
        Supplier supplier = Suppliers.memoize((Supplier)new Supplier<DataServiceSessionContext>(){

            public DataServiceSessionContext get() {
                DataServiceSessionContext dataServiceSessionContext;
                _logger.info("Creating new DS Core session for clientId: {}", (Object)SessionUtil.getHashedClientId((String)string));
                try {
                    dataServiceSessionContext = DataServiceCoreAdapter.this.newDsSessionContextFor(string);
                }
                catch (Exception exception) {
                    _logger.error("Could not initialize DS Core session for clientId: {}", (Object)SessionUtil.getHashedClientId((String)string), (Object)exception);
                    throw exception;
                }
                return dataServiceSessionContext;
            }
        });
        Supplier supplier2 = (Supplier)SessionUtil.setDataIfAbsent((String)SESSION_KEY_DS2_CONTEXT, (Object)supplier, (String)string);
        if (supplier2 != null) {
            supplier = supplier2;
        }
        return ((DataServiceSessionContext)supplier.get()).adapter;
    }

    private DataServiceSessionContext newDsSessionContextFor(final String string) {
        DataServiceCoreAdapter.cancelIfInterrupted();
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistryByClientId((String)string);
        List<LinkedVcGroup> list = Arrays.asList(linkedVcGroupRegistry.getLinkedVcGroups());
        if (DataServiceCoreAdapter.onlyInvSvcNodes(list)) {
            _logger.info("Will not wire RISE data provider infrastructure because there are only nodes with InventoryService.");
            return new DataServiceSessionContext(this._isa);
        }
        QueryServiceConnection queryServiceConnection = this.connectToDsCore(new ComponentManagerServiceLocator(this._keystoreService, this._componentManagerService, list), string);
        AlienVcAwareQueryService alienVcAwareQueryService = AlienVcAwareQueryService.withAlienVcSupport(new AlienVcAwareQueryService.QueryServiceConnectionPolicy(){

            @Override
            public QueryServiceConnection getConnection(ServiceLocator serviceLocator, AuthenticationTokenSource authenticationTokenSource) {
                return DataServiceCoreAdapter.this.connectToDsCore(serviceLocator, string);
            }
        }, queryServiceConnection, string);
        CoreQueryService coreQueryService = this.extendWithViseTranslation(alienVcAwareQueryService);
        QuerySchema querySchema = coreQueryService.getSchema();
        if (_logger.isDebugEnabled() && this._schemaDumped.compareAndSet(false, true)) {
            _logger.debug("Effective schema of all registered DataProviders: {}", (Object)querySchema);
        }
        ObjectPropertyRequestReducerDecorator objectPropertyRequestReducerDecorator = new ObjectPropertyRequestReducerDecorator(DataServiceMixedFederationAdapter.federateWithLegacyNodes(this._isa, new DataServiceRiseModeAdapter(coreQueryService, querySchema, this._executor), this._executor, this._searchMetadataQueryCriteria.getMetadataDirectory(), string));
        _logger.info("Successfully created new DS Core session for clientId: {}", (Object)SessionUtil.getHashedClientId((String)string));
        return new DataServiceSessionContext(objectPropertyRequestReducerDecorator, alienVcAwareQueryService);
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        if (httpSessionEvent == null) {
            return;
        }
        HttpSession httpSession = httpSessionEvent.getSession();
        if (httpSession == null) {
            return;
        }
        Supplier supplier = (Supplier)SessionUtil.removeData((String)SESSION_KEY_DS2_CONTEXT, (HttpSession)httpSession);
        if (supplier == null) {
            return;
        }
        AutoCloseable autoCloseable = ((DataServiceSessionContext)supplier.get()).connection;
        if (autoCloseable != null) {
            _logger.info("Closing DS session for HttpSession 0x{} clientId: {}", (Object)Integer.toHexString(System.identityHashCode(httpSession)), (Object)SessionUtil.getHashedClientId((HttpSession)httpSession));
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                _logger.warn("Error while closing data provider session", (Throwable)exception);
            }
        }
    }

    private QueryServiceConnection connectToDsCore(ServiceLocator serviceLocator, String string) {
        QueryServiceConnection queryServiceConnection = QueryServiceConnectionFactory.getConnection(serviceLocator, this._executor, this._vapiTypeProvider, this._vlsiHttpConfigFactory, this._vapiConnectionFactory, this._clientProviders, this._vcenterDataProviderFactoryLookup, this._queryModelLookup, this._ssoService, this.checkUseOfUnstableVmodl(), string, this._dataAdapterConfiguration.getRiseAdapterThreshold());
        return queryServiceConnection;
    }

    private CoreQueryService extendWithViseTranslation(CoreQueryService coreQueryService) {
        ClientSideFilteringConnection clientSideFilteringConnection = new ClientSideFilteringConnection(InventoryServiceTaggingQueryModel.withInvSvcTagging(coreQueryService), InventoryServiceTaggingQueryModel.getClientSideFilterableProperties());
        AllowMultipleModelKeyPredicates allowMultipleModelKeyPredicates = new AllowMultipleModelKeyPredicates(clientSideFilteringConnection);
        final CoreQueryService coreQueryService2 = WebClientDerivedProperties.withWebClientDerivedProperties(allowMultipleModelKeyPredicates);
        CoreQueryService coreQueryService3 = new CoreQueryService(){

            @Override
            public QuerySchema getSchema() {
                DataServiceCoreAdapter.cancelIfInterrupted();
                return coreQueryService2.getSchema();
            }

            @Override
            public ResultSet executeQuery(Query query) {
                DataServiceCoreAdapter.cancelIfInterrupted();
                return coreQueryService2.executeQuery(query);
            }
        };
        return coreQueryService3;
    }

    private boolean checkUseOfUnstableVmodl() {
        String string = this._configurationService.getProperty("use.unstable.vmodl");
        Boolean bl = BooleanUtils.toBooleanObject((String)string);
        return bl != null ? bl : false;
    }

    private void requireTokenInSession(String string) {
        if (string == null) {
            throw new IllegalStateException("Data Service invoked a HttpSession without clientId, but a clientId is required.");
        }
        if (AuthSessionUtil.getSsoToken((String)string) == null) {
            throw new IllegalStateException("Data Service invoked in a user's session lacking authentication token, but a token is required.");
        }
    }

    private static void cancelIfInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException(String.format("Call to %s was cancelled.", DataServiceCoreAdapter.class.getSimpleName()));
        }
    }

    private static boolean onlyInvSvcNodes(Collection<LinkedVcGroup> collection) {
        assert (collection != null);
        for (LinkedVcGroup linkedVcGroup : collection) {
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                if (DataServiceCoreAdapter.hasInvSvc(vcService)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean hasInvSvc(VcService vcService) {
        if (vcService == null) {
            return false;
        }
        return VersionAnalyzer.isVersionBeforeRise((String)vcService.getServiceVersion());
    }

    private static final class DataServiceSessionContext {
        final DynamicProviderAdapter adapter;
        final AutoCloseable connection;

        DataServiceSessionContext(DynamicProviderAdapter dynamicProviderAdapter) {
            this(dynamicProviderAdapter, null);
        }

        DataServiceSessionContext(DynamicProviderAdapter dynamicProviderAdapter, AutoCloseable autoCloseable) {
            assert (dynamicProviderAdapter != null);
            this.adapter = dynamicProviderAdapter;
            this.connection = autoCloseable;
        }
    }
}

