/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.UnmodifiableIterator;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.merge.DefaultItemComparator;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.vise.data.adapters.core.CoreRequest;
import com.vmware.vise.data.adapters.core.CoreResponse;
import com.vmware.vise.data.adapters.core.ReferenceConverter;
import com.vmware.vise.data.adapters.core.ResultChunkIteration;
import com.vmware.vise.data.adapters.core.translator.cornercase.NamePropertyValueConverter;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.FacetInfo;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseConverter {
    private static final Logger logger = LoggerFactory.getLogger(ResponseConverter.class);

    public DynamicProviderResultSet toViseResponse(String string, CoreResponse coreResponse, List<FacetInfo> list, Exception exception) {
        boolean bl;
        Iterator<ResultChunkIteration.ResultChunkItem> iterator;
        Object object;
        Object object2;
        logger.debug("ResponseConverter.toViseResponse for query `{}' : {}", (Object)string, (Object)coreResponse);
        CoreRequest.ChunkOrdering chunkOrdering = this.determineCombinedOrdering(coreResponse);
        int n = 0;
        ArrayList<Iterator<ResultChunkIteration.ResultChunkItem>> arrayList = new ArrayList<Iterator<ResultChunkIteration.ResultChunkItem>>();
        for (CoreResponse.ResultChunk resultChunk : coreResponse.getResultChunks()) {
            object2 = resultChunk.getCoreResult();
            n += ResponseConverter.getTotalCount(object2);
            if (object2.getItems().size() <= 0 || coreResponse.getLimit() == 0) continue;
            object = resultChunk.getChunkOrdering() == CoreRequest.ChunkOrdering.CLIENT_SIDE && chunkOrdering != CoreRequest.ChunkOrdering.NONE ? this.sortAtClientSide(resultChunk) : resultChunk;
            arrayList.add(new ResultChunkIteration.ResultChunkIterator((CoreResponse.ResultChunk)object));
        }
        if (chunkOrdering == CoreRequest.ChunkOrdering.NONE) {
            iterator = Iterators.concat(arrayList.iterator());
            bl = false;
        } else {
            iterator = this.mergeAndApplyPaging(coreResponse, arrayList);
            bl = true;
        }
        object2 = Iterators.transform(iterator, (Function)new Function<ResultChunkIteration.ResultChunkItem, ResultItem>(){

            public ResultItem apply(ResultChunkIteration.ResultChunkItem resultChunkItem) {
                return ResponseConverter.this.toViseResultItem(resultChunkItem);
            }
        });
        object = this.createViseResult(string);
        object.totalMatchedObjectCount = n;
        object.items = (ResultItem[])Iterators.toArray((Iterator)object2, ResultItem.class);
        object.facets = list.toArray(new FacetInfo[list.size()]);
        object.paged = bl;
        object.sorted = bl;
        object.error = exception;
        return object;
    }

    private CoreRequest.ChunkOrdering determineCombinedOrdering(CoreResponse coreResponse) {
        boolean bl = false;
        boolean bl2 = false;
        block5: for (CoreResponse.ResultChunk resultChunk : coreResponse.getResultChunks()) {
            CoreRequest.ChunkOrdering chunkOrdering = resultChunk.getChunkOrdering();
            switch (chunkOrdering) {
                case NONE: {
                    bl = true;
                    continue block5;
                }
                case CLIENT_SIDE: {
                    bl2 = true;
                    continue block5;
                }
                case SORTED: {
                    continue block5;
                }
            }
            throw new IllegalStateException("BUG: unexpectdd chunkOrdering = " + (Object)((Object)chunkOrdering));
        }
        Object object = bl ? CoreRequest.ChunkOrdering.NONE : (bl2 ? CoreRequest.ChunkOrdering.CLIENT_SIDE : CoreRequest.ChunkOrdering.SORTED);
        return object;
    }

    private CoreResponse.ResultChunk sortAtClientSide(CoreResponse.ResultChunk resultChunk) {
        ResultSet resultSet = resultChunk.getCoreResult();
        ResultSet resultSet2 = this.sortAtClientSide(resultSet, resultChunk.getSortClauseProjection());
        return new CoreResponse.ResultChunk(resultSet2, resultChunk.getReturnByCoreNameMapping(), resultChunk.getRelatedValuesByItemKey(), CoreRequest.ChunkOrdering.SORTED, resultChunk.getSortClauseProjection());
    }

    private ResultSet sortAtClientSide(ResultSet resultSet, List<SortCriterion> list) {
        assert (!list.isEmpty());
        DefaultItemComparator defaultItemComparator = new DefaultItemComparator(resultSet.getProperties(), list);
        List list2 = Ordering.from((Comparator)defaultItemComparator).sortedCopy((Iterable)resultSet.getItems());
        return new ResultSet(resultSet.getProperties(), list2, resultSet.getTotalCount());
    }

    private Iterator<ResultChunkIteration.ResultChunkItem> mergeAndApplyPaging(CoreResponse coreResponse, List<Iterator<ResultChunkIteration.ResultChunkItem>> list) {
        Iterator iterator;
        UnmodifiableIterator unmodifiableIterator;
        if (list.size() == 1) {
            unmodifiableIterator = list.get(0);
        } else {
            iterator = new ResultChunkIteration.ResultChunkItemComparator();
            unmodifiableIterator = Iterators.mergeSorted(list, (Comparator)((Object)iterator));
        }
        Iterators.advance((Iterator)unmodifiableIterator, (int)coreResponse.getOffset());
        iterator = coreResponse.getLimit() > 0 ? Iterators.limit((Iterator)unmodifiableIterator, (int)coreResponse.getLimit()) : unmodifiableIterator;
        return iterator;
    }

    private static int getTotalCount(ResultSet resultSet) {
        return resultSet.getTotalCount() != null ? resultSet.getTotalCount().intValue() : resultSet.getItems().size();
    }

    public DynamicProviderResultSet toViseResponse(String string, RuntimeException runtimeException) {
        DynamicProviderResultSet dynamicProviderResultSet = this.createViseResult(string);
        dynamicProviderResultSet.error = runtimeException;
        return dynamicProviderResultSet;
    }

    private DynamicProviderResultSet createViseResult(String string) {
        DynamicProviderResultSet dynamicProviderResultSet = new DynamicProviderResultSet();
        dynamicProviderResultSet.queryName = string;
        return dynamicProviderResultSet;
    }

    private ResultItem toViseResultItem(ResultChunkIteration.ResultChunkItem resultChunkItem) {
        return this.toViseResultItem(resultChunkItem.getResourceItem(), resultChunkItem.getItemType(), resultChunkItem.getSourceChunk().getCoreResult(), resultChunkItem.getSourceChunk().getReturnByCoreNameMapping(), resultChunkItem.getSourceChunk().getRelatedValuesByItemKey());
    }

    private ResultItem toViseResultItem(ResourceItem resourceItem, String string, ResultSet resultSet, Multimap<String, String> multimap, Multimap<Object, PropertyValue> multimap2) {
        Validate.notNull((Object)resourceItem);
        List list = resultSet.getProperties();
        ResultItem resultItem = new ResultItem();
        Object object = resultSet.getModelKey(resourceItem);
        Object object2 = ReferenceConverter.toViseResourceReference(object, string);
        Collection collection = multimap2.get(object);
        resultItem.properties = this.toVisePropertyValues(multimap, object2, resourceItem.getPropertyValues(), list, collection);
        resultItem.resourceObject = object2;
        return resultItem;
    }

    private PropertyValue[] toVisePropertyValues(Multimap<String, String> multimap, Object object, List<Object> list, List<String> list2, Collection<PropertyValue> collection) {
        if (list == null) {
            return new PropertyValue[0];
        }
        if (list2 == null || list2.size() != list.size()) {
            throw new IllegalStateException("The list with requested properties is not with the same size as the result properties list!");
        }
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string = list2.get(i);
            if (PropertyUtil.isModelKey((String)string)) continue;
            Object object2 = list.get(i);
            Collection collection2 = multimap.get((Object)string);
            if (collection2 == null || collection2.isEmpty() || ResponseConverter.shouldOmitPropertyValue(string, object2)) continue;
            for (String string2 : collection2) {
                object2 = NamePropertyValueConverter.unescapeSpecialCharacters(string, object2);
                PropertyValue propertyValue = ResponseConverter.toVisePropertyValue(object, object2, string2);
                arrayList.add(propertyValue);
            }
        }
        arrayList.addAll(collection);
        return arrayList.toArray(new PropertyValue[arrayList.size()]);
    }

    private static boolean shouldOmitPropertyValue(String string, Object object) {
        return object == null || ResponseConverter.isEmptyVmodl1Array(string, object);
    }

    private static boolean isEmptyVmodl1Array(String string, Object object) {
        assert (object != null);
        if (!string.contains(".")) {
            return object.getClass().isArray() && ArrayUtils.getLength((Object)object) == 0;
        }
        return false;
    }

    private static PropertyValue toVisePropertyValue(Object object, Object object2, String string) {
        Validate.notEmpty((String)string);
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.resourceObject = object;
        propertyValue.propertyName = string;
        propertyValue.value = object2;
        return propertyValue;
    }
}

