/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.vise.data.adapters.core.CoreResponse;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

final class ResultChunkIteration {
    private static final int COLUMN_NOT_PROJECTED = -1;

    ResultChunkIteration() {
    }

    private static int[] getSortColumnProjections(CoreResponse.ResultChunk resultChunk) {
        List<SortCriterion> list = resultChunk.getSortClauseProjection();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i).getProperty();
            nArray[i] = resultChunk.getCoreResult().getProperties().indexOf(string);
        }
        return nArray;
    }

    private static List<SortCriterion.SortDirection> getSortDirections(List<SortCriterion> list) {
        ArrayList<SortCriterion.SortDirection> arrayList = new ArrayList<SortCriterion.SortDirection>(list.size());
        for (SortCriterion sortCriterion : list) {
            arrayList.add(sortCriterion.getSortDirection());
        }
        return arrayList;
    }

    private static int getTypeIndex(List<String> list) {
        int n = list.indexOf("@type");
        if (n < 0) {
            throw new IllegalStateException("Failed to find @type in the properties.");
        }
        return n;
    }

    public static final class ResultChunkIterator
    implements Iterator<ResultChunkItem> {
        private final CoreResponse.ResultChunk sourceChunk;
        private int position;
        private final int typePropertyIndex;
        private final List<SortCriterion.SortDirection> sortDirections;
        private final int[] sortColumns;

        public ResultChunkIterator(CoreResponse.ResultChunk resultChunk) {
            this.sourceChunk = resultChunk;
            this.position = -1;
            this.typePropertyIndex = ResultChunkIteration.getTypeIndex(resultChunk.getCoreResult().getProperties());
            this.sortDirections = ResultChunkIteration.getSortDirections(resultChunk.getSortClauseProjection());
            this.sortColumns = ResultChunkIteration.getSortColumnProjections(resultChunk);
        }

        @Override
        public boolean hasNext() {
            return this.position < this.sourceChunk.getCoreResult().getItems().size() - 1;
        }

        @Override
        public ResultChunkItem next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Internal error: iterator moving past sequence's end.");
            }
            ++this.position;
            ResourceItem resourceItem = (ResourceItem)this.sourceChunk.getCoreResult().getItems().get(this.position);
            ResultChunkItem resultChunkItem = new ResultChunkItem(this.sourceChunk, resourceItem, this.typePropertyIndex, this.sortDirections, this.sortColumns);
            return resultChunkItem;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName() + ".remove()");
        }
    }

    public static final class ResultChunkItemComparator
    implements Comparator<ResultChunkItem> {
        @Override
        public int compare(ResultChunkItem resultChunkItem, ResultChunkItem resultChunkItem2) {
            if (resultChunkItem == null && resultChunkItem2 == null) {
                return 0;
            }
            if (resultChunkItem == null) {
                return 1;
            }
            if (resultChunkItem2 == null) {
                return -1;
            }
            assert (resultChunkItem.sortDirections.size() == resultChunkItem2.sortDirections.size());
            for (int i = 0; i < resultChunkItem.sortDirections.size(); ++i) {
                Object object;
                SortCriterion.SortDirection sortDirection = (SortCriterion.SortDirection)resultChunkItem.sortDirections.get(i);
                Object object2 = ResultChunkItemComparator.getSortTupleElement(resultChunkItem, i);
                int n = this.compareSortTupleElements(object2, object = ResultChunkItemComparator.getSortTupleElement(resultChunkItem2, i));
                if (n == 0) continue;
                n = sortDirection == SortCriterion.SortDirection.ASCENDING ? n : -n;
                return n;
            }
            return 0;
        }

        private static Object getSortTupleElement(ResultChunkItem resultChunkItem, int n) {
            ResourceItem resourceItem = resultChunkItem.getResourceItem();
            int n2 = resultChunkItem.sortColumns[n];
            if (n2 == -1) {
                return null;
            }
            return resourceItem.getPropertyValues().get(n2);
        }

        private int compareSortTupleElements(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return 1;
            }
            if (object2 == null) {
                return -1;
            }
            if (object instanceof String) {
                return this.textuallyCompare(object, object2);
            }
            if (object instanceof Comparable) {
                Comparable comparable = (Comparable)object;
                return comparable.compareTo(object2);
            }
            return this.textuallyCompare(object, object2);
        }

        private int textuallyCompare(Object object, Object object2) {
            String string = object.toString();
            String string2 = object2.toString();
            return string.compareToIgnoreCase(string2);
        }
    }

    public static final class ResultChunkItem {
        private final CoreResponse.ResultChunk sourceChunk;
        private final ResourceItem resourceItem;
        private final int typePropertyIndex;
        private final List<SortCriterion.SortDirection> sortDirections;
        private final int[] sortColumns;

        private ResultChunkItem(CoreResponse.ResultChunk resultChunk, ResourceItem resourceItem, int n, List<SortCriterion.SortDirection> list, int[] nArray) {
            this.sourceChunk = resultChunk;
            this.resourceItem = resourceItem;
            this.typePropertyIndex = n;
            this.sortDirections = list;
            this.sortColumns = nArray;
        }

        public CoreResponse.ResultChunk getSourceChunk() {
            return this.sourceChunk;
        }

        public ResourceItem getResourceItem() {
            return this.resourceItem;
        }

        public String getItemType() {
            Object e = this.getResourceItem().getPropertyValues().get(this.typePropertyIndex);
            if (!(e instanceof String)) {
                throw new IllegalStateException("The value corresponding to @type is not a String");
            }
            return (String)e;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this).setExcludeFieldNames(new String[]{"sourceChunk"}).toString();
        }
    }
}

