/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import java.security.PrivateKey;

public final class SessionTokenSource
implements AuthenticationTokenSource {
    private final SsoService _ssoService;
    private final String _clientId;

    public SessionTokenSource(SsoService ssoService, String string) {
        this._ssoService = ssoService;
        this._clientId = string;
    }

    public SamlToken getAuthenticationToken() {
        SamlToken samlToken = AuthSessionUtil.getSsoToken((String)this._clientId);
        if (samlToken == null) {
            throw new IllegalStateException("Internal error: no SAML token present in the WebClient's session.");
        }
        return samlToken;
    }

    public PrivateKey getConfirmationKey() {
        PrivateKey privateKey = AuthSessionUtil.getSsoTokenPrivateKey((String)this._clientId);
        if (privateKey == null) {
            privateKey = this._ssoService.getHokPrivateKey();
        }
        return privateKey;
    }
}

