/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.alien;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.federation.VersionAnalyzer;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.QueryServiceConnection;
import com.vmware.vise.data.adapters.core.alien.AuthDataBasedAuthenticationTokenSource;
import com.vmware.vise.data.adapters.core.alien.LinkedVcGroupBasedServiceLocator;
import com.vmware.vise.data.adapters.core.alien.VcGuidFilterAnalyzer;
import com.vmware.vise.search.auth.AuthDataRegistryHelper;
import com.vmware.vise.search.auth.internal.AuthDataRegistryInternal;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistryListener;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlienVcAwareQueryService
implements CoreQueryService,
AutoCloseable,
LinkedVcGroupRegistryListener {
    private static final Logger _logger = LoggerFactory.getLogger(AlienVcAwareQueryService.class);
    private final QueryServiceConnectionPolicy _connectionPolicy;
    private final QueryServiceConnection _localQueryService;
    private final AuthDataRegistryInternal _authDataRegistry;
    private final ConcurrentMap<LinkedVcGroup, AlienQueryServiceInfo> _alienQueryServiceByVcGroup;

    public static AlienVcAwareQueryService withAlienVcSupport(QueryServiceConnectionPolicy queryServiceConnectionPolicy, QueryServiceConnection queryServiceConnection, String string) {
        assert (queryServiceConnectionPolicy != null);
        assert (queryServiceConnection != null);
        assert (string != null);
        AuthDataRegistryInternal authDataRegistryInternal = (AuthDataRegistryInternal)AuthDataRegistryHelper.getAuthDataRegistryByClientId((String)string);
        AlienVcAwareQueryService alienVcAwareQueryService = new AlienVcAwareQueryService(queryServiceConnectionPolicy, queryServiceConnection, authDataRegistryInternal);
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistryByClientId((String)string);
        linkedVcGroupRegistry.addLinkedVcGroupRegistryListener((LinkedVcGroupRegistryListener)alienVcAwareQueryService);
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupRegistry.getLinkedVcGroups()) {
            if (AlienVcAwareQueryService.isStartupGroup(linkedVcGroup, linkedVcGroupRegistry)) continue;
            alienVcAwareQueryService.onAddAlienVcGroup(linkedVcGroup);
        }
        return alienVcAwareQueryService;
    }

    private AlienVcAwareQueryService(QueryServiceConnectionPolicy queryServiceConnectionPolicy, QueryServiceConnection queryServiceConnection, AuthDataRegistryInternal authDataRegistryInternal) {
        assert (queryServiceConnectionPolicy != null);
        assert (queryServiceConnection != null);
        assert (authDataRegistryInternal != null);
        this._connectionPolicy = queryServiceConnectionPolicy;
        this._localQueryService = queryServiceConnection;
        this._authDataRegistry = authDataRegistryInternal;
        this._alienQueryServiceByVcGroup = new ConcurrentHashMap<LinkedVcGroup, AlienQueryServiceInfo>();
    }

    @Override
    public ResultSet executeQuery(Query query) {
        assert (query != null);
        QueryService queryService = this.chooseQueryService(query);
        return queryService.executeQuery(query);
    }

    @Override
    public QuerySchema getSchema() {
        return this._localQueryService.getQueryService().getSchema();
    }

    @Override
    public void close() throws Exception {
        AlienVcAwareQueryService.silentlyClose(this._localQueryService);
        for (AlienQueryServiceInfo alienQueryServiceInfo : this._alienQueryServiceByVcGroup.values()) {
            AlienVcAwareQueryService.silentlyClose(alienQueryServiceInfo.queryService);
        }
    }

    public void onGroupEvent(LinkedVcGroupRegistryListener.Event event) {
        assert (event != null);
        if (LinkedVcGroupRegistryListener.Event.GroupOp.add.equals((Object)event.operation)) {
            if (AlienVcAwareQueryService.isStartupGroupEvent(event)) {
                _logger.info("Skipping startup LinkedVcGroup responsible for VC GUIDs {}. Startup groups are not considered alien.", AlienVcAwareQueryService.getVcGuids(event.group.getVcServices()));
            } else {
                this.onAddAlienVcGroup(event.group);
            }
        } else if (LinkedVcGroupRegistryListener.Event.GroupOp.remove.equals((Object)event.operation)) {
            this.onRemoveAlienVcGroup(event.group);
        }
    }

    private void onAddAlienVcGroup(LinkedVcGroup linkedVcGroup) {
        assert (linkedVcGroup != null);
        this.logAlienLinkedVcGroup(linkedVcGroup);
        Collection<VcService> collection = AlienVcAwareQueryService.onlySupported(linkedVcGroup.getVcServices());
        if (collection.isEmpty()) {
            _logger.info("Ignore LinkedVcGroup with no supported VCs: {}", AlienVcAwareQueryService.getVcGuids(linkedVcGroup.getVcServices()));
            return;
        }
        AlienQueryServiceInfo alienQueryServiceInfo = this.createAlienQueryService(collection);
        AlienQueryServiceInfo alienQueryServiceInfo2 = this._alienQueryServiceByVcGroup.putIfAbsent(linkedVcGroup, alienQueryServiceInfo);
        if (alienQueryServiceInfo2 != null) {
            _logger.warn("Tried to register multiple times the same LinkedVcGroup {}", (Object)linkedVcGroup);
            AlienVcAwareQueryService.silentlyClose(alienQueryServiceInfo.queryService);
        } else {
            _logger.info("Registered alien LinkedVcGroup responsible for VC GUIDs {}", alienQueryServiceInfo.vcGuids);
        }
    }

    private void onRemoveAlienVcGroup(LinkedVcGroup linkedVcGroup) {
        assert (linkedVcGroup != null);
        AlienQueryServiceInfo alienQueryServiceInfo = (AlienQueryServiceInfo)this._alienQueryServiceByVcGroup.remove(linkedVcGroup);
        if (alienQueryServiceInfo != null) {
            _logger.info("Unregistered alien LinkedVcGroup responsible for VC GUIDs {}", alienQueryServiceInfo.vcGuids);
            AlienVcAwareQueryService.silentlyClose(alienQueryServiceInfo.queryService);
        }
    }

    private QueryService chooseQueryService(Query query) {
        assert (query != null);
        if (this._alienQueryServiceByVcGroup.isEmpty()) {
            _logger.trace("No alien VCs registered. Executing query on local DataService.");
            return this._localQueryService.getQueryService();
        }
        Set<String> set = VcGuidFilterAnalyzer.getVcGuidsForFilter(query.getFilter());
        if (set == null) {
            _logger.debug("Query targets no specific VC GUIDs. Executing query on local DataService.");
            return this._localQueryService.getQueryService();
        }
        _logger.debug("Query targets VC GUIDs {}", set);
        for (AlienQueryServiceInfo alienQueryServiceInfo : this._alienQueryServiceByVcGroup.values()) {
            if (!alienQueryServiceInfo.vcGuids.containsAll(set)) continue;
            _logger.debug("Executing query on alien DataService responsible for VC GUIDs {}", alienQueryServiceInfo.vcGuids);
            return alienQueryServiceInfo.queryService.getQueryService();
        }
        _logger.debug("Did not find alien DataService for VC GUIDs {}. Executing query on local DataService.", set);
        return this._localQueryService.getQueryService();
    }

    private void logAlienLinkedVcGroup(LinkedVcGroup linkedVcGroup) {
        if (!_logger.isInfoEnabled()) {
            return;
        }
        Collection collection = linkedVcGroup.getVcServices();
        _logger.info("Discovered alien LinkedVcGroup with {} VC services", (Object)collection.size());
        for (VcService vcService : collection) {
            _logger.info("Discovered alien VcService [url='{}', guid='{}', version='{}'] with service endpoints: {}", new Object[]{vcService.getServiceUrl(), vcService.getServiceGuid(), vcService.getServiceVersion(), Arrays.toString(vcService.getServiceEndPoints())});
        }
    }

    private AlienQueryServiceInfo createAlienQueryService(Collection<VcService> collection) {
        assert (collection != null);
        assert (!collection.isEmpty());
        LinkedVcGroupBasedServiceLocator linkedVcGroupBasedServiceLocator = new LinkedVcGroupBasedServiceLocator(collection);
        AuthenticationTokenSource authenticationTokenSource = AuthDataBasedAuthenticationTokenSource.forVcServices(collection, this._authDataRegistry);
        QueryServiceConnection queryServiceConnection = this._connectionPolicy.getConnection(linkedVcGroupBasedServiceLocator, authenticationTokenSource);
        Set<String> set = AlienVcAwareQueryService.getVcGuids(collection);
        return new AlienQueryServiceInfo(queryServiceConnection, set);
    }

    private static Set<String> getVcGuids(Collection<VcService> collection) {
        assert (collection != null);
        HashSet<String> hashSet = new HashSet<String>(collection.size());
        for (VcService vcService : collection) {
            hashSet.add(vcService.getServiceGuid());
        }
        return hashSet;
    }

    private static boolean isStartupGroupEvent(LinkedVcGroupRegistryListener.Event event) {
        assert (event != null);
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry((HttpSession)event.session);
        return AlienVcAwareQueryService.isStartupGroup(event.group, linkedVcGroupRegistry);
    }

    private static boolean isStartupGroup(LinkedVcGroup linkedVcGroup, LinkedVcGroupRegistry linkedVcGroupRegistry) {
        assert (linkedVcGroup != null);
        assert (linkedVcGroupRegistry != null);
        for (LinkedVcGroup linkedVcGroup2 : linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups()) {
            if (linkedVcGroup != linkedVcGroup2) continue;
            return true;
        }
        return false;
    }

    private static void silentlyClose(QueryServiceConnection queryServiceConnection) {
        assert (queryServiceConnection != null);
        try {
            queryServiceConnection.close();
        }
        catch (Exception exception) {
            _logger.debug("Error while closing query service", (Throwable)exception);
        }
    }

    private static Collection<VcService> onlySupported(Collection<VcService> collection) {
        assert (collection != null);
        ArrayList<VcService> arrayList = new ArrayList<VcService>(collection.size());
        for (VcService vcService : collection) {
            String string = vcService.getServiceVersion();
            if (VersionAnalyzer.isVersionBeforeRise((String)string)) {
                _logger.info("Will use InventoryService adapter for legacy alien VcService [url='{}', guid='{}', version='{}']", new Object[]{vcService.getServiceUrl(), vcService.getServiceGuid(), vcService.getServiceVersion()});
                continue;
            }
            if (VersionAnalyzer.isVersionTooNew((String)string)) {
                _logger.info("Ignore alien VcService because it is too new [url='{}', guid='{}', version='{}']", new Object[]{vcService.getServiceUrl(), vcService.getServiceGuid(), vcService.getServiceVersion()});
                continue;
            }
            arrayList.add(vcService);
        }
        return arrayList;
    }

    private static final class AlienQueryServiceInfo {
        final QueryServiceConnection queryService;
        final Set<String> vcGuids;

        AlienQueryServiceInfo(QueryServiceConnection queryServiceConnection, Set<String> set) {
            this.queryService = queryServiceConnection;
            this.vcGuids = set;
        }
    }

    public static interface QueryServiceConnectionPolicy {
        public QueryServiceConnection getConnection(ServiceLocator var1, AuthenticationTokenSource var2);
    }
}

