/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.alien;

import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.search.auth.AuthData;
import com.vmware.vise.search.auth.internal.AuthDataRegistryInternal;
import com.vmware.vise.search.transport.impl.QueryServiceUtil;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.security.PrivateKey;
import java.util.Collection;

final class AuthDataBasedAuthenticationTokenSource
implements AuthenticationTokenSource {
    private final AuthData _authData;

    static AuthenticationTokenSource forVcServices(Collection<VcService> collection, AuthDataRegistryInternal authDataRegistryInternal) {
        assert (collection != null);
        assert (authDataRegistryInternal != null);
        AuthData authData = AuthDataBasedAuthenticationTokenSource.getAuthData(collection, authDataRegistryInternal);
        return new AuthDataBasedAuthenticationTokenSource(authData);
    }

    private AuthDataBasedAuthenticationTokenSource(AuthData authData) {
        assert (authData != null);
        this._authData = authData;
    }

    public SamlToken getAuthenticationToken() {
        return this._authData.getToken();
    }

    public PrivateKey getConfirmationKey() {
        return this._authData.getPrivateKey();
    }

    private static AuthData getAuthData(Collection<VcService> collection, AuthDataRegistryInternal authDataRegistryInternal) {
        for (VcService vcService : collection) {
            AuthData authData = AuthDataBasedAuthenticationTokenSource.getAuthData(vcService, authDataRegistryInternal);
            if (authData == null) continue;
            return authData;
        }
        throw new IllegalArgumentException("Could not find AuthData for any of the VCs in: " + collection);
    }

    private static AuthData getAuthData(VcService vcService, AuthDataRegistryInternal authDataRegistryInternal) {
        ServiceEndpointEx serviceEndpointEx = QueryServiceUtil.getInventoryServiceEndpoint((VcService)vcService);
        String string = QueryServiceUtil.getSearchUrl((ServiceDirectory.ServiceEndpoint)serviceEndpointEx, (VcService)vcService);
        return authDataRegistryInternal.get(string);
    }
}

