/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.tagging;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.util.SchemaUtil;
import com.vmware.cis.data.internal.provider.util.property.PropertyByName;
import com.vmware.cis.data.internal.provider.util.property.PropertyByNameBackedByResourceItem;
import com.vmware.cis.data.internal.provider.util.property.ResourceItemPropertyByName;
import com.vmware.cis.data.internal.provider.util.property.ResourceItemPropertyValueByNameViaIndexMap;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.tagging.ModelTranslator;
import com.vmware.vise.data.adapters.core.tagging.PropertyTranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

final class PropertyTranslatingConnection
implements CoreQueryService {
    private final CoreQueryService _delegate;
    private final Map<String, ModelTranslator> _translatorByModel;
    private final Map<String, PropertyTranslator> _translatorByProperty;

    PropertyTranslatingConnection(CoreQueryService coreQueryService, Map<String, ModelTranslator> map, Map<String, PropertyTranslator> map2) {
        assert (coreQueryService != null);
        assert (map != null);
        assert (map2 != null);
        this._delegate = coreQueryService;
        this._translatorByModel = Collections.unmodifiableMap(map);
        this._translatorByProperty = Collections.unmodifiableMap(map2);
    }

    @Override
    public ResultSet executeQuery(Query query) {
        boolean bl;
        Validate.notNull((Object)query);
        boolean bl2 = this.skipSelect(query);
        boolean bl3 = this.skipModels(query);
        boolean bl4 = this.skipFilter(query);
        boolean bl5 = this.skipSort(query);
        boolean bl6 = bl = bl2 && bl3 && bl4 && bl5;
        if (bl) {
            return this._delegate.executeQuery(query);
        }
        List<String> list = bl2 ? query.getProperties() : this.translateSelect(query);
        List<String> list2 = bl3 ? query.getResourceModels() : this.translateModels(query);
        Filter filter = bl4 ? query.getFilter() : this.translateFilter(query);
        List<SortCriterion> list3 = bl5 ? query.getSortCriteria() : this.translateSort(query);
        Query query2 = Query.Builder.copyAndSelect((Query)query, list).from(list2).where(filter).orderBy(list3).build();
        ResultSet resultSet = this._delegate.executeQuery(query2);
        if (bl2) {
            return resultSet;
        }
        return this.translateResult(resultSet, query);
    }

    private boolean skipSelect(Query query) {
        assert (query != null);
        List list = query.getProperties();
        List list2 = query.getResourceModels();
        for (String string : list) {
            if (this.getPropertyTranslator(string, list2) == null) continue;
            return false;
        }
        return true;
    }

    private boolean skipModels(Query query) {
        assert (query != null);
        List list = query.getResourceModels();
        for (String string : list) {
            if (!this._translatorByModel.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    private boolean skipFilter(Query query) {
        assert (query != null);
        Filter filter = query.getFilter();
        List list = query.getResourceModels();
        if (filter == null) {
            return true;
        }
        for (PropertyPredicate propertyPredicate : filter.getCriteria()) {
            if (this.getPropertyTranslator(propertyPredicate.getProperty(), list) == null) continue;
            return false;
        }
        return true;
    }

    private boolean skipSort(Query query) {
        assert (query != null);
        List list = query.getSortCriteria();
        List list2 = query.getResourceModels();
        for (SortCriterion sortCriterion : list) {
            if (this.getPropertyTranslator(sortCriterion.getProperty(), list2) == null) continue;
            return false;
        }
        return true;
    }

    private List<String> translateSelect(Query query) {
        assert (query != null);
        List list = query.getProperties();
        List list2 = query.getResourceModels();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(list.size());
        for (String string : list) {
            linkedHashSet.add(this.translateSelectedProperty(string, list2));
        }
        return new ArrayList<String>(linkedHashSet);
    }

    private List<String> translateModels(Query query) {
        assert (query != null);
        List list = query.getResourceModels();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(list.size());
        for (String string : list) {
            linkedHashSet.add(this.translateModel(string));
        }
        return new ArrayList<String>(linkedHashSet);
    }

    private String translateModel(String string) {
        assert (string != null);
        ModelTranslator modelTranslator = this._translatorByModel.get(string);
        if (modelTranslator != null) {
            return modelTranslator.onModel(string);
        }
        return string;
    }

    private String translateSelectedProperty(String string, List<String> list) {
        assert (string != null);
        assert (list != null);
        PropertyTranslator propertyTranslator = this.getPropertyTranslator(string, list);
        if (propertyTranslator == null) {
            return string;
        }
        String string2 = propertyTranslator.onSelectedProperty(string);
        assert (string2 != null);
        return string2;
    }

    private Filter translateFilter(Query query) {
        assert (query != null);
        Filter filter = query.getFilter();
        List list = query.getResourceModels();
        if (filter == null) {
            return null;
        }
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>(filter.getCriteria().size());
        for (PropertyPredicate propertyPredicate : filter.getCriteria()) {
            arrayList.add(this.translatePredicate(propertyPredicate, list));
        }
        return new Filter(arrayList, filter.getOperator());
    }

    private PropertyPredicate translatePredicate(PropertyPredicate propertyPredicate, List<String> list) {
        assert (propertyPredicate != null);
        assert (list != null);
        String string = propertyPredicate.getProperty();
        PropertyTranslator propertyTranslator = this.getPropertyTranslator(string, list);
        if (propertyTranslator == null) {
            return propertyPredicate;
        }
        PropertyPredicate propertyPredicate2 = propertyTranslator.onPropertyPredicate(propertyPredicate);
        assert (propertyPredicate2 != null);
        return propertyPredicate2;
    }

    private List<SortCriterion> translateSort(Query query) {
        assert (query != null);
        List list = query.getSortCriteria();
        List list2 = query.getResourceModels();
        ArrayList<SortCriterion> arrayList = new ArrayList<SortCriterion>(list.size());
        for (SortCriterion sortCriterion : list) {
            arrayList.add(this.translateSort(sortCriterion, list2));
        }
        return arrayList;
    }

    private SortCriterion translateSort(SortCriterion sortCriterion, List<String> list) {
        assert (sortCriterion != null);
        assert (list != null);
        String string = sortCriterion.getProperty();
        PropertyTranslator propertyTranslator = this.getPropertyTranslator(string, list);
        if (propertyTranslator == null) {
            return sortCriterion;
        }
        SortCriterion sortCriterion2 = propertyTranslator.onSortCriterion(sortCriterion);
        assert (sortCriterion2 != null);
        return sortCriterion2;
    }

    private ResultSet translateResult(ResultSet resultSet, Query query) {
        assert (resultSet != null);
        assert (query != null);
        List list = query.getProperties();
        List list2 = query.getResourceModels();
        ResourceItemPropertyValueByNameViaIndexMap resourceItemPropertyValueByNameViaIndexMap = new ResourceItemPropertyValueByNameViaIndexMap(resultSet.getProperties());
        ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>(resultSet.getItems().size());
        for (ResourceItem resourceItem : resultSet.getItems()) {
            PropertyByNameBackedByResourceItem propertyByNameBackedByResourceItem = new PropertyByNameBackedByResourceItem(resourceItem, (ResourceItemPropertyByName)resourceItemPropertyValueByNameViaIndexMap);
            arrayList.add(this.translateItem((PropertyByName)propertyByNameBackedByResourceItem, list, list2));
        }
        return new ResultSet(list, arrayList, resultSet.getTotalCount());
    }

    private ResourceItem translateItem(PropertyByName propertyByName, List<String> list, List<String> list2) {
        assert (propertyByName != null);
        assert (list != null);
        assert (list2 != null);
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (String string : list) {
            arrayList.add(this.translatePropertyValue(string, propertyByName, list2));
        }
        return new ResourceItem(arrayList);
    }

    private Object translatePropertyValue(String string, PropertyByName propertyByName, List<String> list) {
        assert (string != null);
        assert (propertyByName != null);
        assert (list != null);
        PropertyTranslator propertyTranslator = this.getPropertyTranslator(string, list);
        if (propertyTranslator == null) {
            return propertyByName.getValue(string);
        }
        return propertyTranslator.onPropertyValue(string, propertyByName);
    }

    private PropertyTranslator getPropertyTranslator(String string, List<String> list) {
        assert (string != null);
        assert (list != null);
        if (PropertyUtil.isSpecialProperty((String)string)) {
            return this.getTranslatorForSpecialProperty(string, list);
        }
        return this._translatorByProperty.get(string);
    }

    private PropertyTranslator getTranslatorForSpecialProperty(String string, List<String> list) {
        assert (string != null);
        assert (list != null);
        for (String string2 : list) {
            PropertyTranslator propertyTranslator;
            ModelTranslator modelTranslator = this._translatorByModel.get(string2);
            if (modelTranslator == null || (propertyTranslator = modelTranslator.getTranslatorForSpecialProperty(string2, string)) == null) continue;
            return propertyTranslator;
        }
        return null;
    }

    @Override
    public QuerySchema getSchema() {
        String string2;
        HashMap<String, QuerySchema.PropertyInfo> hashMap = new HashMap<String, QuerySchema.PropertyInfo>(this._translatorByProperty.size());
        for (String string2 : this._translatorByProperty.keySet()) {
            PropertyTranslator propertyTranslator = this._translatorByProperty.get(string2);
            hashMap.put(string2, propertyTranslator.getPropertyInfo());
        }
        QuerySchema querySchema = this._delegate.getSchema();
        string2 = QuerySchema.forProperties(hashMap);
        return SchemaUtil.merge((QuerySchema)querySchema, (QuerySchema)string2);
    }
}

