/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.data.adapters.core.translator.TranslatorTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClauseReducer {
    private final LogicalOperator _operator;
    private final List<PropertyPredicate> _verbatimPredicates;
    private final Map<PredicateKey, ValueSet> _propertyValueSets;

    public ClauseReducer(LogicalOperator logicalOperator) {
        this._operator = logicalOperator;
        this._verbatimPredicates = new ArrayList<PropertyPredicate>();
        this._propertyValueSets = new LinkedHashMap<PredicateKey, ValueSet>();
    }

    public void addAll(Collection<PropertyPredicate> collection) {
        for (PropertyPredicate propertyPredicate : collection) {
            this.add(propertyPredicate);
        }
    }

    public void add(PropertyPredicate propertyPredicate) {
        if (ClauseReducer.isEqualityOperator(propertyPredicate.getOperator())) {
            this.addToValueSet(propertyPredicate);
        } else {
            this._verbatimPredicates.add(propertyPredicate);
        }
    }

    public List<PropertyPredicate> getEquivalent() {
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>(this._verbatimPredicates);
        for (PredicateKey predicateKey : this._propertyValueSets.keySet()) {
            ValueSet valueSet = this._propertyValueSets.get(predicateKey);
            List<PropertyPredicate> list = this._operator == LogicalOperator.AND ? this.translateIntersection(predicateKey, valueSet) : this.translateUnion(predicateKey, valueSet);
            if (list == null) {
                return null;
            }
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private void addToValueSet(PropertyPredicate propertyPredicate) {
        PredicateKey predicateKey = new PredicateKey(propertyPredicate);
        ValueSet valueSet = this._propertyValueSets.get(predicateKey);
        if (valueSet == null) {
            valueSet = new ValueSet();
            this._propertyValueSets.put(predicateKey, valueSet);
        }
        if (propertyPredicate.getOperator() == PropertyPredicate.ComparisonOperator.EQUAL || propertyPredicate.getOperator() == PropertyPredicate.ComparisonOperator.IN) {
            this.addInclusions(valueSet, propertyPredicate.getComparableValue());
        } else {
            assert (propertyPredicate.getOperator() == PropertyPredicate.ComparisonOperator.NOT_EQUAL);
            this.addExclusions(valueSet, propertyPredicate.getComparableValue());
        }
    }

    private void addInclusions(ValueSet valueSet, Object object) {
        boolean bl = this._operator == LogicalOperator.OR;
        valueSet.inclusionSet = this.updateValueSet(valueSet.inclusionSet, object, bl);
    }

    private void addExclusions(ValueSet valueSet, Object object) {
        boolean bl = this._operator == LogicalOperator.AND;
        valueSet.exclusionSet = this.updateValueSet(valueSet.exclusionSet, object, bl);
    }

    private List<PropertyPredicate> translateIntersection(PredicateKey predicateKey, ValueSet valueSet) {
        List<PropertyPredicate> list;
        assert (this._operator == LogicalOperator.AND);
        if (valueSet.inclusionSet == null) {
            list = new ArrayList<PropertyPredicate>(valueSet.exclusionSet.size());
            for (Object object : valueSet.exclusionSet) {
                PropertyPredicate propertyPredicate = new PropertyPredicate(predicateKey.property, PropertyPredicate.ComparisonOperator.NOT_EQUAL, object, predicateKey.ignoreCase);
                list.add(propertyPredicate);
            }
        } else {
            Set<Object> set;
            if (valueSet.exclusionSet == null) {
                set = valueSet.inclusionSet;
            } else {
                set = new LinkedHashSet<Object>(valueSet.inclusionSet);
                set.removeAll(valueSet.exclusionSet);
            }
            if (set.isEmpty()) {
                list = null;
            } else {
                PropertyPredicate propertyPredicate = TranslatorTools.toEqualityPredicate(predicateKey.property, set, predicateKey.ignoreCase);
                list = Collections.singletonList(propertyPredicate);
            }
        }
        return list;
    }

    private List<PropertyPredicate> translateUnion(PredicateKey predicateKey, ValueSet valueSet) {
        PropertyPredicate propertyPredicate;
        assert (this._operator == LogicalOperator.OR);
        if (valueSet.exclusionSet != null) {
            Set<Object> set;
            if (valueSet.inclusionSet == null) {
                set = valueSet.exclusionSet;
            } else {
                set = new LinkedHashSet<Object>(valueSet.exclusionSet);
                set.removeAll(valueSet.inclusionSet);
            }
            if (set.size() > 1) {
                throw new IllegalStateException("Bug: disjunction of equality predicates yielded multi-value exclusion set.");
            }
            if (set.size() == 1) {
                Object object = set.iterator().next();
                propertyPredicate = new PropertyPredicate(predicateKey.property, PropertyPredicate.ComparisonOperator.NOT_EQUAL, object, predicateKey.ignoreCase);
            } else {
                propertyPredicate = null;
            }
        } else {
            propertyPredicate = TranslatorTools.toEqualityPredicate(predicateKey.property, valueSet.inclusionSet, predicateKey.ignoreCase);
        }
        return propertyPredicate == null ? null : Collections.singletonList(propertyPredicate);
    }

    private static Collection<?> toCollection(Object object) {
        if (object instanceof Collection) {
            return (Collection)object;
        }
        return Collections.singleton(object);
    }

    private static boolean isEqualityOperator(PropertyPredicate.ComparisonOperator comparisonOperator) {
        return comparisonOperator == PropertyPredicate.ComparisonOperator.EQUAL || comparisonOperator == PropertyPredicate.ComparisonOperator.IN || comparisonOperator == PropertyPredicate.ComparisonOperator.NOT_EQUAL;
    }

    private Set<Object> updateValueSet(Set<Object> set, Object object, boolean bl) {
        if (set == null) {
            set = new LinkedHashSet(ClauseReducer.toCollection(object));
        } else if (bl) {
            set.addAll(ClauseReducer.toCollection(object));
        } else {
            set.retainAll(ClauseReducer.toCollection(object));
        }
        return set;
    }

    private static final class PredicateKey {
        final String property;
        final boolean ignoreCase;
        private final int computedHashCode;

        PredicateKey(PropertyPredicate propertyPredicate) {
            this.property = propertyPredicate.getProperty();
            this.ignoreCase = propertyPredicate.isIgnoreCase();
            this.computedHashCode = this.computeHashCode();
        }

        public boolean equals(Object object) {
            boolean bl;
            if (object instanceof PredicateKey) {
                PredicateKey predicateKey = (PredicateKey)object;
                bl = this.property.equals(predicateKey.property) && this.ignoreCase == predicateKey.ignoreCase;
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return this.computedHashCode;
        }

        private int computeHashCode() {
            int n = 23;
            n = 31 * n + this.property.hashCode();
            n = 31 * n + (this.ignoreCase ? 1 : 0);
            return n;
        }
    }

    private static final class ValueSet {
        Set<Object> inclusionSet = null;
        Set<Object> exclusionSet = null;

        private ValueSet() {
        }
    }
}

