/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.ClauseReducer;
import com.vmware.vise.data.adapters.core.translator.ConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.CoreResourceModelResolver;
import com.vmware.vise.data.adapters.core.translator.HeterogeneousResultBuilder;
import com.vmware.vise.data.adapters.core.translator.HomogeneousResultBuilder;
import com.vmware.vise.data.adapters.core.translator.ResultNegationTransformer;
import com.vmware.vise.data.adapters.core.translator.ResultSetTable;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.adapters.core.translator.TranslatorResolver;
import com.vmware.vise.data.adapters.core.translator.TranslatorTools;
import com.vmware.vise.data.query.CompositeConstraint;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

final class CompositeConstraintTranslator
implements ConstraintTranslator<CompositeConstraint> {
    private final TranslatorResolver _translatorResolver;
    private final RequestPropertyValidator _requestPropertyValidator;
    private final AggregatedModelLookup _aggregatedModelLookup;
    private final CoreResourceModelResolver _resourceModelResolver;

    public CompositeConstraintTranslator(TranslatorResolver translatorResolver, RequestPropertyValidator requestPropertyValidator, AggregatedModelLookup aggregatedModelLookup, CoreResourceModelResolver coreResourceModelResolver) {
        this._translatorResolver = translatorResolver;
        this._requestPropertyValidator = requestPropertyValidator;
        this._aggregatedModelLookup = aggregatedModelLookup;
        this._resourceModelResolver = coreResourceModelResolver;
    }

    @Override
    public Map<String, TranslationResult> translate(CoreQueryService coreQueryService, CompositeConstraint compositeConstraint) {
        Object[] objectArray = compositeConstraint.nestedConstraints;
        Validate.notEmpty((Object[])objectArray);
        if (objectArray.length == 1) {
            Object object = objectArray[0];
            return this._translatorResolver.getTranslator(object).translate(coreQueryService, object);
        }
        Map<String, HomogeneousResultBuilder.CompositeTranslationResult> map = this.translateCompositeConstraint(coreQueryService, compositeConstraint);
        HashMap<String, TranslationResult> hashMap = new HashMap<String, TranslationResult>();
        block5: for (Map.Entry<String, HomogeneousResultBuilder.CompositeTranslationResult> entry : map.entrySet()) {
            TranslationResult translationResult;
            String string = entry.getKey();
            HomogeneousResultBuilder.CompositeTranslationResult compositeTranslationResult = entry.getValue();
            switch (compositeTranslationResult.getOutcome()) {
                case MatchesNothing: {
                    continue block5;
                }
                case MatchesAll: {
                    translationResult = TranslationResult.all();
                    break;
                }
                case Filter: {
                    translationResult = this.translateExpression(coreQueryService, string, compositeTranslationResult.getExpression());
                    break;
                }
                default: {
                    throw ResultNegationTransformer.unexpectedOutcome(compositeTranslationResult.getOutcome());
                }
            }
            hashMap.put(string, translationResult);
        }
        return hashMap;
    }

    private Map<String, HomogeneousResultBuilder.CompositeTranslationResult> translateCompositeConstraint(CoreQueryService coreQueryService, CompositeConstraint compositeConstraint) {
        HeterogeneousResultBuilder heterogeneousResultBuilder = HeterogeneousResultBuilder.forConjoiner(compositeConstraint.conjoiner, this._requestPropertyValidator, this._aggregatedModelLookup);
        for (Constraint constraint : compositeConstraint.nestedConstraints) {
            Map<String, Object> map;
            if (constraint instanceof CompositeConstraint) {
                map = this.translateCompositeConstraint(coreQueryService, (CompositeConstraint)constraint);
                heterogeneousResultBuilder.addCompositeResults(map);
                continue;
            }
            map = this._translatorResolver.getTranslator(constraint).translate(coreQueryService, constraint);
            heterogeneousResultBuilder.addResults(map);
        }
        return this.runBuilders(heterogeneousResultBuilder.build());
    }

    private Map<String, HomogeneousResultBuilder.CompositeTranslationResult> runBuilders(Map<String, HomogeneousResultBuilder> map) {
        HashMap<String, HomogeneousResultBuilder.CompositeTranslationResult> hashMap = new HashMap<String, HomogeneousResultBuilder.CompositeTranslationResult>();
        for (Map.Entry<String, HomogeneousResultBuilder> entry : map.entrySet()) {
            String string = entry.getKey();
            HomogeneousResultBuilder.CompositeTranslationResult compositeTranslationResult = entry.getValue().build();
            hashMap.put(string, compositeTranslationResult);
        }
        return hashMap;
    }

    private TranslationResult translateExpression(CoreQueryService coreQueryService, String string, HomogeneousResultBuilder.PredicateTree predicateTree) {
        List<PropertyPredicate> list;
        LogicalOperator logicalOperator = predicateTree.getOperator();
        if (predicateTree.getSubTrees().isEmpty()) {
            return TranslationResult.filter(new Filter(predicateTree.getLeaves(), logicalOperator));
        }
        HashSet<Object> hashSet = null;
        for (HomogeneousResultBuilder.PredicateTree object2 : predicateTree.getSubTrees()) {
            Collection<Object> collection = this.evaluateToObjectIdSet(coreQueryService, string, object2);
            if (hashSet == null) {
                hashSet = new HashSet<Object>(collection);
            } else if (logicalOperator == LogicalOperator.AND) {
                hashSet.retainAll(collection);
            } else {
                assert (logicalOperator == LogicalOperator.OR);
                hashSet.addAll(collection);
            }
            if (!hashSet.isEmpty() || logicalOperator != LogicalOperator.AND) continue;
            return TranslationResult.empty();
        }
        ClauseReducer clauseReducer = new ClauseReducer(predicateTree.getOperator());
        clauseReducer.addAll(predicateTree.getLeaves());
        assert (!hashSet.isEmpty() || logicalOperator == LogicalOperator.OR);
        if (!hashSet.isEmpty()) {
            PropertyPredicate propertyPredicate = TranslatorTools.toEqualityPredicate("@modelKey", hashSet, false);
            clauseReducer.add(propertyPredicate);
        }
        if ((list = clauseReducer.getEquivalent()) == null) {
            if (logicalOperator == LogicalOperator.AND) {
                return TranslationResult.empty();
            }
            assert (logicalOperator == LogicalOperator.OR);
            return TranslationResult.all();
        }
        return TranslationResult.filter(new Filter(list, predicateTree.getOperator()));
    }

    private Collection<Object> evaluateToObjectIdSet(CoreQueryService coreQueryService, String string, HomogeneousResultBuilder.PredicateTree predicateTree) {
        TranslationResult translationResult = this.translateExpression(coreQueryService, string, predicateTree);
        Collection<Object> collection = TranslatorTools.tryGetKeysFromModelKeySet(translationResult);
        if (collection != null) {
            return collection;
        }
        ResultSet resultSet = new TranslatorTools.Select("CompositeConstraint", this._requestPropertyValidator, this._resourceModelResolver, coreQueryService).execute(string, translationResult, "@modelKey");
        return ResultSetTable.getKeys(resultSet);
    }
}

