/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.data.adapters.core.translator.ClauseReducer;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.HashCodeBuilder;

final class HomogeneousResultBuilder {
    private final LogicalOperator _operator;
    private TranslationResult.Outcome _knownOutcome;
    private List<PropertyPredicate> _leaves = new ArrayList<PropertyPredicate>();
    private List<PredicateTree> _subTrees = new ArrayList<PredicateTree>();

    public HomogeneousResultBuilder(LogicalOperator logicalOperator) {
        this._operator = logicalOperator;
        this._knownOutcome = null;
    }

    public HomogeneousResultBuilder add(TranslationResult translationResult) {
        this.combineOutcome(translationResult.getOutcome());
        if (this._knownOutcome != null) {
            return this;
        }
        if (translationResult.getOutcome() == TranslationResult.Outcome.Filter) {
            Filter filter = translationResult.getFilter();
            if (filter.getOperator() == this._operator) {
                this._leaves.addAll(filter.getCriteria());
            } else {
                this._subTrees.add(new PredicateTree(filter.getOperator(), null, filter.getCriteria()));
            }
        }
        return this;
    }

    public HomogeneousResultBuilder add(CompositeTranslationResult compositeTranslationResult) {
        this.combineOutcome(compositeTranslationResult.getOutcome());
        if (this._knownOutcome == null && compositeTranslationResult.getOutcome() == TranslationResult.Outcome.Filter) {
            PredicateTree predicateTree = compositeTranslationResult.getExpression();
            this.add(predicateTree);
        }
        return this;
    }

    public HomogeneousResultBuilder add(PredicateTree predicateTree) {
        if (this._operator == predicateTree.getOperator() || predicateTree.size() == 1) {
            this._leaves.addAll(predicateTree.getLeaves());
            this._subTrees.addAll(predicateTree.getSubTrees());
        } else {
            this._subTrees.add(predicateTree);
        }
        return this;
    }

    public CompositeTranslationResult build() {
        if (this._knownOutcome != null) {
            assert (this._knownOutcome != TranslationResult.Outcome.Filter);
            return new CompositeTranslationResult(this._knownOutcome, null);
        }
        if (this.isEmptyTree()) {
            return new CompositeTranslationResult(this.getOutcomeForEmptyTree(), null);
        }
        return this.getOptimizedResult();
    }

    private boolean isEmptyTree() {
        return this._subTrees.size() + this._leaves.size() == 0;
    }

    private TranslationResult.Outcome getOutcomeForEmptyTree() {
        if (this._operator == LogicalOperator.AND) {
            return TranslationResult.Outcome.MatchesAll;
        }
        assert (this._operator == LogicalOperator.OR);
        return TranslationResult.Outcome.MatchesNothing;
    }

    private void combineOutcome(TranslationResult.Outcome outcome) {
        if (outcome == null || this._knownOutcome != null) {
            return;
        }
        switch (outcome) {
            case MatchesNothing: {
                if (this._operator != LogicalOperator.AND) break;
                this._knownOutcome = TranslationResult.Outcome.MatchesNothing;
                break;
            }
            case MatchesAll: {
                if (this._operator != LogicalOperator.OR) break;
                this._knownOutcome = TranslationResult.Outcome.MatchesAll;
                break;
            }
            case Filter: {
                break;
            }
            default: {
                throw new IllegalStateException("Internal error (incomplete implementation): unknown TranslationResult.Outcome " + (Object)((Object)outcome));
            }
        }
    }

    private CompositeTranslationResult getOptimizedResult() {
        PredicateTree predicateTree2;
        ClauseReducer clauseReducer = new ClauseReducer(this._operator);
        clauseReducer.addAll(this._leaves);
        ArrayList<PredicateTree> arrayList = new ArrayList<PredicateTree>(this._subTrees.size());
        for (PredicateTree predicateTree2 : this._subTrees) {
            if ((predicateTree2 = HomogeneousResultBuilder.unpackSingleNodeSubtree(predicateTree2)).size() == 1) {
                assert (predicateTree2.getLeaves().size() == 1);
                clauseReducer.addAll(predicateTree2.getLeaves());
                continue;
            }
            arrayList.add(predicateTree2);
        }
        List<PropertyPredicate> list = clauseReducer.getEquivalent();
        if (list == null) {
            if (this._operator == LogicalOperator.AND) {
                return CompositeTranslationResult.empty();
            }
            assert (this._operator == LogicalOperator.OR);
            return CompositeTranslationResult.all();
        }
        if (list.isEmpty() && arrayList.size() == 1) {
            predicateTree2 = (PredicateTree)arrayList.get(0);
            return CompositeTranslationResult.expression(predicateTree2);
        }
        predicateTree2 = new PredicateTree(this._operator, arrayList, list);
        return CompositeTranslationResult.expression(predicateTree2);
    }

    private static PredicateTree unpackSingleNodeSubtree(PredicateTree predicateTree) {
        while (predicateTree.size() == 1) {
            if (predicateTree.getLeaves().size() == 1) {
                return predicateTree;
            }
            predicateTree = predicateTree.getSubTrees().get(0);
        }
        return predicateTree;
    }

    public static final class CompositeTranslationResult {
        private final TranslationResult.Outcome _outcome;
        private final PredicateTree _expression;

        private CompositeTranslationResult(TranslationResult.Outcome outcome, PredicateTree predicateTree) {
            this._outcome = outcome;
            this._expression = predicateTree;
        }

        public TranslationResult.Outcome getOutcome() {
            return this._outcome;
        }

        public PredicateTree getExpression() {
            return this._expression;
        }

        public static CompositeTranslationResult empty() {
            return new CompositeTranslationResult(TranslationResult.Outcome.MatchesNothing, null);
        }

        public static CompositeTranslationResult all() {
            return new CompositeTranslationResult(TranslationResult.Outcome.MatchesAll, null);
        }

        public static CompositeTranslationResult expression(PredicateTree predicateTree) {
            Validate.notNull((Object)predicateTree, (String)"Argument `expression' is required");
            return new CompositeTranslationResult(TranslationResult.Outcome.Filter, predicateTree);
        }

        public boolean equals(Object object) {
            boolean bl;
            if (object instanceof CompositeTranslationResult) {
                CompositeTranslationResult compositeTranslationResult = (CompositeTranslationResult)object;
                bl = this._outcome == compositeTranslationResult._outcome && ObjectUtils.equals((Object)this._expression, (Object)compositeTranslationResult._expression);
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 31).append((Object)this._outcome).append((Object)this._expression).toHashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getClass().getSimpleName()).append(": ");
            if (this._outcome != TranslationResult.Outcome.Filter) {
                stringBuilder.append((Object)this._outcome).append("()");
            } else {
                stringBuilder.append("expression ").append(this._expression);
            }
            return stringBuilder.toString();
        }
    }

    public static final class PredicateTree {
        private final LogicalOperator _operator;
        private final List<PropertyPredicate> _leaves;
        private final List<PredicateTree> _subTrees;

        public PredicateTree(LogicalOperator logicalOperator, List<PredicateTree> list, List<PropertyPredicate> list2) {
            Validate.notNull((Object)logicalOperator);
            this._operator = logicalOperator;
            this._leaves = list2 == null ? Collections.emptyList() : list2;
            this._subTrees = list == null ? Collections.emptyList() : list;
            Validate.isTrue((this.size() > 0 ? 1 : 0) != 0, (String)"At least one subTree or leaf is required.");
        }

        public LogicalOperator getOperator() {
            return this._operator;
        }

        public List<PropertyPredicate> getLeaves() {
            return this._leaves;
        }

        public List<PredicateTree> getSubTrees() {
            return this._subTrees;
        }

        public int size() {
            return this._leaves.size() + this._subTrees.size();
        }

        public boolean equals(Object object) {
            boolean bl;
            if (this == object) {
                bl = true;
            } else if (object instanceof PredicateTree) {
                PredicateTree predicateTree = (PredicateTree)object;
                bl = this._operator == predicateTree._operator && this._leaves.equals(predicateTree._leaves) && this._subTrees.equals(predicateTree._subTrees);
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 31).append((Object)this._operator).append(this._leaves).append(this._subTrees).toHashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            PredicateTree.predicateTreeToString(stringBuilder, 1, this);
            return stringBuilder.toString();
        }

        private static void predicateTreeToString(StringBuilder stringBuilder, int n, PredicateTree predicateTree) {
            String string = StringUtils.repeat((String)"  ", (int)n);
            stringBuilder.append("PredicateTree(").append(predicateTree.getOperator()).append(")[\n");
            for (PropertyPredicate object : predicateTree.getLeaves()) {
                stringBuilder.append(string).append(object).append(",\n");
            }
            for (PredicateTree predicateTree2 : predicateTree.getSubTrees()) {
                stringBuilder.append(string);
                PredicateTree.predicateTreeToString(stringBuilder, n + 1, predicateTree2);
                stringBuilder.append(",\n");
            }
            stringBuilder.append(string).append("]");
        }
    }
}

