/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.vise.data.adapters.core.CorePropertyConverter;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.InvalidPropertyNameException;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.AggregatedModelOps;
import com.vmware.vise.data.adapters.core.translator.ChildTypePropertyTranslator;
import com.vmware.vise.data.adapters.core.translator.ConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.FilterablePropertyHandler;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.adapters.core.translator.UnsetPropertyHandler;
import com.vmware.vise.data.query.PropertyConstraint;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public final class PropertyConstraintTranslator
implements ConstraintTranslator<PropertyConstraint> {
    private final RequestPropertyValidator _propertyValidator;
    private final CorePropertyConverter _propertyConverter;
    private final AggregatedModelLookup _aggregatedModelLookup;
    private final PropertyConstraintTranslationHandler[] _handlerChain;

    public PropertyConstraintTranslator(RequestPropertyValidator requestPropertyValidator, CorePropertyConverter corePropertyConverter, AggregatedModelLookup aggregatedModelLookup, PropertyConstraintTranslationHandler propertyConstraintTranslationHandler, PropertyConstraintTranslationHandler propertyConstraintTranslationHandler2) {
        this._propertyValidator = requestPropertyValidator;
        this._propertyConverter = corePropertyConverter;
        this._aggregatedModelLookup = aggregatedModelLookup;
        this._handlerChain = new PropertyConstraintTranslationHandler[]{new RejectInvalidProperties(), propertyConstraintTranslationHandler, new AtTypeFilterHandler(), new ChildTypePropertyTranslator(requestPropertyValidator, corePropertyConverter), new UnsetPropertyHandler(corePropertyConverter, requestPropertyValidator), new FilterablePropertyHandler(corePropertyConverter, requestPropertyValidator), propertyConstraintTranslationHandler2, new NullHandler()};
    }

    @Override
    public Map<String, TranslationResult> translate(CoreQueryService coreQueryService, PropertyConstraint propertyConstraint) {
        Validate.notEmpty((String)propertyConstraint.propertyName, (String)"PropertyConstraint without propertyName");
        Validate.notNull((Object)propertyConstraint.comparableValue, (String)"PropertyConstraint without comparableValue");
        Validate.notNull((Object)propertyConstraint.comparator, (String)"PropertyConstraint without comparator");
        for (PropertyConstraintTranslationHandler propertyConstraintTranslationHandler : this._handlerChain) {
            Map<String, TranslationResult> map = propertyConstraintTranslationHandler.tryTranslateConstraint(coreQueryService, propertyConstraint);
            if (map == null) continue;
            return map;
        }
        throw new UnsupportedOperationException(String.format("Failed to translate PropertyConstraint[targetType = %s; property = %s; comparator = %s; comparableValue = %s]", propertyConstraint.targetType, propertyConstraint.propertyName, propertyConstraint.comparator, propertyConstraint.comparableValue));
    }

    private final class NullHandler
    implements PropertyConstraintTranslationHandler {
        private NullHandler() {
        }

        @Override
        public Map<String, TranslationResult> tryTranslateConstraint(CoreQueryService coreQueryService, PropertyConstraint propertyConstraint) {
            String string = PropertyConstraintTranslator.this._propertyConverter.toCoreProperty(propertyConstraint.targetType, propertyConstraint.propertyName);
            if (PropertyConstraintTranslator.this._propertyValidator.canSelectByProperty(string)) {
                throw new UnsupportedOperationException(String.format("Filtering by non-filterable property requested: %s. No result will be returned for that filter.", string));
            }
            return Collections.emptyMap();
        }
    }

    private final class AtTypeFilterHandler
    implements PropertyConstraintTranslationHandler {
        private AtTypeFilterHandler() {
        }

        @Override
        public Map<String, TranslationResult> tryTranslateConstraint(CoreQueryService coreQueryService, PropertyConstraint propertyConstraint) {
            Set<String> set;
            if (!PropertyUtil.isType((String)propertyConstraint.propertyName)) {
                return null;
            }
            if (!(propertyConstraint.comparableValue instanceof String)) {
                throw new IllegalArgumentException("PropertyConstraint for @type needs comparableValue of type String, but got: " + propertyConstraint.comparableValue.getClass());
            }
            String string = (String)propertyConstraint.comparableValue;
            AggregatedModelOps aggregatedModelOps = new AggregatedModelOps(PropertyConstraintTranslator.this._aggregatedModelLookup);
            switch (propertyConstraint.comparator) {
                case EQUALS: {
                    set = aggregatedModelOps.intersection(propertyConstraint.targetType, string);
                    break;
                }
                case NOT_EQUALS: {
                    set = aggregatedModelOps.difference(propertyConstraint.targetType, string);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("PropertyConstraint for @type doesn't make sense with comparator = " + propertyConstraint.comparator);
                }
            }
            HashMap<String, TranslationResult> hashMap = new HashMap<String, TranslationResult>();
            for (String string2 : set) {
                hashMap.put(string2, TranslationResult.all());
            }
            return hashMap;
        }
    }

    private final class RejectInvalidProperties
    implements PropertyConstraintTranslationHandler {
        private RejectInvalidProperties() {
        }

        @Override
        public Map<String, TranslationResult> tryTranslateConstraint(CoreQueryService coreQueryService, PropertyConstraint propertyConstraint) {
            try {
                PropertyConstraintTranslator.this._propertyConverter.toCoreProperty(propertyConstraint.targetType, propertyConstraint.propertyName);
            }
            catch (InvalidPropertyNameException invalidPropertyNameException) {
                return Collections.emptyMap();
            }
            return null;
        }
    }

    public static interface PropertyConstraintTranslationHandler {
        public Map<String, TranslationResult> tryTranslateConstraint(CoreQueryService var1, PropertyConstraint var2);
    }
}

