/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.google.common.collect.ImmutableList;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.adapters.core.ReferenceConverter;
import com.vmware.vise.data.adapters.core.translator.CoreResourceModelResolver;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import java.util.List;
import org.apache.commons.lang.Validate;

public final class QuerySpecPreprocessor {
    private static final String ERROR_CLONE_FAILED = "Internal error/bug: cloning of a known clonable object has failed.";
    private static final List<String> MANAGED_ENTITY_ALIASES = ImmutableList.of((Object)"Object", (Object)"ManagedEntity");
    private static final List<String> ALL_MANAGED_ENTITIES = ImmutableList.of((Object)"Network", (Object)"OpaqueNetwork", (Object)"DistributedVirtualPortgroup", (Object)"ComputeResource", (Object)"ClusterComputeResource", (Object)"Datacenter", (Object)"Datastore", (Object)"Folder", (Object)"StoragePod", (Object)"HostSystem", (Object)"ResourcePool", (Object)"VirtualApp", (Object[])new String[]{"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch", "VirtualMachine"});
    private final CoreResourceModelResolver _typeInfoProvider;

    public QuerySpecPreprocessor(CoreResourceModelResolver coreResourceModelResolver) {
        this._typeInfoProvider = coreResourceModelResolver;
    }

    public QuerySpec prepareQuerySpec(QuerySpec querySpec) {
        QuerySpec querySpec2;
        try {
            querySpec2 = querySpec.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(ERROR_CLONE_FAILED, cloneNotSupportedException);
        }
        this.prepareResourceSpec(querySpec2.resourceSpec);
        return querySpec2;
    }

    private void prepareResourceSpec(ResourceSpec resourceSpec) {
        resourceSpec.constraint = this.prepareConstraint(resourceSpec.constraint);
    }

    private Constraint prepareConstraint(Constraint constraint) {
        if (QuerySpecPreprocessor.isBasicConstraint(constraint)) {
            return this.processConstraintTargetType(constraint);
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            return this.prepareObjectIdConstraint((ObjectIdentityConstraint)constraint);
        }
        if (constraint instanceof PropertyConstraint) {
            return this.preparePropertyConstraint((PropertyConstraint)constraint);
        }
        if (constraint instanceof RelationalConstraint) {
            return this.prepareRelationalConstraint((RelationalConstraint)constraint);
        }
        if (constraint instanceof CompositeConstraint) {
            return this.prepareCompositeConstraint((CompositeConstraint)constraint);
        }
        return constraint;
    }

    private Constraint prepareObjectIdConstraint(ObjectIdentityConstraint objectIdentityConstraint) {
        Validate.notNull((Object)objectIdentityConstraint.target, (String)"ObjectIdentityConstraint without target object.");
        objectIdentityConstraint.targetType = QuerySpecPreprocessor.tryGetResourceObjectType(objectIdentityConstraint.target);
        return objectIdentityConstraint;
    }

    private Constraint preparePropertyConstraint(PropertyConstraint propertyConstraint) {
        Validate.notNull((Object)propertyConstraint.comparator, (String)"PropertyConstraint without comparator.");
        return this.processConstraintTargetType((Constraint)propertyConstraint);
    }

    private Constraint prepareRelationalConstraint(RelationalConstraint relationalConstraint) {
        Validate.notNull((Object)relationalConstraint.constraintOnRelatedObject, (String)"RelationalConstraint without constraintOnRelatedObject.");
        Validate.notEmpty((String)relationalConstraint.relation, (String)"RelationalConstraint without relation property.");
        relationalConstraint.constraintOnRelatedObject = this.prepareConstraint(relationalConstraint.constraintOnRelatedObject);
        if (relationalConstraint.hasInverseRelation) {
            if (MANAGED_ENTITY_ALIASES.contains(relationalConstraint.targetType)) {
                relationalConstraint.targetType = null;
            }
            return relationalConstraint;
        }
        return this.processConstraintTargetType((Constraint)relationalConstraint);
    }

    private Constraint prepareCompositeConstraint(CompositeConstraint compositeConstraint) {
        Validate.notEmpty((Object[])compositeConstraint.nestedConstraints, (String)"CompositeConstraint without nestedConstraints.");
        Validate.notNull((Object)compositeConstraint.conjoiner, (String)"CompositeConstraint without conjoiner.");
        compositeConstraint.targetType = null;
        for (int i = 0; i < compositeConstraint.nestedConstraints.length; ++i) {
            compositeConstraint.nestedConstraints[i] = this.prepareConstraint(compositeConstraint.nestedConstraints[i]);
        }
        return compositeConstraint;
    }

    private Constraint processConstraintTargetType(Constraint constraint) {
        String string;
        if (constraint.targetType == null || MANAGED_ENTITY_ALIASES.contains(constraint.targetType)) {
            return this.createUnionForAllManagedEntities(constraint);
        }
        constraint.targetType = string = this._typeInfoProvider.toCoreResourceType(constraint.targetType);
        return constraint;
    }

    private Constraint createUnionForAllManagedEntities(Constraint constraint) {
        Constraint[] constraintArray = new Constraint[ALL_MANAGED_ENTITIES.size()];
        for (int i = 0; i < ALL_MANAGED_ENTITIES.size(); ++i) {
            constraintArray[i] = QuerySpecPreprocessor.copyConstraint(constraint);
            constraintArray[i].targetType = ALL_MANAGED_ENTITIES.get(i);
        }
        return QueryUtil.combineIntoSingleConstraint((Constraint[])constraintArray, (Conjoiner)Conjoiner.OR);
    }

    private static Constraint copyConstraint(Constraint constraint) {
        try {
            Constraint constraint2 = constraint.clone();
            return constraint2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(ERROR_CLONE_FAILED, cloneNotSupportedException);
        }
    }

    private static boolean isBasicConstraint(Constraint constraint) {
        return constraint != null && constraint.getClass().equals(Constraint.class);
    }

    private static String tryGetResourceObjectType(Object object) {
        try {
            return ReferenceConverter.getResourceObjectType(object);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }
}

