/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.adapters.core.CorePropertyConverter;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.InvalidPropertyNameException;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.AggregatedModelOps;
import com.vmware.vise.data.adapters.core.translator.ConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.CoreResourceModelResolver;
import com.vmware.vise.data.adapters.core.translator.ForwardRelationshipResolver;
import com.vmware.vise.data.adapters.core.translator.InverseRelationshipResolver;
import com.vmware.vise.data.adapters.core.translator.RelationshipInfo;
import com.vmware.vise.data.adapters.core.translator.RelationshipRegistry;
import com.vmware.vise.data.adapters.core.translator.SameInstanceRelationshipResolver;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.adapters.core.translator.TranslatorResolver;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.search.model.ModelUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelationalConstraintTranslator
implements ConstraintTranslator<RelationalConstraint> {
    private static final Map<String, String> SAME_INSTANCE_TYPE_BY_RELATIONSHIP = new ImmutableMap.Builder().put((Object)"Folder/hostProfile", (Object)"HostProfile").put((Object)"Folder/childrenLibraries", (Object)"com.vmware.content.Library").build();
    private static final Logger _logger = LoggerFactory.getLogger(RelationalConstraintTranslator.class);
    private final TranslatorResolver _translatorResolver;
    private final RequestPropertyValidator _propertyValidator;
    private final CorePropertyConverter _propertyConverter;
    private final CoreResourceModelResolver _resourceModelResolver;
    private final AggregatedModelLookup _aggregatedModelLookup;
    private final AggregatedModelOps _aggregatedModelOps;
    private final RelationshipRegistry _relationshipRegistry;

    public RelationalConstraintTranslator(TranslatorResolver translatorResolver, RequestPropertyValidator requestPropertyValidator, CorePropertyConverter corePropertyConverter, CoreResourceModelResolver coreResourceModelResolver, AggregatedModelLookup aggregatedModelLookup, RelationshipRegistry relationshipRegistry) {
        this._translatorResolver = translatorResolver;
        this._propertyValidator = requestPropertyValidator;
        this._propertyConverter = corePropertyConverter;
        this._resourceModelResolver = coreResourceModelResolver;
        this._aggregatedModelLookup = aggregatedModelLookup;
        this._aggregatedModelOps = new AggregatedModelOps(aggregatedModelLookup);
        this._relationshipRegistry = relationshipRegistry;
    }

    @Override
    public Map<String, TranslationResult> translate(CoreQueryService coreQueryService, RelationalConstraint relationalConstraint) {
        Function<CoreQueryService, Map<String, TranslationResult>> function;
        Validate.notNull((Object)coreQueryService, (String)"DataProviderConnection is null");
        Validate.notNull((Object)relationalConstraint, (String)"RelationalConstraint is null");
        Validate.notNull((Object)relationalConstraint.relation, (String)"RC.relation is null");
        Validate.notNull((Object)relationalConstraint.constraintOnRelatedObject, (String)"RC.constraintOnRelatedObject is null");
        if (!relationalConstraint.hasInverseRelation && relationalConstraint.targetType == null) {
            _logger.warn("Ignoring forward RelationalConstraint with null targetType on relation '{}'. Please specify targetType to avoid performance hit of unnecessary processing.", (Object)relationalConstraint.relation);
            return Collections.emptyMap();
        }
        Constraint constraint = relationalConstraint.constraintOnRelatedObject;
        Map<String, TranslationResult> map = this._translatorResolver.getTranslator(constraint).translate(coreQueryService, constraint);
        try {
            function = relationalConstraint.hasInverseRelation ? this.getResolverForInverseRelation(relationalConstraint.targetType, relationalConstraint.relation, map) : this.getResolverForForwardRelation(relationalConstraint.targetType, relationalConstraint.relation, map);
        }
        catch (InvalidPropertyNameException invalidPropertyNameException) {
            return Collections.emptyMap();
        }
        return (Map)function.apply((Object)coreQueryService);
    }

    private Function<CoreQueryService, Map<String, TranslationResult>> getResolverForForwardRelation(String string, String string2, Map<String, TranslationResult> map) {
        String string3 = this._propertyConverter.toCoreProperty(string, string2);
        RelationshipInfo relationshipInfo = this.findRelationshipInfo(string3);
        _logger.trace("getResolverForForwardRelation: forwardRelInfo({}.{}) = {}", new Object[]{string, string2, relationshipInfo});
        if (relationshipInfo != null && relationshipInfo.isMultiCardinality()) {
            Set<String> set = relationshipInfo.getInverseRelationships();
            assert (!set.isEmpty()) : "Empty inverse relationships set for " + string3;
            HashMultimap hashMultimap = HashMultimap.create((int)set.size(), (int)1);
            for (String string4 : set) {
                RelationshipInfo relationshipInfo2 = this._relationshipRegistry.getRelationship(string4);
                assert (relationshipInfo2 != null) : "Registry contains no info for relationship " + string4;
                for (String string5 : map.keySet()) {
                    String string6 = this.getRelationshipProjectionInType(relationshipInfo2, string5);
                    if (string6 == null) continue;
                    hashMultimap.put((Object)string5, (Object)string6);
                }
            }
            _logger.debug("VISE forward relation {}.{} will be handled with inverse Core relationships: {}", new Object[]{string, string2, hashMultimap});
            return new InverseRelationshipResolver(this._propertyValidator, this._resourceModelResolver, string, (Multimap<String, String>)hashMultimap, map);
        }
        return new ForwardRelationshipResolver(this._aggregatedModelLookup, this._propertyValidator, this._resourceModelResolver, string, string3, map);
    }

    private Function<CoreQueryService, Map<String, TranslationResult>> getResolverForInverseRelation(String string, String string2, Map<String, TranslationResult> map) {
        Object object;
        String string32;
        Iterator iterator;
        HashMultimap hashMultimap = HashMultimap.create((int)map.size(), (int)1);
        Object object2 = map.entrySet().iterator();
        while (object2.hasNext()) {
            iterator = object2.next();
            string32 = iterator.getKey();
            object = iterator.getValue();
            if (((TranslationResult)object).getOutcome() == TranslationResult.Outcome.MatchesNothing) continue;
            String string4 = this._propertyConverter.toCoreProperty(string32, string2);
            hashMultimap.put((Object)string32, (Object)string4);
        }
        if (hashMultimap.size() == 1 && (iterator = this.getSingleInverseOf((String)(object2 = (String)hashMultimap.values().iterator().next()))) != null && !((RelationshipInfo)((Object)iterator)).isMultiCardinality()) {
            string32 = ((RelationshipInfo)((Object)iterator)).getSourceType();
            object = ((RelationshipInfo)((Object)iterator)).getName();
            return new ForwardRelationshipResolver(this._aggregatedModelLookup, this._propertyValidator, this._resourceModelResolver, string32, (String)object, map);
        }
        if (SAME_INSTANCE_TYPE_BY_RELATIONSHIP.keySet().containsAll(hashMultimap.values())) {
            object2 = new HashSet(hashMultimap.size());
            for (String string32 : hashMultimap.values()) {
                object2.add(SAME_INSTANCE_TYPE_BY_RELATIONSHIP.get(string32));
            }
            return new SameInstanceRelationshipResolver(this._propertyValidator, this._resourceModelResolver, (Set<String>)object2, map);
        }
        object2 = string != null && ModelUtils.isQualifiedWithResourceModel((String)string2) ? string : null;
        return new InverseRelationshipResolver(this._propertyValidator, this._resourceModelResolver, (String)object2, (Multimap<String, String>)hashMultimap, map);
    }

    private RelationshipInfo getSingleInverseOf(String string) {
        RelationshipInfo relationshipInfo = this.findRelationshipInfo(string);
        if (relationshipInfo != null && relationshipInfo.getInverseRelationships().size() == 1) {
            return this._relationshipRegistry.getRelationship(relationshipInfo.getInverseRelationships().iterator().next());
        }
        return null;
    }

    private RelationshipInfo findRelationshipInfo(String string) {
        RelationshipInfo relationshipInfo = this._relationshipRegistry.getRelationship(string);
        if (relationshipInfo != null) {
            return relationshipInfo;
        }
        QualifiedProperty qualifiedProperty = QualifiedProperty.forQualifiedName((String)string);
        String string2 = qualifiedProperty.getResourceModel();
        if (ModelUtils.isVmodl2Name((String)string2)) {
            return null;
        }
        for (String string3 : this._aggregatedModelLookup.getAllAggregatedModels()) {
            String string4;
            RelationshipInfo relationshipInfo2;
            boolean bl = this._aggregatedModelLookup.getChildrenOfAggregatedModel(string3).containsAll(this._aggregatedModelOps.decomposition(string2));
            if (!bl || (relationshipInfo2 = this._relationshipRegistry.getRelationship(string4 = QualifiedProperty.forModelAndSimpleProperty((String)string3, (String)qualifiedProperty.getSimpleProperty()).toString())) == null) continue;
            return new RelationshipInfo(string, string2, relationshipInfo2.isMultiCardinality(), relationshipInfo2.getInverseRelationships());
        }
        return null;
    }

    private String getRelationshipProjectionInType(RelationshipInfo relationshipInfo, String string) {
        boolean bl;
        String string2 = relationshipInfo.getSourceType();
        if (string2.equals(string)) {
            return relationshipInfo.getName();
        }
        boolean bl2 = bl = !Sets.intersection(this._aggregatedModelOps.decomposition(string2), this._aggregatedModelOps.decomposition(string)).isEmpty();
        if (bl) {
            QualifiedProperty qualifiedProperty = QualifiedProperty.forQualifiedName((String)relationshipInfo.getName());
            String string3 = this._resourceModelResolver.getDefaultModel(string);
            return QualifiedProperty.forModelAndSimpleProperty((String)string3, (String)qualifiedProperty.getSimpleProperty()).toString();
        }
        return null;
    }
}

