/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.data.adapters.core.translator.HomogeneousResultBuilder;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public final class ResultNegationTransformer {
    public static HomogeneousResultBuilder.CompositeTranslationResult negateResult(TranslationResult translationResult) {
        switch (translationResult.getOutcome()) {
            case MatchesNothing: {
                return HomogeneousResultBuilder.CompositeTranslationResult.all();
            }
            case MatchesAll: {
                return HomogeneousResultBuilder.CompositeTranslationResult.empty();
            }
            case Filter: {
                return ResultNegationTransformer.negate(translationResult.getFilter());
            }
        }
        throw ResultNegationTransformer.unexpectedOutcome(translationResult.getOutcome());
    }

    public static HomogeneousResultBuilder.CompositeTranslationResult negateResult(HomogeneousResultBuilder.CompositeTranslationResult compositeTranslationResult) {
        switch (compositeTranslationResult.getOutcome()) {
            case MatchesNothing: {
                return HomogeneousResultBuilder.CompositeTranslationResult.all();
            }
            case MatchesAll: {
                return HomogeneousResultBuilder.CompositeTranslationResult.empty();
            }
            case Filter: {
                HomogeneousResultBuilder.PredicateTree predicateTree = ResultNegationTransformer.negate(compositeTranslationResult.getExpression());
                return HomogeneousResultBuilder.CompositeTranslationResult.expression(predicateTree);
            }
        }
        throw ResultNegationTransformer.unexpectedOutcome(compositeTranslationResult.getOutcome());
    }

    private static HomogeneousResultBuilder.PredicateTree negate(HomogeneousResultBuilder.PredicateTree predicateTree) {
        LogicalOperator logicalOperator = ResultNegationTransformer.negate(predicateTree.getOperator());
        ArrayList<HomogeneousResultBuilder.PredicateTree> arrayList = new ArrayList<HomogeneousResultBuilder.PredicateTree>(predicateTree.getSubTrees().size());
        ArrayList<PropertyPredicate> arrayList2 = new ArrayList<PropertyPredicate>(predicateTree.getLeaves().size());
        for (PropertyPredicate object : predicateTree.getLeaves()) {
            HomogeneousResultBuilder.PredicateTree predicateTree2 = ResultNegationTransformer.negate(object);
            if (predicateTree2.getLeaves().size() == 1) {
                assert (predicateTree2.size() == 1);
                arrayList2.addAll(predicateTree2.getLeaves());
                continue;
            }
            arrayList.add(predicateTree2);
        }
        for (HomogeneousResultBuilder.PredicateTree predicateTree3 : predicateTree.getSubTrees()) {
            arrayList.add(ResultNegationTransformer.negate(predicateTree3));
        }
        return new HomogeneousResultBuilder.PredicateTree(logicalOperator, arrayList, arrayList2);
    }

    private static HomogeneousResultBuilder.CompositeTranslationResult negate(Filter filter) {
        LogicalOperator logicalOperator = ResultNegationTransformer.negate(filter.getOperator());
        HomogeneousResultBuilder homogeneousResultBuilder = new HomogeneousResultBuilder(logicalOperator);
        for (PropertyPredicate propertyPredicate : filter.getCriteria()) {
            HomogeneousResultBuilder.PredicateTree predicateTree = ResultNegationTransformer.negate(propertyPredicate);
            homogeneousResultBuilder.add(predicateTree);
        }
        return homogeneousResultBuilder.build();
    }

    private static HomogeneousResultBuilder.PredicateTree negate(PropertyPredicate propertyPredicate) {
        PropertyPredicate.ComparisonOperator comparisonOperator = ResultNegationTransformer.negate(propertyPredicate.getOperator());
        if (propertyPredicate.getOperator() != PropertyPredicate.ComparisonOperator.IN) {
            PropertyPredicate propertyPredicate2 = new PropertyPredicate(propertyPredicate.getProperty(), comparisonOperator, propertyPredicate.getComparableValue(), propertyPredicate.isIgnoreCase());
            return new HomogeneousResultBuilder.PredicateTree(LogicalOperator.AND, null, Collections.singletonList(propertyPredicate2));
        }
        Collection collection = (Collection)propertyPredicate.getComparableValue();
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>(collection.size());
        for (Object e : collection) {
            arrayList.add(new PropertyPredicate(propertyPredicate.getProperty(), comparisonOperator, e, propertyPredicate.isIgnoreCase()));
        }
        return new HomogeneousResultBuilder.PredicateTree(LogicalOperator.AND, null, arrayList);
    }

    private static LogicalOperator negate(LogicalOperator logicalOperator) {
        return logicalOperator == LogicalOperator.AND ? LogicalOperator.OR : LogicalOperator.AND;
    }

    private static PropertyPredicate.ComparisonOperator negate(PropertyPredicate.ComparisonOperator comparisonOperator) {
        switch (comparisonOperator) {
            case EQUAL: {
                return PropertyPredicate.ComparisonOperator.NOT_EQUAL;
            }
            case NOT_EQUAL: {
                return PropertyPredicate.ComparisonOperator.EQUAL;
            }
            case GREATER: {
                return PropertyPredicate.ComparisonOperator.LESS_OR_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return PropertyPredicate.ComparisonOperator.LESS;
            }
            case LESS: {
                return PropertyPredicate.ComparisonOperator.GREATER_OR_EQUAL;
            }
            case LESS_OR_EQUAL: {
                return PropertyPredicate.ComparisonOperator.GREATER;
            }
            case IN: {
                return PropertyPredicate.ComparisonOperator.NOT_EQUAL;
            }
        }
        throw new IllegalStateException("Internal error/incomplete implementation: unexepected ComparisonOperator: " + comparisonOperator);
    }

    public static RuntimeException unexpectedOutcome(TranslationResult.Outcome outcome) {
        return new IllegalStateException("Internal error/incomplete implementation: unexepected Outcome: " + (Object)((Object)outcome));
    }
}

