/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.cis.data.internal.provider.util.TokenAnalyzer;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.translator.PropertyConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.adapters.core.translator.TranslatorResolver;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TextSearchConstraintTranslator
implements PropertyConstraintTranslator.PropertyConstraintTranslationHandler {
    private static final Logger _logger = LoggerFactory.getLogger(TextSearchConstraintTranslator.class);
    private final TranslatorResolver _translatorResolver;

    public TextSearchConstraintTranslator(TranslatorResolver translatorResolver) {
        assert (translatorResolver != null);
        this._translatorResolver = translatorResolver;
    }

    @Override
    public Map<String, TranslationResult> tryTranslateConstraint(CoreQueryService coreQueryService, PropertyConstraint propertyConstraint) {
        if (propertyConstraint.comparator == Comparator.TEXTUALLY_MATCHES) {
            return this.getFilterForTextSearch(coreQueryService, propertyConstraint);
        }
        return null;
    }

    private Map<String, TranslationResult> getFilterForTextSearch(CoreQueryService coreQueryService, PropertyConstraint propertyConstraint) {
        Object object2;
        assert (propertyConstraint.comparator == Comparator.TEXTUALLY_MATCHES);
        if (!(propertyConstraint.comparableValue instanceof String)) {
            String string = propertyConstraint.comparableValue == null ? "null" : propertyConstraint.comparableValue.getClass().getCanonicalName();
            _logger.warn("PropertyConstraint.comparableValue must be a String with the comparator is TEXTUALLY_MATCHES, but was: " + string);
            return Collections.emptyMap();
        }
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        String string = propertyConstraint.propertyName;
        String string2 = propertyConstraint.targetType;
        List list = TokenAnalyzer.getFTSTokens((String)((String)propertyConstraint.comparableValue));
        for (Object object2 : list) {
            String string3;
            PropertyConstraint propertyConstraint2 = null;
            List list2 = TokenAnalyzer.createLikeTokens((String)object2);
            if (list2.size() == 1) {
                string3 = (String)list2.get(0);
                propertyConstraint2 = this.createLikePropertyConstraint(string, string2, string3);
            } else {
                assert (list2.size() == 2);
                string3 = (String)list2.get(0);
                String string4 = (String)list2.get(1);
                propertyConstraint2 = this.createConjunction(string, string2, string3, string4);
            }
            arrayList.add((Constraint)propertyConstraint2);
        }
        Object object3 = arrayList.size() == 1 ? (Constraint)arrayList.get(0) : this.createCompositeConstraint(string2, arrayList);
        object2 = this._translatorResolver.getTranslator(object3).translate(coreQueryService, (Constraint)object3);
        return object2;
    }

    private PropertyConstraint createLikePropertyConstraint(String string, String string2, String string3) {
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.targetType = string2;
        propertyConstraint.comparableValue = string3;
        propertyConstraint.comparator = Comparator.CONTAINS;
        propertyConstraint.propertyName = string;
        return propertyConstraint;
    }

    private CompositeConstraint createConjunction(String string, String string2, String string3, String string4) {
        PropertyConstraint propertyConstraint = this.createLikePropertyConstraint(string, string2, string3);
        PropertyConstraint propertyConstraint2 = this.createLikePropertyConstraint(string, string2, string4);
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.targetType = string2;
        compositeConstraint.conjoiner = Conjoiner.AND;
        compositeConstraint.nestedConstraints = new Constraint[]{propertyConstraint, propertyConstraint2};
        return compositeConstraint;
    }

    private CompositeConstraint createCompositeConstraint(String string, List<Constraint> list) {
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.targetType = string;
        compositeConstraint.conjoiner = Conjoiner.OR;
        compositeConstraint.nestedConstraints = list.toArray(new Constraint[list.size()]);
        return compositeConstraint;
    }
}

