/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.cis.data.api.Filter;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class TranslationResult {
    private final Filter _coreFilter;
    private final Outcome _outcome;

    private TranslationResult(Filter filter, Outcome outcome) {
        this._coreFilter = filter;
        this._outcome = outcome;
    }

    public Outcome getOutcome() {
        return this._outcome;
    }

    public Filter getFilter() {
        return this._coreFilter;
    }

    public String toString() {
        String string = this._coreFilter != null ? this._coreFilter.toString() : this._outcome.toString() + "()";
        return string;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this._outcome).append((Object)this._coreFilter).toHashCode();
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof TranslationResult)) {
            bl = false;
        } else {
            TranslationResult translationResult = (TranslationResult)object;
            bl = this._outcome == translationResult._outcome && ObjectUtils.equals((Object)this._coreFilter, (Object)translationResult._coreFilter);
        }
        return bl;
    }

    public static TranslationResult empty() {
        return new TranslationResult(null, Outcome.MatchesNothing);
    }

    public static TranslationResult all() {
        return new TranslationResult(null, Outcome.MatchesAll);
    }

    public static TranslationResult filter(Filter filter) {
        return new TranslationResult(filter, Outcome.Filter);
    }

    public static enum Outcome {
        MatchesNothing,
        MatchesAll,
        Filter;

    }
}

