/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.util.QueryQualifier;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.CoreResourceModelResolver;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TranslatorTools {
    public static PropertyPredicate toEqualityPredicate(String string, Collection<? extends Object> collection, boolean bl) {
        List<? extends Object> list;
        PropertyPredicate.ComparisonOperator comparisonOperator;
        Validate.notEmpty(collection, (String)"The valueSet must be non-empty");
        if (collection.size() > 1) {
            comparisonOperator = PropertyPredicate.ComparisonOperator.IN;
            list = Collections.unmodifiableList(new ArrayList<Object>(collection));
        } else {
            comparisonOperator = PropertyPredicate.ComparisonOperator.EQUAL;
            list = collection.iterator().next();
        }
        return new PropertyPredicate(string, comparisonOperator, list, bl);
    }

    public static TranslationResult toEqualityPredicateResult(String string, Collection<?> collection, boolean bl) {
        if (collection.isEmpty()) {
            return TranslationResult.empty();
        }
        PropertyPredicate propertyPredicate = TranslatorTools.toEqualityPredicate(string, collection, bl);
        Filter filter = new Filter(Arrays.asList(propertyPredicate), LogicalOperator.AND);
        return TranslationResult.filter(filter);
    }

    public static Collection<Object> tryGetKeysFromModelKeySet(TranslationResult translationResult) {
        boolean bl;
        boolean bl2 = bl = translationResult.getOutcome() == TranslationResult.Outcome.Filter && translationResult.getFilter().getCriteria().size() == 1 && "@modelKey".equals(((PropertyPredicate)translationResult.getFilter().getCriteria().get(0)).getProperty());
        if (!bl) {
            return null;
        }
        PropertyPredicate propertyPredicate = (PropertyPredicate)translationResult.getFilter().getCriteria().get(0);
        if (propertyPredicate.getOperator() == PropertyPredicate.ComparisonOperator.EQUAL) {
            return Collections.singletonList(propertyPredicate.getComparableValue());
        }
        if (propertyPredicate.getOperator() == PropertyPredicate.ComparisonOperator.IN) {
            Collection collection = (Collection)propertyPredicate.getComparableValue();
            return collection;
        }
        return null;
    }

    public static final class Select {
        private static final Logger _logger = LoggerFactory.getLogger(Select.class);
        private final String _client;
        private final RequestPropertyValidator _propertyValidator;
        private final CoreResourceModelResolver _resourceModelResolver;
        private final CoreQueryService _queryService;

        public Select(String string, RequestPropertyValidator requestPropertyValidator, CoreResourceModelResolver coreResourceModelResolver, CoreQueryService coreQueryService) {
            this._client = string;
            this._propertyValidator = requestPropertyValidator;
            this._resourceModelResolver = coreResourceModelResolver;
            this._queryService = coreQueryService;
        }

        public ResultSet execute(String string, TranslationResult translationResult, String ... stringArray) {
            Object object;
            Validate.notNull((Object)stringArray, (String)"Argument `properties' is required.");
            if (translationResult.getOutcome() == TranslationResult.Outcome.MatchesNothing) {
                return new ResultSet(null, null);
            }
            List<String> list = this._propertyValidator.getSelectableProperties(Arrays.asList(stringArray));
            if (list.isEmpty()) {
                _logger.warn("{} translates to empty result set because the properties are not supported by the Core: {}", (Object)this._client, (Object)stringArray);
                return new ResultSet(null, null);
            }
            List list2 = QueryQualifier.getFromClause(list, (Filter)translationResult.getFilter(), Collections.emptyList());
            if (list2.isEmpty()) {
                object = this._resourceModelResolver.getDefaultModel(string);
                if (!this._propertyValidator.isModelSupported((String)object)) {
                    _logger.warn("Model '{}' extracted for type '{}' is not supported", object, (Object)string);
                    return ResultSet.Builder.properties(list).build();
                }
                this._propertyValidator.isModelSupported((String)object);
                list2.add(object);
            }
            object = translationResult.getFilter();
            Query query = Query.Builder.select(list).from(list2).where(object).build();
            _logger.debug("Dispatching nested query to evaluate {}: {}", (Object)this._client, (Object)query);
            ResultSet resultSet = this._queryService.executeQuery(query);
            return resultSet;
        }
    }
}

