/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator.cornercase;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.translator.ClauseReducer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class AllowMultipleModelKeyPredicates
implements CoreQueryService {
    private final CoreQueryService _delegate;

    public AllowMultipleModelKeyPredicates(CoreQueryService coreQueryService) {
        this._delegate = coreQueryService;
    }

    @Override
    public QuerySchema getSchema() {
        return this._delegate.getSchema();
    }

    @Override
    public ResultSet executeQuery(Query query) {
        if (query.getFilter() == null || !this.hasMultipleModelKeyPredicates(query.getFilter().getCriteria())) {
            return this._delegate.executeQuery(query);
        }
        List<PropertyPredicate> list = this.reduceQueryCrtieria(query);
        if (list == null) {
            return this.executeForEmptyReducedCriteria(query);
        }
        if (!this.hasMultipleModelKeyPredicates(list)) {
            return this.executeForSimpleReducedCriteria(query, list);
        }
        return this.executeForMultiModelKeyCriteria(query, list);
    }

    private ResultSet executeForEmptyReducedCriteria(Query query) {
        if (query.getFilter().getOperator() == LogicalOperator.AND) {
            return new ResultSet(null, null, Integer.valueOf(0));
        }
        assert (query.getFilter().getOperator() == LogicalOperator.OR);
        Query query2 = Query.Builder.copy((Query)query).where((Filter)null).build();
        return this._delegate.executeQuery(query2);
    }

    private ResultSet executeForSimpleReducedCriteria(Query query, List<PropertyPredicate> list) {
        Filter filter = new Filter(list, query.getFilter().getOperator());
        Query query2 = Query.Builder.copy((Query)query).where(filter).build();
        return this._delegate.executeQuery(query2);
    }

    private ResultSet executeForMultiModelKeyCriteria(Query query, List<PropertyPredicate> list) {
        ModelKeyQuerySplit modelKeyQuerySplit = this.split(query, list);
        ResultSet resultSet = this._delegate.executeQuery(modelKeyQuerySplit.baseQuery);
        return this.adaptResultToOriginalQuery(resultSet, query, modelKeyQuerySplit.excludedObjectsSet);
    }

    private ResultSet adaptResultToOriginalQuery(ResultSet resultSet, Query query, Set<Object> set) {
        long l = query.getOffset();
        long l2 = query.getLimit() < 0 ? Long.MAX_VALUE : (long)query.getLimit();
        int n = 0;
        ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>(resultSet.getItems().size());
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Object object = resultSet.getModelKey(resourceItem);
            if (set.contains(object)) {
                ++n;
                continue;
            }
            if (l > 0L) {
                --l;
                continue;
            }
            if ((long)arrayList.size() >= l2) continue;
            arrayList.add(resourceItem);
        }
        Iterator iterator = resultSet.getTotalCount() == null ? null : Integer.valueOf(resultSet.getTotalCount() - n);
        return new ResultSet(resultSet.getProperties(), arrayList, iterator);
    }

    private ModelKeyQuerySplit split(Query query, List<PropertyPredicate> list) {
        ArrayList<String> arrayList;
        Object object2;
        assert (list.size() > 1);
        ArrayList<PropertyPredicate> arrayList2 = new ArrayList<PropertyPredicate>(list.size());
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object2 : list) {
            if (PropertyUtil.isModelKey((String)object2.getProperty()) && object2.getOperator() == PropertyPredicate.ComparisonOperator.NOT_EQUAL) {
                hashSet.add(object2.getComparableValue());
                continue;
            }
            arrayList2.add((PropertyPredicate)object2);
        }
        if (query.getProperties().contains("@modelKey")) {
            arrayList = query.getProperties();
        } else {
            arrayList = new ArrayList<String>(query.getProperties());
            arrayList.add("@modelKey");
        }
        object2 = arrayList2.isEmpty() ? null : new Filter(arrayList2, query.getFilter().getOperator());
        Query query2 = Query.Builder.copyAndSelect((Query)query, arrayList).where((Filter)object2).offset(0).limit(-1).build();
        return new ModelKeyQuerySplit(query2, hashSet);
    }

    private List<PropertyPredicate> reduceQueryCrtieria(Query query) {
        Filter filter = query.getFilter();
        assert (filter != null);
        if (filter.getCriteria().size() == 1) {
            return filter.getCriteria();
        }
        ClauseReducer clauseReducer = new ClauseReducer(filter.getOperator());
        clauseReducer.addAll(filter.getCriteria());
        List<PropertyPredicate> list = clauseReducer.getEquivalent();
        return list;
    }

    private boolean hasMultipleModelKeyPredicates(List<PropertyPredicate> list) {
        int n = 0;
        Iterator<PropertyPredicate> iterator = list.iterator();
        while (iterator.hasNext() && n < 2) {
            PropertyPredicate propertyPredicate = iterator.next();
            if (!PropertyUtil.isModelKey((String)propertyPredicate.getProperty())) continue;
            ++n;
        }
        return n > 1;
    }

    private static final class ModelKeyQuerySplit {
        public final Query baseQuery;
        public final Set<Object> excludedObjectsSet;

        public ModelKeyQuerySplit(Query query, Set<Object> set) {
            this.baseQuery = query;
            this.excludedObjectsSet = set;
        }
    }
}

