/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.risetovise;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.List;

final class PropertyQualifyingDataProvider
implements DataProvider {
    private final DataProvider _dataProvider;

    public PropertyQualifyingDataProvider(DataProvider dataProvider) {
        assert (dataProvider != null);
        this._dataProvider = dataProvider;
    }

    public ResultSet executeQuery(Query query) {
        assert (query != null);
        assert (!query.getResourceModels().isEmpty());
        if (query.getResourceModels().size() > 1) {
            throw new UnsupportedOperationException("Query for multiple models is not yet supported: " + query);
        }
        String string = (String)query.getResourceModels().get(0);
        List<String> list = PropertyQualifyingDataProvider.qualifySelect(query.getProperties(), string);
        Filter filter = PropertyQualifyingDataProvider.qualify(query.getFilter(), string);
        List<SortCriterion> list2 = PropertyQualifyingDataProvider.qualify(query.getSortCriteria(), string);
        if (list == query.getProperties() && filter == query.getFilter() && list2 == query.getSortCriteria()) {
            return this._dataProvider.executeQuery(query);
        }
        Query query2 = Query.Builder.copyAndSelect((Query)query, list).where(filter).orderBy(list2).build();
        ResultSet resultSet = this._dataProvider.executeQuery(query2);
        ResultSet resultSet2 = PropertyQualifyingDataProvider.restorePropertyNames(resultSet, query.getProperties(), list);
        return resultSet2;
    }

    public QuerySchema getSchema() {
        return this._dataProvider.getSchema();
    }

    private static List<String> qualifySelect(List<String> list, String string) {
        assert (list != null);
        assert (string != null);
        if (PropertyQualifyingDataProvider.isQualifiedSelect(list, string)) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string2 : list) {
            arrayList.add(PropertyQualifyingDataProvider.qualify(string2, string));
        }
        return arrayList;
    }

    private static boolean isQualifiedSelect(List<String> list, String string) {
        assert (list != null);
        assert (string != null);
        for (String string2 : list) {
            if (PropertyQualifyingDataProvider.isQualified(string2, string)) continue;
            return false;
        }
        return true;
    }

    private static Filter qualify(Filter filter, String string) {
        assert (string != null);
        if (PropertyQualifyingDataProvider.isQualifiedFilter(filter, string)) {
            return filter;
        }
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>(filter.getCriteria().size());
        for (PropertyPredicate propertyPredicate : filter.getCriteria()) {
            arrayList.add(PropertyQualifyingDataProvider.qualify(propertyPredicate, string));
        }
        return new Filter(arrayList, filter.getOperator());
    }

    private static boolean isQualifiedFilter(Filter filter, String string) {
        assert (string != null);
        if (filter == null) {
            return true;
        }
        for (PropertyPredicate propertyPredicate : filter.getCriteria()) {
            if (PropertyQualifyingDataProvider.isQualified(propertyPredicate.getProperty(), string)) continue;
            return false;
        }
        return true;
    }

    private static PropertyPredicate qualify(PropertyPredicate propertyPredicate, String string) {
        assert (propertyPredicate != null);
        assert (string != null);
        PropertyPredicate propertyPredicate2 = new PropertyPredicate(PropertyQualifyingDataProvider.qualify(propertyPredicate.getProperty(), string), propertyPredicate.getOperator(), propertyPredicate.getComparableValue(), propertyPredicate.isIgnoreCase());
        return propertyPredicate2;
    }

    private static List<SortCriterion> qualify(List<SortCriterion> list, String string) {
        assert (list != null);
        assert (string != null);
        if (PropertyQualifyingDataProvider.isQualifiedSort(list, string)) {
            return list;
        }
        ArrayList<SortCriterion> arrayList = new ArrayList<SortCriterion>(list.size());
        for (SortCriterion sortCriterion : list) {
            arrayList.add(PropertyQualifyingDataProvider.qualify(sortCriterion, string));
        }
        return arrayList;
    }

    private static boolean isQualifiedSort(List<SortCriterion> list, String string) {
        assert (list != null);
        assert (string != null);
        for (SortCriterion sortCriterion : list) {
            if (PropertyQualifyingDataProvider.isQualified(sortCriterion.getProperty(), string)) continue;
            return false;
        }
        return true;
    }

    private static SortCriterion qualify(SortCriterion sortCriterion, String string) {
        assert (sortCriterion != null);
        assert (string != null);
        SortCriterion sortCriterion2 = new SortCriterion(PropertyQualifyingDataProvider.qualify(sortCriterion.getProperty(), string), sortCriterion.getSortDirection(), sortCriterion.isIgnoreCase());
        return sortCriterion2;
    }

    private static ResultSet restorePropertyNames(ResultSet resultSet, List<String> list, List<String> list2) {
        assert (resultSet != null);
        assert (list != null);
        assert (list2 != null);
        assert (list.size() == list2.size());
        assert (resultSet.getProperties().size() <= list.size());
        if (resultSet.getProperties().isEmpty()) {
            return resultSet;
        }
        ArrayList<String> arrayList = new ArrayList<String>(resultSet.getProperties().size());
        for (String string : resultSet.getProperties()) {
            int n = list2.indexOf(string);
            if (n < 0) {
                throw new IllegalArgumentException("ResultSet contains property that was not requested: " + string);
            }
            String string2 = list.get(n);
            arrayList.add(string2);
        }
        return new ResultSet(arrayList, resultSet.getItems(), resultSet.getTotalCount(), resultSet.getCursor());
    }

    private static String qualify(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        if (PropertyQualifyingDataProvider.isQualified(string, string2)) {
            return string;
        }
        return string2 + '/' + string;
    }

    private static boolean isQualified(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        if (PropertyUtil.isSpecialProperty((String)string)) {
            return true;
        }
        return string.startsWith(string2) && string.length() > string2.length() && string.charAt(string2.length()) == '/';
    }
}

