/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.risetovise;

import com.google.common.collect.ImmutableSet;
import com.vmware.cis.data.api.Query;
import com.vmware.vise.data.adapters.core.translator.ViseResourceTypeResolver;
import java.util.Set;

final class RiseToViseFromClause {
    private static final Set<String> ABSTRACT_BASE_TYPES = ImmutableSet.of((Object)"Object", (Object)"ManagedObject", (Object)"ManagedEntity");
    private final ViseResourceTypeResolver _viseTypeResolver;

    public RiseToViseFromClause(ViseResourceTypeResolver viseResourceTypeResolver) {
        assert (viseResourceTypeResolver != null);
        this._viseTypeResolver = viseResourceTypeResolver;
    }

    public String getResourceType(Query query) {
        assert (query != null);
        assert (query.getResourceModels() != null);
        assert (!query.getResourceModels().isEmpty());
        if (query.getResourceModels().size() > 1) {
            throw new UnsupportedOperationException("Query for multiple models is not yet supported: " + query);
        }
        String string = (String)query.getResourceModels().get(0);
        if (ABSTRACT_BASE_TYPES.contains(string)) {
            throw new IllegalArgumentException("Abstract base types cannot be used as resource models: " + string);
        }
        String string2 = this._viseTypeResolver.toViseResourceType(string);
        return string2;
    }
}

