/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.risetovise;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.vise.data.adapters.risetovise.RiseToViseProperty;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.SortType;
import java.util.List;

final class RiseToViseOrderByClause {
    private final RiseToViseProperty _propertyConverter;

    public RiseToViseOrderByClause(RiseToViseProperty riseToViseProperty) {
        assert (riseToViseProperty != null);
        this._propertyConverter = riseToViseProperty;
    }

    public ResultSpec toResultSpec(Query query, String string) {
        assert (query != null);
        assert (string != null);
        if (query.getSortCriteria().isEmpty() && query.getLimit() < 0) {
            return null;
        }
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = query.getLimit();
        resultSpec.offset = query.getOffset();
        resultSpec.order = this.toOrderingCriteria(query.getSortCriteria(), string);
        return resultSpec;
    }

    private OrderingCriteria toOrderingCriteria(List<SortCriterion> list, String string) {
        assert (list != null);
        assert (string != null);
        if (list.isEmpty()) {
            return null;
        }
        OrderingCriteria orderingCriteria = new OrderingCriteria();
        orderingCriteria.orderingProperties = new OrderingPropertySpec[list.size()];
        int n = 0;
        for (SortCriterion sortCriterion : list) {
            orderingCriteria.orderingProperties[n++] = this.toOrderingPropertySpec(sortCriterion, string);
        }
        return orderingCriteria;
    }

    private OrderingPropertySpec toOrderingPropertySpec(SortCriterion sortCriterion, String string) {
        OrderingPropertySpec orderingPropertySpec = new OrderingPropertySpec();
        if ("@modelKey".equals(sortCriterion.getProperty())) {
            orderingPropertySpec.type = "Object";
            orderingPropertySpec.propertyNames = new String[]{"id"};
        } else {
            orderingPropertySpec.propertyNames = new String[]{this.toViseProperty(sortCriterion.getProperty())};
        }
        orderingPropertySpec.orderingType = RiseToViseOrderByClause.toOrderingType(sortCriterion.getSortDirection());
        return orderingPropertySpec;
    }

    private static SortType toOrderingType(SortCriterion.SortDirection sortDirection) {
        switch (sortDirection) {
            case ASCENDING: {
                return SortType.ASCENDING;
            }
            case DESCENDING: {
                return SortType.DESCENDING;
            }
        }
        throw new IllegalStateException("Unknown sort direction: " + sortDirection);
    }

    private String toViseProperty(String string) {
        return this._propertyConverter.toViseProperty(string);
    }
}

