/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.risetovise;

import com.vmware.cis.data.internal.util.QualifiedProperty;
import org.apache.commons.lang.StringUtils;

final class RiseToViseProperty {
    private static final String MOID_SUFFIX = "@moId";
    private static final String PROPERTY_SERVER_GUID = "serverGuid";
    private static final String CORE_API_PROPERTY_LENGTH_SUFFIX = "/length";
    private static final String CORE_API_PROPERTY_LENGTH_SUFFIX_REPLACEMENT = "/_length";
    private static final char VISE_API_VMODL1_PROPERTY_PATH_SEPARATOR = '.';
    private static final String VMWARE_PKG_PREFIX = "com.vmware.";

    RiseToViseProperty() {
    }

    public String toViseProperty(String string) {
        assert (string != null);
        if ("@modelKey".equals(string)) {
            return string;
        }
        if ("@type".equals(string)) {
            return string;
        }
        if (string.endsWith(MOID_SUFFIX)) {
            throw new UnsupportedOperationException("Support for @moId is not yet implemented");
        }
        QualifiedProperty qualifiedProperty = QualifiedProperty.forQualifiedName((String)string);
        if ("@instanceUuid".equals(qualifiedProperty.getSimpleProperty())) {
            return PROPERTY_SERVER_GUID;
        }
        String string2 = qualifiedProperty.getSimpleProperty();
        if (string2.endsWith(CORE_API_PROPERTY_LENGTH_SUFFIX)) {
            string2 = StringUtils.removeEnd((String)string2, (String)CORE_API_PROPERTY_LENGTH_SUFFIX) + CORE_API_PROPERTY_LENGTH_SUFFIX_REPLACEMENT;
        }
        if (qualifiedProperty.getResourceModel().startsWith(VMWARE_PKG_PREFIX)) {
            return QualifiedProperty.forModelAndSimpleProperty((String)qualifiedProperty.getResourceModel(), (String)string2).toString();
        }
        string2 = string2.replace('/', '.');
        return string2;
    }
}

